package autochanger

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.description.groovy.CCSBuilder



def acPlutoGatewayName = "acSensorsGateway" // to monitor the autochanger sensors

CCSBuilder builder = ["autochanger-standalone-simu"]

builder.
    main (AutochangerMain, bridge:ref("tcpProxy"), carousel:ref("carousel"), loader:ref("loader")) {
    //begin description of Main submodules
    //-------------------------
    // BEGIN Filter Manager description
    filterManager(FilterManager) {//begin description of filter manager's children
        filterU (Filter,filterID:29, weight:38)
        filterG (Filter,filterID:3, weight:33)
        filterR (Filter,filterID:60, weight:30)
        filterI (Filter,filterID:34, weight:28)
        filterZ (Filter,filterID:17, weight:28)
        filterY (Filter,filterID:15, weight:22.5)
        dummyFilter (Filter,filterID:46,weight:44.5)
    }//end description of filter manager's children
    // END Filter Manager description
    // ------------------------------
    
    
    // tcp Proxy
    tcpProxy (CanOpenProxy, hardwareBootTimeout:1000) {
        
        canInterface(SimuCanOpenInterface)
        
        // can open devices
        "$acPlutoGatewayName" (SimuAutochangerStandalonePlutoGateway,
            nodeID:0x3a,serialNB:"3269")
        
        brakeSystemGateway (CanOpenPlutoGateway,
            nodeID:0x2b,serialNB:"2071")
        
        onlineStrainGauge (SimuCanOpenStrainGauge, nodeID: 0x21, serialNB:"0")
        
        proximitySensorsDevice (CanCBXAI420, nodeID: 0x22, serialNB:"c7c60331")
        
        tempSensorsDevice (CanOpenSystecIO, nodeID: 0x20, serialNB:"4bb6b")
        
        // can open devices
        linearRailMasterController (SimuAutochangerLinearRailController,    
            nodeID:0x2a,serialNB:"80001881",plutoGateway:ref("$acPlutoGatewayName"),
            paramsForCurrent:[
                MotorType:10, PositionSensorType:260,PolePairNumber:1,
                ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                ThermalTimeConstantWinding:187,
                MaxSpeedInCurrentMode:9140],
            paramsForProfilePosition:[
                ProfileAcceleration:1207, ProfileDeceleration:1207,
                MaxProfileVelocity:322, QuickStopDeceleration:1207,
                MaxFollowingError:200000,//on verra plus tard
                ProfileVelocity:281,MotionProfileType:0],
            paramsForHoming:[HomeOffset:0],
            encoderRibbonMinValue:8161299,
        )

        // can open devices
        linearRailSlaveController (SimuAutochangerLinearRailController, 
            nodeID:0x2c,serialNB:"80001932",plutoGateway:ref("$acPlutoGatewayName"),
            paramsForCurrent:[
                MotorType:10, PositionSensorType:1,PolePairNumber:1,
                ContinuousCurrentLimit:7200,OutputCurrentLimit:14400,
                ThermalTimeConstantWinding:187,MaxSpeedInCurrentMode:9140],
            paramsForProfilePosition: [
                ProfileAcceleration:30000,
                ProfileDeceleration:30000,
                ProfileVelocity:7000,
                QuickStopDeceleration:30000,
                MaxFollowingError:7000,
                MotionProfileType:0],
            paramsForHoming:[HomeOffset:0],
            encoderRibbonMinValue:7449994,
        )

        latchXminusController (SimuAutochangerLatchController,  //CanOpenEPOS24-3
            nodeID:0xf,serialNB:"84004735",latchName:"latchXminus",plutoGateway:ref("$acPlutoGatewayName"),
            paramsForCurrent:[MotorType:1, PositionSensorType:0,PolePairNumber:2,
                ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                ThermalTimeConstantWinding:40,
                MaxSpeedInCurrentMode:100],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0],
        )

        // can open devices
        latchXplusController (SimuAutochangerLatchController,  //CanOpenEPOS24-3
            nodeID:0xe, serialNB:"84004711", latchName:"latchXplus", plutoGateway:ref("$acPlutoGatewayName"),
            paramsForCurrent:[
                MotorType:1, PositionSensorType:0,PolePairNumber:2,
                ContinuousCurrentLimit:300,OutputCurrentLimit:200,
                ThermalTimeConstantWinding:40,MaxSpeedInCurrentMode:100],
            paramsForProfilePosition:[MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])

        // can open devices
        onlineClampXminusController (SimuAutochangerOnlineClampController, 
            nodeID:0x31,serialNB:"79011618",
            plutoGateway:ref("$acPlutoGatewayName"),
            onlineClampName:"onlineClampXminus",
            paramsForCurrent: [
                MotorType:1, PositionSensorType:0,PolePairNumber:1,
                ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                ThermalTimeConstantWinding:160,MaxSpeedInCurrentMode:6930],
            paramsForProfilePosition:[ 
                ProfileAcceleration:30000, ProfileDeceleration:30000,
                ProfileVelocity:7000, QuickStopDeceleration:10000,
                MaxFollowingError:2000, MotionProfileType:0],
            paramsForHoming:[
                HomeOffset:0, MaxProfileVelocity:6930,
                SpeedForSwitchSearch:100, SpeedForZeroSearch:10,
                HomingAcceleration:1000,CurrentThresholdHomingMode:500,
                HomePosition:0]
        )
        // can open devices
        onlineClampXplusController (SimuAutochangerOnlineClampController, 
            nodeID:0x30, serialNB:"79011616", 
            plutoGateway:ref("$acPlutoGatewayName"),
            onlineClampName:"onlineClampXplus",
            paramsForCurrent: [
                MotorType:1, 
                PositionSensorType:0,
                PolePairNumber:1,
                ContinuousCurrentLimit:5000,
                OutputCurrentLimit:4000,
                ThermalTimeConstantWinding:160, 
                MaxSpeedInCurrentMode:6930],
            paramsForProfilePosition:[
                ProfileAcceleration:30000, 
                ProfileDeceleration:30000,
                ProfileVelocity:7000, 
                QuickStopDeceleration:10000,
                MaxFollowingError:2000, 
                MotionProfileType:0],
            paramsForHoming:[
                HomeOffset:0, 
                MaxProfileVelocity:6930, 
                SpeedForSwitchSearch:100,
                SpeedForZeroSearch:10, 
                HomingAcceleration:1000,
                CurrentThresholdHomingMode:500, 
                HomePosition:0]
        )
        // can open devices
        onlineClampYminusController (SimuAutochangerOnlineClampController, 
            nodeID:0x32, serialNB:"79011243", 
            plutoGateway:ref("$acPlutoGatewayName"),
            onlineClampName:"onlineClampYminus",
            paramsForCurrent:[
                MotorType:1, PositionSensorType:0,PolePairNumber:1,
                ContinuousCurrentLimit:5000,OutputCurrentLimit:4000,
                ThermalTimeConstantWinding:160, MaxSpeedInCurrentMode:6930],
            paramsForProfilePosition:[
                ProfileAcceleration:30000,
                ProfileDeceleration:30000,
                ProfileVelocity:7000,
                QuickStopDeceleration:10000,
                MaxFollowingError:2000,
                MotionProfileType:0],
            paramsForHoming:[
                HomeOffset:0, MaxProfileVelocity:6930,
                SpeedForSwitchSearch:100,
                SpeedForZeroSearch:10,
                HomingAcceleration:1000,
                CurrentThresholdHomingMode:500,
                HomePosition:0]
        )
    //************************************//            
    }//end description of bridge's children
    //************************************//
    //**************************************************************************//
    // end of Bridge
    //**************************************************************************//
    
    //-------------------------
    // BEGIN Filter Identificator description
    filterIdentificator(FilterIdentificator)
    {//begin description of filter Identificator's children
        filterIDSensor0 ( DigitalSensor,
            dioName:acPlutoGatewayName,inputNumero:0,byteNumero:4)
        
        filterIDSensor1 ( DigitalSensor,
            dioName:acPlutoGatewayName,inputNumero:1,byteNumero:4)
        
        filterIDSensor2 ( DigitalSensor,
            dioName:acPlutoGatewayName,inputNumero:2,byteNumero:4)
        
        filterIDSensor3 ( DigitalSensor,
            dioName:acPlutoGatewayName,inputNumero:3,byteNumero:4)
        
        filterIDSensor4 ( DigitalSensor,
            dioName:acPlutoGatewayName,inputNumero:4,byteNumero:4)
        
        filterIDSensor5 ( DigitalSensor,
            dioName:acPlutoGatewayName,inputNumero:5,byteNumero:4)
    }//end description of filter identificator's children
    // END Filter Identificator description

    

    
    //**************************************************************************//
    //**************************************************************************//
    // autochanger
    //**************************************************************************//
    //**************************************************************************//
    autochanger(Autochanger, plutoGateway:ref("$acPlutoGatewayName")) {
        //begin description of autochanger children
        loaderConnectedSensors (ComplementarySensors,
            sensor:ref("loaderConnectedSensor"),
            sensorC:ref("loaderConnectedSensorC"),
            )
            {//begin description of autochanger loaderConnectedSensors children
                loaderConnectedSensor ( DigitalSensor ,
                    dioName:acPlutoGatewayName, inputNumero:4, byteNumero:2)
                loaderConnectedSensorC ( DigitalSensor ,
                    dioName:acPlutoGatewayName, inputNumero:5, byteNumero:2)
            }//end description of autochanger loaderConnectedSensors children
            
        //in the autochanger standalone subsystem the fake loader is a switch which
        //simulate that loader holds a filter at HANDOFF 
        //begin description of fakeAutochanger's children 
        loaderHoldingFilterSensors (ComplementarySensors,
            sensor:ref("loaderHoldingFilterSensor0"),
            sensorC:ref("loaderHoldingFilterSensor1"),
        ) {
            loaderHoldingFilterSensor0(DigitalSensor ,
                dioName:acPlutoGatewayName, inputNumero:6, byteNumero:2)
            loaderHoldingFilterSensor1(DigitalSensor ,
                dioName:acPlutoGatewayName, inputNumero:7, byteNumero:2)    
        }
            
        carouselHoldingFilterSensors (ComplementarySensors, //Carousel_CFC
            sensor:ref("carouselHoldingFilterSensor0"),
            sensorC:ref("carouselHoldingFilterSensor1"),
        )
        {
            carouselHoldingFilterSensor0(DigitalSensor ,
                dioName:acPlutoGatewayName, inputNumero:6,byteNumero:3)
            carouselHoldingFilterSensor1(DigitalSensor ,
                dioName:acPlutoGatewayName, inputNumero:7,byteNumero:3)
        }
            
        carouselStoppedAtStandbySensors (ComplementarySensors, // Carousel_CS
            sensor:ref("carouselStoppedAtStandby"),
            sensorC:ref("carouselStoppedAtStandbyC")) {
                carouselStoppedAtStandby (DigitalSensor,
                    dioName:acPlutoGatewayName, inputNumero:0, byteNumero:3)		
                carouselStoppedAtStandbyC ( DigitalSensor ,		
                    dioName:acPlutoGatewayName, inputNumero:1, byteNumero:3)
        }//end description of autochanger carouselStoppedAtStandbySensors children
        
        carousel_CF0Sensors (ComplementarySensors, // Carousel_CF0
            sensor:ref("carousel_CF0"),
            sensorC:ref("carousel_CF0_C")) {
                carousel_CF0 (DigitalSensor,
                    dioName:acPlutoGatewayName, inputNumero:2, byteNumero:3)		
                carousel_CF0_C ( DigitalSensor ,		
                    dioName:acPlutoGatewayName, inputNumero:3, byteNumero:3)
        }//end description of autochanger carousel_CF0 children 
        
        carousel_CF1Sensors (ComplementarySensors, // Carousel_CF1
            sensor:ref("carousel_CF1"),
            sensorC:ref("carousel_CF1_C")) {
                carousel_CF1 (DigitalSensor,
                    dioName:acPlutoGatewayName, inputNumero:4, byteNumero:3)		
                carousel_CF1_C ( DigitalSensor ,		
                    dioName:acPlutoGatewayName, inputNumero:5, byteNumero:3)
        }//end description of autochanger carousel_CF1 children 
        
        
        //**************************************************************************//
        // autochanger trucks description
        //**************************************************************************//
        autochangerTrucks (AutochangerTwoTrucks, 
            truckXminus:ref("acTruckXminus"), truckXplus:ref("acTruckXplus"),
            linearRailMasterController:ref("linearRailMasterController"),
            linearRailSlaveController:ref("linearRailSlaveController")) {
            //begin description of autochanger trucks children
            acTruckXminus (AutochangerTruck, 
                controller:ref("linearRailMasterController"),
                handoffPositionSensors:ref("handoffPositionSensorsXminus"),
                onlinePositionSensors:ref("onlinePositionSensorsXminus"),
                standbyPositionSensors:ref("standbyPositionSensorsXminus"),
            )
            {//begin description of autochanger truckXminus children
                handoffPositionSensorsXminus ( ComplementarySensors,
                    sensor: ref("handoffPositionSensorXminus"),
                    sensorC: ref("handoffPositionSensorBXminus"),
                )
                {
                    handoffPositionSensorXminus ( DigitalSensor ,
                        dioName:acPlutoGatewayName, inputNumero:0, byteNumero:1)

                    handoffPositionSensorBXminus ( DigitalSensor ,
                        dioName:acPlutoGatewayName, inputNumero:1, byteNumero:1)
                }
                onlinePositionSensorsXminus ( ComplementarySensors,
                    sensor: ref("onlinePositionSensorXminus"),
                    sensorC: ref("onlinePositionSensorBXminus"),
                )
                {
                    onlinePositionSensorXminus ( DigitalSensor ,
                        dioName:acPlutoGatewayName, inputNumero:2, byteNumero:1)

                    onlinePositionSensorBXminus ( DigitalSensor ,
                        dioName:acPlutoGatewayName,inputNumero:3, byteNumero:1)
                }
                standbyPositionSensorsXminus ( ComplementarySensors,
                    sensor: ref("standbyPositionSensorXminus"),
                    sensorC: ref("standbyPositionSensorBXminus"),
                )
                {
                    standbyPositionSensorXminus ( DigitalSensor ,
                        dioName:acPlutoGatewayName, inputNumero:6, byteNumero:0)

                    standbyPositionSensorBXminus ( DigitalSensor ,
                        dioName:acPlutoGatewayName, inputNumero:7, byteNumero:0)
                }
            }//end description of autochanger acTruckXminus children
            acTruckXplus (AutochangerTruck, 
                controller:ref("linearRailSlaveController"),
                handoffPositionSensors:ref("handoffPositionSensorsXplus"),
                onlinePositionSensors:ref("onlinePositionSensorsXplus"),
                standbyPositionSensors:ref("standbyPositionSensorsXplus"),
            )
            {//begin description of autochanger truckXplus children
                handoffPositionSensorsXplus (ComplementarySensors,
                    sensor: ref("handoffPositionSensorXplus"),
                    sensorC: ref("handoffPositionSensorBXplus"),
                )
                {
                    handoffPositionSensorXplus ( DigitalSensor ,
                        dioName:acPlutoGatewayName, inputNumero: 0, byteNumero:9)                                    
                    handoffPositionSensorBXplus ( DigitalSensor ,
                        dioName:acPlutoGatewayName, inputNumero:1, byteNumero:9)
                }
                onlinePositionSensorsXplus (ComplementarySensors,
                    sensor: ref("onlinePositionSensorXplus"),
                    sensorC: ref("onlinePositionSensorBXplus"),
                )
                {
                    onlinePositionSensorXplus ( DigitalSensor ,
                        dioName:acPlutoGatewayName, inputNumero:2, byteNumero:9)
                    onlinePositionSensorBXplus ( DigitalSensor ,
                        dioName:acPlutoGatewayName, inputNumero:3, byteNumero:9)
                }
                standbyPositionSensorsXplus (ComplementarySensors,
                    sensor: ref("standbyPositionSensorXplus"),
                    sensorC: ref("standbyPositionSensorBXplus"),
                )
                {
                    standbyPositionSensorXplus( DigitalSensor ,
                        dioName:acPlutoGatewayName, inputNumero:6, byteNumero:8)
                    standbyPositionSensorBXplus ( DigitalSensor ,
                        dioName:acPlutoGatewayName, inputNumero:7, byteNumero:8)
                }
            }//end description of autochanger acTruckXplus children
            
        }//end description of autochanger trucks children            
        //**************************************************************************//
        // end of autochanger trucks description
        //**************************************************************************//
        
        //**************************************************************************//
        // autochanger latches description
        //**************************************************************************//
        latches (AutochangerTwoLatches, latchXminus:ref("latchXminus"), latchXplus:ref("latchXplus"))
        {//begin description of autochanger latches children
            //*************************************//
            // autochanger latchXminus description
            //*************************************//
            latchXminus (AutochangerLatch,
                latchController:ref("latchXminusController"),
                closeSensors:ref("closeSensorsLatchXminus"),
                openSensors:ref("openSensorsLatchXminus"),
                filterEngagedSensors:ref("filterEngagedSensorsLatchXminus"),
            )
            {//begin description of autochanger latchXminus children
                closeSensorsLatchXminus ( ComplementarySensors,
                    sensor:ref("closeSensorLatchXminus"),
                    sensorC:ref("closeSensorBLatchXminus")
                )
                {//begin description of autochanger lockSensorslatchXminus children
                    closeSensorLatchXminus ( DigitalSensor,
                        dioName:acPlutoGatewayName, inputNumero:2, byteNumero:0)
                    closeSensorBLatchXminus ( DigitalSensor,
                        dioName:acPlutoGatewayName, inputNumero:3, byteNumero:0)
                }//end description of autochanger lockSensorslatchXminus children
                
                openSensorsLatchXminus ( ComplementarySensors,
                    sensor:ref("openSensorLatchXminus"),
                    sensorC:ref("openSensorBLatchXminus")
                )     
                {//begin description of autochanger unlockSensorslatchXminus children
                    openSensorLatchXminus ( DigitalSensor,
                        dioName:acPlutoGatewayName, inputNumero:0, byteNumero:0)
                    openSensorBLatchXminus ( DigitalSensor,
                        dioName:acPlutoGatewayName, inputNumero:1, byteNumero:0)
                }//end description of autochanger unlockSensorslatchXminus children

                filterEngagedSensorsLatchXminus ( ComplementarySensors,
                    sensor:ref("filterEngagedSensorLatchXminus"),
                    sensorC:ref("filterEngagedSensorBLatchXminus")
                )
                {//begin description of autochanger filterEngagedSensorslatchXminus children
                    filterEngagedSensorLatchXminus ( DigitalSensor,
                        dioName:acPlutoGatewayName, inputNumero:4, byteNumero:0)
                    filterEngagedSensorBLatchXminus ( DigitalSensor,
                        dioName:acPlutoGatewayName, inputNumero:5, byteNumero:0)
                }//end description of autochanger filterEngagedSensorslatchXminus children
                
            }//end description of autochanger latchXminus children
            //**********************************************//
            // end of autochanger latchXminus description   //
            //**********************************************//
            //*************************************//
            // autochanger latchXplus description
            //*************************************//
            latchXplus (AutochangerLatch,
                latchController:ref("latchXplusController"),
                closeSensors:ref("closeSensorsLatchXplus"),
                openSensors:ref("openSensorsLatchXplus"),
                filterEngagedSensors:ref("filterEngagedSensorsLatchXplus"),
            )
            {//begin description of autochanger latchXplus children
                closeSensorsLatchXplus ( ComplementarySensors,
                    sensor:ref("closeSensorLatchXplus"),
                    sensorC:ref("closeSensorBLatchXplus")
                )
                {//begin description of autochanger lockSensorslatchXplus children
                    closeSensorLatchXplus ( DigitalSensor,
                        dioName:acPlutoGatewayName, inputNumero:2, byteNumero:8)
                    closeSensorBLatchXplus ( DigitalSensor,
                        dioName:acPlutoGatewayName, inputNumero:3, byteNumero:8)
                }//end description of autochanger lockSensorslatchXplus children
                
                openSensorsLatchXplus ( ComplementarySensors,
                    sensor:ref("openSensorLatchXplus"),
                    sensorC:ref("openSensorBLatchXplus")
                )     
                {//begin description of autochanger unlockSensorslatchXplus children
                    openSensorLatchXplus ( DigitalSensor,
                        dioName:acPlutoGatewayName, inputNumero:0, byteNumero:8)
                    openSensorBLatchXplus ( DigitalSensor,
                        dioName:acPlutoGatewayName, inputNumero:1, byteNumero:8)
                }//end description of autochanger unlockSensorslatchXplus children

                filterEngagedSensorsLatchXplus ( ComplementarySensors,
                    sensor:ref("filterEngagedSensorLatchXplus"),
                    sensorC:ref("filterEngagedSensorBLatchXplus")
                )
                {//begin description of autochanger filterEngagedSensorslatchXplus children
                    filterEngagedSensorLatchXplus ( DigitalSensor,
                        dioName:acPlutoGatewayName, inputNumero:4, byteNumero:8)
                    filterEngagedSensorBLatchXplus ( DigitalSensor,
                        dioName:acPlutoGatewayName, inputNumero:5, byteNumero:8)
                }//end description of autochanger filterEngagedSensorslatchXplus children
                
            }//end description of autochanger latchXplus children
            //**********************************************//
            // end of autochanger latchXplus description   //
            //**********************************************//
        }//end description of autochanger latches children
        //*****************************************************************************//
        // end of autochanger latches description
        //*****************************************************************************//
        
        //**************************************************************************//
        //**************************************************************************//
        // autochanger onlineClamps description
        //**************************************************************************//
        //**************************************************************************//
        onlineClamps (AutochangerThreeOnlineClamps, 
            onlineClampXminus:ref("onlineClampXminus"), 
            onlineClampXplus:ref("onlineClampXplus"), 
            onlineClampYminus:ref("onlineClampYminus")) 
        {//begin description of autochanger onlineClamps children
            
            onlineClampXminus(AutochangerOnlineClamp ,
                controller:ref("onlineClampXminusController"),
                closeSensors:ref("onlineClampXminusCloseSensors"),
                openSensors:ref("onlineClampXminusOpenSensors"),
            )
            {//begin description of autochanger onlineClampXminus children
                onlineClampXminusCloseSensors ( ComplementarySensors,
                    sensor:ref("onlineClampXminusCloseSensor"),
                    sensorC:ref("onlineClampXminusCloseSensorC")
                    )
                    {//begin description of autochanger onlineClampXminusCloseSensors children
                        onlineClampXminusCloseSensor ( DigitalSensor,
                            dioName:acPlutoGatewayName, inputNumero:6, byteNumero:1)
                        onlineClampXminusCloseSensorC ( DigitalSensor,
                            dioName:acPlutoGatewayName, inputNumero:7, byteNumero:1)
                    }//end description of autochanger onlineClampXminusCloseSensors children
                
                onlineClampXminusOpenSensors ( ComplementarySensors,
                    sensor: ref("onlineClampXminusOpenSensor"),
                    sensorC: ref("onlineClampXminusOpenSensorC")
                    )
                    {
                        onlineClampXminusOpenSensor ( DigitalSensor,
                            dioName:acPlutoGatewayName, inputNumero: 4, byteNumero: 1)
                        onlineClampXminusOpenSensorC ( DigitalSensor,
                            dioName:acPlutoGatewayName, inputNumero: 5, byteNumero: 1)  
                    }
                    
            }//end of  description of autochanger onlineClampXminus children
            
            onlineClampXplus(AutochangerOnlineClamp ,
                controller:ref("onlineClampXplusController"),
                closeSensors:ref("onlineClampXplusCloseSensors"),
                openSensors:ref("onlineClampXplusOpenSensors"),
            )
            {//begin description of autochanger onlineClampXplus children
                
                onlineClampXplusCloseSensors ( ComplementarySensors,
                    sensor: ref("onlineClampXplusCloseSensor"),
                    sensorC: ref("onlineClampXplusCloseSensorC"),
                    )
                    {
                        onlineClampXplusCloseSensor ( DigitalSensor,
                            dioName:acPlutoGatewayName, inputNumero: 6, byteNumero: 9)
                        onlineClampXplusCloseSensorC ( DigitalSensor,
                            dioName:acPlutoGatewayName, inputNumero: 7, byteNumero: 9)
                    }
                
                onlineClampXplusOpenSensors ( ComplementarySensors,
                    sensor: ref("onlineClampXplusOpenSensor"),
                    sensorC: ref("onlineClampXplusOpenSensorC"),
                    )
                    {
                        onlineClampXplusOpenSensor ( DigitalSensor,
                            dioName:acPlutoGatewayName,inputNumero: 4, byteNumero: 9)
                        onlineClampXplusOpenSensorC ( DigitalSensor,
                            dioName:acPlutoGatewayName, inputNumero: 5, byteNumero: 9)
                    }
            }//end of  description of autochanger onlineClampXplus children
            
            onlineClampYminus(AutochangerOnlineClamp ,
                controller:ref("onlineClampYminusController"),
                closeSensors:ref("onlineClampYminusCloseSensors"),
                openSensors:ref("onlineClampYminusOpenSensors"),
            )
            {//begin description of autochanger onlineClampYminus children
                onlineClampYminusCloseSensors ( ComplementarySensors,
                    sensor: ref("onlineClampYminusCloseSensor"),
                    sensorC: ref("onlineClampYminusCloseSensorC"),
                    )
                    {
                        onlineClampYminusCloseSensor ( DigitalSensor,
                            dioName:acPlutoGatewayName, inputNumero: 2, byteNumero: 2)
                        onlineClampYminusCloseSensorC ( DigitalSensor,
                            dioName:acPlutoGatewayName, inputNumero: 3, byteNumero: 2)
                    }
                onlineClampYminusOpenSensors ( ComplementarySensors,
                    sensor: ref("onlineClampYminusOpenSensor"),
                    sensorC: ref("onlineClampYminusOpenSensorC"),
                    )
                    {
                        onlineClampYminusOpenSensor ( DigitalSensor,
                            dioName:acPlutoGatewayName, inputNumero: 0, byteNumero: 2)
                        onlineClampYminusOpenSensorC ( DigitalSensor,
                            dioName:acPlutoGatewayName, inputNumero: 1, byteNumero: 2)
                    }
            }//end of  description of autochanger onlineClampYminus children
        }//end of  description of autochanger onlineClamps children
        //**************************************************************************//
        // end of autochanger onlineClamps description
        //**************************************************************************//
        inclinometerXminus (Inclinometer, deviceName:acPlutoGatewayName, byteNumero: 6)
        inclinometerXplus (Inclinometer, deviceName:acPlutoGatewayName, byteNumero: 12)
    }//end description of autochanger children
    //*****************************************************************************//
    //*****************************************************************************//
    // end of autochanger description
    //*****************************************************************************//
    //*****************************************************************************//
    
        
    /**********************************************************************/
    /*                FAKE CAROUSEL DESCRIPTION                       */
    /**********************************************************************/
    //in the autochanger standalone subsystem the fake carousel is a switch which
    //simulates that carousel holds a filter at STANDBY 
    
    carousel(FakeFilterHolder, holdingFilterSensorName:"carouselHoldingFilterSensors")
    
    /**********************************************************************/
    /*                END of FAKE CAROUSEL DESCRIPTION                 */
    /**********************************************************************/

    /**********************************************************************/
    /*                FAKE LOADER DESCRIPTION                       */
    /**********************************************************************/

    loader(FakeFilterHolder, holdingFilterSensorName:"loaderHoldingFilterSensors")
    /**********************************************************************/
    /*                END of FAKE LOADER DESCRIPTION                 */
    /**********************************************************************/
    
}    // main
