/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.HashMap;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForLinearRail;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class CanOpenEPOSLinearRailTruck
extends CanOpenEPOS
implements EPOSControllerForLinearRail {
    @ConfigurationParameter(description="minimal position of the encoder ribbon.")
    private final int encoderRibbonMinValue;
    private boolean homingDone;
    private boolean configDigitalInputOK = true;
    private boolean configDigitalOutputOK = true;
    private StringBuilder configDigitalInputSb;
    private StringBuilder configDigitalOutputSb;

    public CanOpenEPOSLinearRailTruck(int nodeID, String serialNB, HashMap<String, Integer> paramsForCurrent, HashMap<String, Integer> paramsForProfilePosition, HashMap<String, Integer> paramsForHoming, int encoderRibbonMinValue) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.encoderRibbonMinValue = encoderRibbonMinValue;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="return true if homing is done: the controller knows its absolute position.")
    public boolean isHomingDone() {
        return this.homingDone;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Do homing of the controller.")
    public void homing() {
        this.checkInitialized();
        this.homingDone = false;
        int ssiPosition = this.readSSIPosition();
        int pos = ssiPosition - this.encoderRibbonMinValue;
        FCSCst.FCSLOG.debug((Object)(this.getName() + " ssiPosition=" + ssiPosition + ", position=" + pos));
        if (Math.abs(pos - this.readPosition()) < 10) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " no homing to be done."));
            this.homingDone = true;
        } else {
            this.doHoming(pos);
            this.publishData();
        }
    }

    private void doHoming(int pos) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " ==> BEGIN homing"));
        EPOSEnumerations.EposMode myMode = this.readMode();
        this.enable();
        this.defineAbsolutePosition(pos);
        this.checkHomingDone(pos);
        this.homingDone = true;
        this.changeMode(myMode);
        this.publishData();
        this.activateBrakeAndDisable();
        FCSCst.FCSLOG.debug((Object)(this.getName() + " ==> END homing"));
    }

    private void checkHomingDone(int pos) {
        long timeout = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        while (!this.isTargetReached() && duration <= timeout) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " homing target not yet reached. duration=" + duration));
            duration = System.currentTimeMillis() - timeStart;
        }
        if (!this.isTargetReached() || pos != this.readPosition()) {
            this.publishData();
            this.activateBrakeAndDisable();
            throw new FcsHardwareException(this.getName() + " couldn't do homing : target is not reached.");
        }
        this.writeControlWord(15);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="activate brake to prevent motion and disable controller.")
    public void activateBrakeAndDisable() {
        this.activateBrake();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            FCSCst.FCSLOG.error((Object)ex);
        }
        this.disable();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the autochanger linear rails controllers.")
    public void configureDigitalInputOfLinearRails() {
        this.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, 4);
        this.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput2, 5);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, 0);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, 48);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, 48);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="check configuration of digital input of linear rail controller.")
    public void checkConfigDigitalInputOfLinearRails() {
        this.configDigitalInputSb = new StringBuilder();
        this.configDigitalInputSb.append(" Configuration of Digital Input:");
        this.checkParamInput(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput1, 4);
        this.checkParamInput(EPOSEnumerations.Parameter.ConfigurationOfDigitalInput2, 5);
        this.checkParamInput(EPOSEnumerations.Parameter.DigitalInputFonctionnalityPolarity, 0);
        this.checkParamInput(EPOSEnumerations.Parameter.DigitalInputFonctionnalityMask, 48);
        this.checkParamInput(EPOSEnumerations.Parameter.DigitalInputFonctionnalityExecutionMask, 48);
        if (this.configDigitalInputOK) {
            FCSCst.FCSLOG.info((Object)this.configDigitalInputSb.toString());
        } else {
            FCSCst.FCSLOG.error((Object)this.configDigitalInputSb.toString());
        }
    }

    private void checkParamInput(EPOSEnumerations.Parameter param, int configValue) {
        int paramValue = (int)this.readParameter(param);
        if (configValue != paramValue) {
            this.configDigitalInputOK = false;
        }
        this.configDigitalInputSb.append((Object)param).append("=");
        this.configDigitalInputSb.append(paramValue).append(";");
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="To configure the autochanger linear rails controllers.")
    public void configureDigitalOutputOfLinearRails() {
        this.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, 0);
        this.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, 15);
        this.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput2, 0);
        this.writeParameter(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput3, 2);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, 4);
        this.writeParameter(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, 32773);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="check configuration of digital output of linear rail controller.")
    public void checkConfigDigitalOutputOfLinearRails() {
        this.configDigitalOutputSb = new StringBuilder();
        this.configDigitalOutputSb.append(" Configuration of Digital Output:");
        this.checkParamOutput(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput1, 15);
        this.checkParamOutput(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput2, 0);
        this.checkParamOutput(EPOSEnumerations.Parameter.ConfigurationOfDigitalOutput3, 2);
        this.checkParamOutput(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityPolarity, 4);
        this.checkParamOutput(EPOSEnumerations.Parameter.DigitalOutputFonctionnalityMask, 32773);
        if (this.configDigitalOutputOK) {
            FCSCst.FCSLOG.info((Object)this.configDigitalOutputSb.toString());
        } else {
            FCSCst.FCSLOG.error((Object)this.configDigitalOutputSb.toString());
        }
    }

    private void checkParamOutput(EPOSEnumerations.Parameter param, int configValue) {
        int paramValue = (int)this.readParameter(param);
        if (configValue != paramValue) {
            this.configDigitalOutputOK = false;
        }
        this.configDigitalOutputSb.append((Object)param).append("=");
        this.configDigitalOutputSb.append(paramValue).append(";");
    }

    public void shutdown() {
    }
}

