/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChanger;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SimuCarouselClampFilterPresenceSensor;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SimuCarouselClampLockSensor;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SimuCompactIO;

public class SimuTruckMotor
extends SftTruckMotor {
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private SftAutoChanger autochanger;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private CarouselClamp clampXminus;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private CarouselClamp clampXplus;

    @Override
    public void moveToStandback() {
        if (this.autochanger.isAtStandby()) {
            this.setMovingToStandback(true);
            long timeToGo = this.autochanger.getTimeToGoToStandback() / 10L;
            try {
                FCSCst.FCSLOG.debug((Object)(this.name + ": Waiting for the motor to go to STANDBACK"));
                Thread.sleep(timeToGo);
            }
            catch (InterruptedException ex) {
                FCSCst.FCSLOG.debug((Object)ex);
            }
            this.setMovingToStandback(false);
            SimuCompactIO simuRailsSensors = (SimuCompactIO)this.autochanger.getRailsSensorsDIO();
            simuRailsSensors.setValue(80);
            SimuCompactIO simuFilterSensors = (SimuCompactIO)this.autochanger.getFilterSensorsDIO();
            if (this.autochanger.isTrucksEmpty()) {
                simuFilterSensors.simulateFilterPresenceInLatches(0);
            } else {
                ((SimuCarouselClampFilterPresenceSensor)this.clampXminus.getFilterPresenceSensor()).simulateNoFilter();
                ((SimuCarouselClampFilterPresenceSensor)this.clampXplus.getFilterPresenceSensor()).simulateNoFilter();
                FCSCst.FCSLOG.debug((Object)"====> END OF moveToStandback");
            }
        }
    }

    @Override
    public void moveToStandby() {
        if (this.autochanger.isAtStandback()) {
            this.setMovingToStandby(true);
            long timeToGo = this.autochanger.getTimeToGoToStandby();
            try {
                FCSCst.FCSLOG.debug((Object)(this.name + ": Waiting for the motor to go to STANDBY"));
                Thread.sleep(timeToGo);
            }
            catch (InterruptedException ex) {
                FCSCst.FCSLOG.debug((Object)ex);
            }
            this.setMovingToStandby(false);
            SimuCompactIO simuRailsSensor = (SimuCompactIO)this.autochanger.getRailsSensorsDIO();
            simuRailsSensor.setValue(160);
            SimuCompactIO simuFilterSensors = (SimuCompactIO)this.autochanger.getFilterSensorsDIO();
            if (this.autochanger.isTrucksEmpty()) {
                simuFilterSensors.simulateFilterPresenceInLatches(1);
            } else {
                ((SimuCarouselClampFilterPresenceSensor)this.clampXminus.getFilterPresenceSensor()).simulateFilterIsLockable();
                ((SimuCarouselClampFilterPresenceSensor)this.clampXplus.getFilterPresenceSensor()).simulateFilterIsLockable();
                ((SimuCarouselClampLockSensor)this.clampXminus.getLockSensor()).simulateClampIsLOCKED();
                ((SimuCarouselClampLockSensor)this.clampXplus.getLockSensor()).simulateClampIsLOCKED();
            }
        }
    }

    @Override
    public void off() {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
    }
}

