/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.List;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;

public interface SimuFilterIDPlutoGatewayInterface {
    public List<DigitalSensor> getFilterIDSensors();

    @Command(type=Command.CommandType.ACTION, level=1, description="Simulates that filterID value in decimal format is the value given as argument")
    default public void simulateFilterID(int decimal) {
        if (decimal <= 0 || decimal > 63) {
            throw new IllegalArgumentException("decimal=" + decimal + " should be >0 and < 64 because filterID is coded on 6 bits.");
        }
        for (int i = 0; i < 6; ++i) {
            boolean un;
            boolean bl = un = (decimal >> i & 1) == 1;
            if (un) {
                this.replaceSensorValue(this.getFilterIDSensors().get(i), false);
                continue;
            }
            this.replaceSensorValue(this.getFilterIDSensors().get(i), true);
        }
    }

    public void replaceSensorValue(DigitalSensor var1, boolean var2);
}

