/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForLinearRail;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;

public class SimuAutochangerLinearRailController
extends SimuEPOSController
implements EPOSControllerForLinearRail {
    @ConfigurationParameter(description="minimal position of the encoder ribbon.")
    private int encoderRibbonMinValue;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    private AutochangerTwoTrucks trucks;
    private final SimuAutochangerPlutoGateway plutoGateway;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private FilterHolder carousel;
    private AutochangerTwoLatches latches;
    private SimuAutochangerLinearRailController slaveController;
    private boolean homingDone = true;
    private boolean brakeActivated;

    public SimuAutochangerLinearRailController(int nodeID, String serialNB, SimuAutochangerPlutoGateway plutoGateway) {
        super(nodeID, serialNB);
        this.plutoGateway = plutoGateway;
    }

    public void setSsiPosition(int ssiPosition) {
        this.ssiPosition = ssiPosition;
    }

    public int getEncoderRibbonMinValue() {
        return this.encoderRibbonMinValue;
    }

    private void setTrucksPosition(int pos) {
        if (this.getName().contains("Master")) {
            this.position = pos;
            this.slaveController.setPosition(pos);
        } else {
            this.position = pos;
        }
        this.ssiPosition = this.encoderRibbonMinValue + pos;
    }

    public void init() {
        ComponentLookup lookup = this.subs.getComponentLookup();
        this.trucks = (AutochangerTwoTrucks)lookup.getComponentByName("autochangerTrucks");
        this.latches = (AutochangerTwoLatches)lookup.getComponentByName("latches");
        this.setSsiPosition(this.encoderRibbonMinValue);
        if (this.getName().contains("Master")) {
            this.slaveController = (SimuAutochangerLinearRailController)lookup.getComponentByName("linearRailSlaveController");
        }
        if (this.getName().contains("Slave")) {
            this.mode = EPOSEnumerations.EposMode.MASTER_ENCODER;
        }
    }

    @Override
    public void writeTargetPosition(int positionToReached) {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSCst.FCSLOG.debug((Object)"loader trucks is moving.");
        FCSCst.FCSLOG.debug((Object)(this.name + "=>position intitiale=" + this.position));
        int stepsNB = Math.abs(this.targetPosition - this.position) > 10000 ? 20 : 5;
        int stepHeight = (this.targetPosition - this.position) / stepsNB;
        this.simulateTrucksMotion(positionInitiale, stepsNB, stepHeight);
        this.setTrucksPosition(this.targetPosition);
        this.trucks.updatePosition();
        this.trucks.publishData();
        FCSCst.FCSLOG.info((Object)("plutoGateway=" + this.plutoGateway.toString()));
        if (this.position == this.trucks.getHandoffPosition()) {
            FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksIsAtHandoff");
            this.plutoGateway.simulateAutochangerTrucksAreAtHandoff();
        } else if (this.position == this.trucks.getStandbyPosition()) {
            this.plutoGateway.simulateAutochangerTrucksAreAtStandby();
            if (this.carousel.isHoldingFilter()) {
                FCSCst.FCSLOG.info((Object)"simulateFilterIsOnAutochanger");
                this.plutoGateway.simulateFilterIsOnAutochanger();
            }
        } else if (this.position == this.trucks.getOnlinePosition()) {
            FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksIsOnline");
            this.plutoGateway.simulateAutochangerTrucksAreOnline();
        } else {
            FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksIsInTravel");
            this.plutoGateway.simulateAutochangerTrucksAreInTravel();
        }
        FCSCst.FCSLOG.info((Object)("plutoGateway=" + this.plutoGateway.toString()));
    }

    private void simulateFilterPresenceSensors(int positionInitiale, int stepHeight) {
        if (positionInitiale < this.trucks.getStandbyPosition() && this.position > this.trucks.getStandbyPosition() - 2 * stepHeight && this.carousel.isHoldingFilter()) {
            FCSCst.FCSLOG.info((Object)"simulateFilterIsOnAutochanger");
            this.plutoGateway.simulateFilterIsOnAutochanger();
        } else if (positionInitiale == this.trucks.getStandbyPosition() && this.position < this.trucks.getStandbyPosition() - 2 * stepHeight && this.latches.isOpened()) {
            FCSCst.FCSLOG.info((Object)"simulateAutochangerIsEmpty");
            this.plutoGateway.simulateAutochangerIsEmpty();
        }
        this.autochanger.updateStateWithSensors();
        this.trucks.publishData();
    }

    private void simulateTrucksMotion(int positionInitiale, int stepsNB, int stepHeight) {
        for (int i = 1; i < stepsNB; ++i) {
            this.setTrucksPosition(positionInitiale + i * stepHeight);
            this.trucks.updatePosition();
            FCSCst.FCSLOG.info((Object)("trucks Position=" + this.trucks.readPosition()));
            this.simulateFilterPresenceSensors(positionInitiale, stepHeight);
            FCSCst.FCSLOG.debug((Object)(this.name + "i=" + i + ",position=" + this.position));
            try {
                Thread.sleep(100L);
                if (!this.trucks.getHaltRequired().get()) continue;
                FCSCst.FCSLOG.debug((Object)(this.name + " STOP simulated trucks motion."));
                return;
            }
            catch (InterruptedException ex) {
                FCSCst.FCSLOG.error((Object)ex);
                throw new RejectedCommandException(this.name + " sleep was interrupted.");
            }
        }
    }

    @Override
    public void configureDigitalInputOfLinearRails() {
    }

    @Override
    public void configureDigitalOutputOfLinearRails() {
    }

    @Override
    public void homing() {
        this.homingDone = true;
    }

    @Override
    public boolean isHomingDone() {
        return this.homingDone;
    }

    @Override
    public void activateBrakeAndDisable() {
        this.activateBrake();
        this.shutdownController();
    }

    @Override
    public void doReleaseBrake() {
        this.brakeActivated = false;
    }

    @Override
    public boolean isBrakeActivated() {
        return this.brakeActivated;
    }

    @Override
    public void activateBrake() {
        this.brakeActivated = true;
    }
}

