/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHYTTC580;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnTTC580;
import org.lsst.ccs.subsystems.fcs.common.TTC580Interface;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.utils.TTC580Utils;

public class CanOpenTTC580
extends CanOpenDevice
implements TTC580Interface {
    public static final String LOCKSENSOR = "lockSensor";
    public static final String FILTERPRESENCE = "filterPresence";
    public static final String SLAVE_MODULE_SENSOR = "slaveModuleSensor";
    public static final String XMINUS = "Xminus";
    public static final String XPLUS = "Xplus";
    protected int cobid1;
    protected int cobid2;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Map<String, SensorPluggedOnTTC580> sensorsMap;
    protected long pdo1;
    protected long pdo2;

    public int getCobid1() {
        return this.cobid1;
    }

    public int getCobid2() {
        return this.cobid2;
    }

    public CanOpenTTC580(int nodeID, String serialNB) {
        super(nodeID, serialNB);
        this.cobid1 = this.nodeID + 384;
        this.cobid2 = this.nodeID + 640;
        this.sensorsMap = new HashMap<String, SensorPluggedOnTTC580>();
        this.pdo1 = 0L;
        this.pdo2 = 0L;
    }

    public void init() {
        FCSCst.FCSLOG.info((Object)(this.name + " =====> initialization of my sensors map"));
        StringBuilder sb = new StringBuilder();
        Iterator<SensorPluggedOnTTC580> it = this.sensorsMap.values().iterator();
        while (it.hasNext()) {
            SensorPluggedOnTTC580 sensor = it.next();
            sb.append(sensor.getName());
            sb.append("====>");
            if (sensor.getDeviceName().equals(this.name)) {
                sb.append(" IS MY SENSOR ");
                sb.append(sensor.toString());
                sb.append("#\n");
                continue;
            }
            it.remove();
        }
        FCSCst.FCSLOG.info((Object)sb.toString());
        FCSCst.FCSLOG.info((Object)(this.name + " =====> MY SENSORS \n" + this.sensorsMap.toString()));
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="return PDO1 value")
    public long getPdo1() {
        return this.pdo1;
    }

    public void setPdo1(long pdoVal) {
        this.pdo1 = pdoVal;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="return PDO2 value")
    public long getPdo2() {
        return this.pdo2;
    }

    public void setPdo2(long pdo2) {
        this.pdo2 = pdo2;
    }

    @Override
    public void doInitializePDOs() throws DriverException {
        this.tcpProxy.addReceivedPDO(this.cobid1);
        this.tcpProxy.addReceivedPDO(this.cobid2);
        this.initialized = true;
    }

    @Override
    public void updateFromPDO(PDOData pdo) throws DriverException {
        long beginTime = System.currentTimeMillis();
        FCSCst.FCSLOG.info((Object)(this.name + " updatingFromPDO = " + pdo));
        boolean updated = false;
        if (pdo.getPDOs().containsKey(this.cobid1)) {
            this.pdo1 = (Long)pdo.getPDOs().get(this.cobid1);
            updated = true;
            short socketID1 = this.getSocketId(this.pdo1);
            FCSCst.FCSLOG.info((Object)(this.name + " updatingFromPDO1 = " + this.pdo1 + " binaire:" + Long.toBinaryString(this.pdo1)));
            if (socketID1 == 0) {
                FCSCst.FCSLOG.info((Object)(this.name + " no socket in STANDBY position"));
            } else if (socketID1 == 7) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, " error reading socketID for pdo1");
            } else if (socketID1 >= 1 && socketID1 <= 5) {
                this.sensorsMap.get(SLAVE_MODULE_SENSOR + socketID1).updateValue(1);
                this.updateSocketSensors(socketID1, this.pdo1);
            }
        }
        if (pdo.getPDOs().containsKey(this.cobid2)) {
            this.pdo2 = (Long)pdo.getPDOs().get(this.cobid2);
            updated = true;
            if (this.pdo2 == 0L) {
                this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, " pdo2 can't be 0 " + this.toString());
            } else {
                FCSCst.FCSLOG.info((Object)(this.name + " updatingFromPDO2 = " + this.pdo2 + " binaire:" + Long.toBinaryString(this.pdo2)));
                short socketID2 = this.getSocketId(this.pdo2);
                if (socketID2 == 0) {
                    this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, " socketID for pdo2 can't be 0");
                } else if (socketID2 == 7) {
                    this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, " error reading socketID for pdo2");
                } else if (socketID2 >= 1 && socketID2 <= 5) {
                    this.sensorsMap.get(SLAVE_MODULE_SENSOR + socketID2).updateValue(TTC580Utils.getSlaveModuleStatus(this.pdo2));
                    this.updateSocketSensors(socketID2, this.pdo2);
                }
            }
        }
        long duration = System.currentTimeMillis() - beginTime;
        FCSCst.FCSLOG.info((Object)(this.name + " updateFromPDO duration = " + duration));
        if (updated) {
            this.publishData();
        }
    }

    protected void updateSocketSensors(short socketID, long pdoValue) {
        FCSCst.FCSLOG.info((Object)(this.name + " updating socket sensors values for socketID=" + socketID));
        this.sensorsMap.get("lockSensorXminus" + socketID).updateValue(TTC580Utils.getLockXm(pdoValue));
        this.sensorsMap.get("lockSensorXplus" + socketID).updateValue(TTC580Utils.getLockXp(pdoValue));
        this.sensorsMap.get("filterPresenceXminus" + socketID).updateValue(TTC580Utils.getFilterPresenceXm(pdoValue));
        this.sensorsMap.get("filterPresenceXplus" + socketID).updateValue(TTC580Utils.getFilterPresenceXp(pdoValue));
    }

    @Override
    public short getSocketId(long pdo) {
        return (short)(pdo >>> 61);
    }

    @Override
    @Command(type=Command.CommandType.QUERY)
    public long readOffsetPresenceSensorSDO(byte socketID) {
        int subindex = Integer.parseInt(String.valueOf(socketID) + "0", 16);
        return this.readSDO(25604, subindex);
    }

    @Override
    @Command(type=Command.CommandType.QUERY)
    public long readOffsetLockSensorSDO(byte socketID) {
        int subindex = Integer.parseInt(String.valueOf(socketID) + "1", 16);
        return this.readSDO(25604, subindex);
    }

    @Command(type=Command.CommandType.QUERY)
    public int getOffsetPresenceSensorXplus(byte sid) {
        return TTC580Utils.getOffsetPresenceSensorXplus(this.readOffsetPresenceSensorSDO(sid));
    }

    @Command(type=Command.CommandType.QUERY)
    public int getOffsetPresenceSensorXminus(byte sid) {
        return TTC580Utils.getOffsetPresenceSensorXminus(this.readOffsetPresenceSensorSDO(sid));
    }

    @Command(type=Command.CommandType.QUERY)
    public int getOffsetLockSensorXminus(byte sid) {
        return TTC580Utils.getOffsetLockSensorXminus(this.readOffsetLockSensorSDO(sid));
    }

    @Command(type=Command.CommandType.QUERY)
    public int getOffsetLockSensorXplus(byte sid) {
        return TTC580Utils.getOffsetLockSensorXplus(this.readOffsetLockSensorSDO(sid));
    }

    @Command(type=Command.CommandType.QUERY, description="display newest error")
    public String displayNewestError() {
        int[] errors = this.readErrorHistory();
        return this.displayError(errors[0]);
    }

    @Override
    public String displayError(int error) {
        StringBuilder sb = new StringBuilder();
        sb.append("ErrorSource=");
        sb.append(TTC580Utils.getErrorSource(error));
        sb.append("; ErrorType=");
        sb.append(TTC580Utils.getErrorType(error));
        sb.append("; ErrorCounter=");
        sb.append(TTC580Utils.getErrorCounter(error));
        sb.append("; ErrorCode=");
        sb.append(TTC580Utils.getErrorCode(error));
        return sb.toString();
    }

    @Override
    @Command(type=Command.CommandType.QUERY)
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\n/pdo1=");
        sb.append(this.pdo1);
        sb.append(" in hexa:");
        sb.append(Long.toHexString(this.pdo1));
        sb.append(" in binaire:");
        sb.append(Long.toBinaryString(this.pdo1));
        sb.append("\n/pdo2=");
        sb.append(this.pdo2);
        sb.append(" in hexa:");
        sb.append(Long.toHexString(this.pdo2));
        sb.append(" in binaire:");
        sb.append(Long.toBinaryString(this.pdo2));
        sb.append(this.printSensorsValues());
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, description="for tests and debug.")
    public String printSensorsValues() {
        StringBuilder sb = new StringBuilder("\nSensors values read from pdo1:\n");
        if (this.pdo1 == 0L) {
            sb.append("No socket at Standby");
        } else {
            sb.append("Socket at Standby==>");
            sb.append(this.printSensorsForPdo(this.pdo1));
        }
        sb.append("\nSensors values read from pdo2:\n");
        sb.append("Socket not at Standby==>");
        sb.append(this.printSensorsForPdo(this.pdo2));
        return sb.toString();
    }

    private String printSensorsForPdo(long pdo) {
        StringBuilder sb = new StringBuilder("\n");
        sb.append("socketID=");
        sb.append(this.getSocketId(pdo));
        sb.append("/lockXminus=");
        sb.append(TTC580Utils.getLockXm(pdo));
        sb.append("/filterPresenceXminus=");
        sb.append(TTC580Utils.getFilterPresenceXm(pdo));
        sb.append("/lockXplus=");
        sb.append(TTC580Utils.getLockXp(pdo));
        sb.append("/filterPresenceXplus=");
        sb.append(TTC580Utils.getFilterPresenceXp(pdo));
        return sb.toString();
    }

    public StatusDataPublishedByHYTTC580 createStatusDataPublishedByHYTTC580() {
        StatusDataPublishedByHYTTC580 status = new StatusDataPublishedByHYTTC580(this.isBooted(), this.isInitialized());
        status.setPdo1(this.pdo1);
        status.setPdo2(this.pdo2);
        return status;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Publish data for hyttc580 device on the status bus.")
    public void publishData() {
        this.subs.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByHYTTC580()));
    }
}

