/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOSCarousel;

public class CanOpenEPOSCarouselClamp
extends CanOpenEPOS {
    protected int cobid1;
    private long pdo1;

    public CanOpenEPOSCarouselClamp(int nodeID, String serialNB) {
        super(nodeID, serialNB);
        this.cobid1 = this.nodeID + 384;
        this.pdo1 = 0L;
    }

    @Override
    public void doInitializePDOs() throws DriverException {
        this.tcpProxy.addReceivedPDO(this.cobid1);
    }

    @Override
    public void updateFromPDO(PDOData pdo) throws DriverException {
        FCSCst.FCSLOG.info((Object)(this.name + " updatingFromPDO = " + pdo));
        boolean updated = false;
        if (pdo.getPDOs().containsKey(this.cobid1)) {
            this.pdo1 = (Long)pdo.getPDOs().get(this.cobid1);
            updated = true;
            FCSCst.FCSLOG.info((Object)(this.name + " updatingFromPDO1 = " + this.pdo1 + " binaire:" + Long.toBinaryString(this.pdo1)));
            this.statusWord = CanOpenEPOSCarousel.extractStatusWord(this.pdo1);
            this.current = (short)CanOpenEPOSCarousel.extractCurrentAverage(this.pdo1);
            this.velocity = CanOpenEPOSCarousel.extractVelocity(this.pdo1);
        }
        if (updated) {
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="print values updated by PDOs to debug and test")
    public String printValuesUpdatedByPDOs() {
        StringBuilder sb = new StringBuilder("=> pdo1 value = ");
        sb.append(this.pdo1);
        sb.append(" / pdo1 = 0x");
        sb.append(Long.toHexString(this.pdo1));
        sb.append(" / status word = 0x");
        sb.append(Long.toHexString(this.statusWord));
        sb.append("\n status word = 0b");
        sb.append(Long.toBinaryString(this.statusWord));
        sb.append("\n current average = ");
        sb.append(this.current);
        sb.append(" / current average = 0x");
        sb.append(Long.toHexString(this.current));
        sb.append("\n velocity = ");
        sb.append(this.position);
        sb.append(" / velocity = 0x");
        sb.append(Long.toHexString(this.position));
        return sb.toString();
    }
}

