/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;

public class CarouselMain
extends MainModule {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Carousel carousel;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FilterHolder autochanger;

    public CarouselMain(BridgeToHardware bridge) {
        super(bridge);
    }

    public void init() {
        this.subs.setAgentProperty("org.lsst.ccs.subsystem.fcs.carousel", "carousel");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Update state in reading sensors.", timeout=2000)
    public void updateStateWithSensors() {
        super.updateStateWithSensors();
        this.carousel.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Update FCS state and FCS readyness state and publishes on the status bus.")
    public void updateFCSStateToReady() {
        if (this.carousel.isInitialized()) {
            this.subs.updateAgentState(new Enum[]{FcsEnumerations.FilterState.READY, FcsEnumerations.FilterReadinessState.READY});
        }
    }
}

