/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.SensorPluggedOnTTC580;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class CarouselClamp
extends MobileItem {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule mainModule;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Carousel carousel;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    protected EPOSController controller;
    private final SensorPluggedOnTTC580 filterPresenceSensor;
    private final SensorPluggedOnTTC580 lockSensor;
    private FcsEnumerations.FilterClampState clampState = FcsEnumerations.FilterClampState.UNDEFINED;
    private FcsEnumerations.FilterPresenceStatus filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    @ConfigurationParameter
    protected int currentToUnlock = -4660;
    @ConfigurationParameter
    protected int currentToMaintainUnlocked = 200;
    @ConfigurationParameter(range="0..32768")
    private Integer lockSensorMinValue = 200;
    @ConfigurationParameter
    protected Integer lockSensorValueA = 5000;
    @ConfigurationParameter(range="0..32768")
    protected Integer lockSensorValueB = 9500;
    @ConfigurationParameter(range="0..32768")
    protected Integer lockSensorMaxValue = 11000;
    @ConfigurationParameter(range="0..32768")
    protected Integer lockSensorOffset = 0;
    @ConfigurationParameter(range="0..32768")
    protected Integer filterPresenceMinValue = 50;
    @ConfigurationParameter
    protected Integer filterPresenceValueA = 1200;
    @ConfigurationParameter(range="0..32768")
    protected Integer filterPresenceValueB = 10000;
    @ConfigurationParameter(range="0..32768")
    private Integer filterPresenceMaxValue = 12000;
    @ConfigurationParameter(range="0..32768")
    protected Integer filterPresenceOffset = 0;
    @ConfigurationParameter(range="0..10000")
    protected long timeoutForUnlocking = 1500L;
    @ConfigurationParameter(range="0..10000")
    protected long timeoutForReleasing = 1500L;
    private boolean atStandby;

    public CarouselClamp(SensorPluggedOnTTC580 filterPresenceSensor, SensorPluggedOnTTC580 lockSensor) {
        this.filterPresenceSensor = filterPresenceSensor;
        this.lockSensor = lockSensor;
    }

    public boolean isAtStandby() {
        return this.atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }

    public short getCurrentToUnlock() {
        return (short)this.currentToUnlock;
    }

    protected void setController(EPOSController actuator) {
        this.controller = actuator;
    }

    public int getLockSensorValueA() {
        return this.lockSensorValueA;
    }

    public int getLockSensorValueB() {
        return this.lockSensorValueB;
    }

    public int getLockSensorMaxValue() {
        return this.lockSensorMaxValue;
    }

    public int getFilterPresenceMinValue() {
        return this.filterPresenceMinValue;
    }

    public int getFilterPresenceValueA() {
        return this.filterPresenceValueA;
    }

    public int getFilterPresenceValueB() {
        return this.filterPresenceValueB;
    }

    public SensorPluggedOnTTC580 getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public SensorPluggedOnTTC580 getLockSensor() {
        return this.lockSensor;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return the lockStatus")
    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="return filterPresenceStatus")
    public FcsEnumerations.FilterPresenceStatus getFilterPresenceStatus() {
        return this.filterPresenceStatus;
    }

    public void setLockSensorValueA(Integer lockSensorValueA) {
        this.lockSensorValueA = lockSensorValueA;
        this.configurationService.change(this.name, "lockSensorValueA", (Object)lockSensorValueA);
    }

    public void setLockSensorValueB(Integer lockSensorValueB) {
        this.lockSensorValueB = lockSensorValueB;
    }

    public void setLockSensorMaxValue(Integer maxValue) {
        this.lockSensorMaxValue = maxValue;
    }

    public void setFilterPresenceMinValue(Integer value) {
        this.filterPresenceMinValue = value;
    }

    public void setFilterPresenceValueA(Integer value) {
        this.filterPresenceValueA = value;
        this.configurationService.change(this.name, "filterPresenceValueA", (Object)value);
    }

    public void setFilterPresenceValueB(Integer filterPresenceValue) {
        this.filterPresenceValueB = filterPresenceValue;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if CANopen hardware is connected and ready.")
    public boolean myDevicesReady() {
        return this.mainModule.allDevicesBooted();
    }

    public FcsEnumerations.FilterClampState getClampState() {
        return this.clampState;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the clamp is locked")
    public boolean isLocked() {
        return this.lockStatus == FcsEnumerations.LockStatus.LOCKED;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if filter is engaged on the clamp : filter presence sensors sees it ")
    public boolean isFilterEngaged() {
        return this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.LOCKABLE;
    }

    public void updateFilterPresenceStatus() {
        int newFilterPresenceSensorValue = this.filterPresenceSensor.getValue();
        int mechaValue = newFilterPresenceSensorValue - this.filterPresenceOffset;
        if (mechaValue < this.filterPresenceMinValue) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, this.name + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue + " must be >= " + this.filterPresenceMinValue, this.name);
        } else if (mechaValue < this.filterPresenceValueA) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.LOCKABLE;
        } else if (mechaValue < this.filterPresenceValueB) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE;
        } else if (mechaValue < this.filterPresenceMaxValue) {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.NOFILTER;
        } else {
            this.filterPresenceStatus = FcsEnumerations.FilterPresenceStatus.ERROR;
            this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, this.name + " ERROR new read value FOR FILTER POSITION SENSOR  = " + newFilterPresenceSensorValue + " must be <=" + this.filterPresenceMaxValue, this.name);
        }
    }

    public void updateLockStatus() {
        int mechaValue = this.lockSensor.getValue() - this.lockSensorOffset;
        if (mechaValue < this.lockSensorMinValue) {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, this.name + " ERROR new read value FOR LOCK SENSOR  = " + mechaValue + " should be >= " + this.lockSensorMinValue, this.name);
        } else if (mechaValue < this.lockSensorValueA) {
            this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
        } else if (mechaValue <= this.lockSensorValueB) {
            this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        } else if (mechaValue <= this.lockSensorMaxValue) {
            this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
        } else {
            this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            this.raiseAlarm(FcsEnumerations.FcsAlert.CA_SENSOR_ERROR, this.name + " ERROR new read value FOR LOCK SENSOR  = " + mechaValue + " should be <= " + this.lockSensorMaxValue, this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.QUERY, description=" update Clamp State.")
    public void updateState() {
        CarouselClamp carouselClamp = this;
        synchronized (carouselClamp) {
            this.updateFilterPresenceStatus();
            this.updateLockStatus();
            this.computeClampState();
        }
        this.publishData();
    }

    @Override
    public void publishData() {
        StatusDataPublishedByCarouselClamp status = this.createStatusDataPublishedByClamp();
        this.s.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)status));
    }

    public StatusDataPublishedByCarouselClamp createStatusDataPublishedByClamp() {
        StatusDataPublishedByCarouselClamp status = new StatusDataPublishedByCarouselClamp();
        status.setClampState(this.clampState);
        status.setFilterPresenceStatus(this.filterPresenceStatus);
        status.setFilterPositionSensorValue(this.filterPresenceSensor.getValue());
        status.setLockSensorValue(this.lockSensor.getValue());
        status.setLockStatus(this.lockStatus);
        status.setLockSensorValueA(this.lockSensorValueA.intValue());
        status.setFilterPresenceValueA(this.filterPresenceValueA.intValue());
        return status;
    }

    private void computeClampState() {
        this.clampState = this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.ERROR || this.lockStatus == FcsEnumerations.LockStatus.ERROR ? FcsEnumerations.FilterClampState.ERROR : (this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE ? FcsEnumerations.FilterClampState.UNLOCKABLE : (this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.LOCKABLE ? (this.lockStatus == FcsEnumerations.LockStatus.LOCKED ? FcsEnumerations.FilterClampState.CLAMPEDONFILTER : (this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED ? FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER : FcsEnumerations.FilterClampState.UNDEFINED)) : (this.filterPresenceStatus == FcsEnumerations.FilterPresenceStatus.NOFILTER ? (this.lockStatus == FcsEnumerations.LockStatus.LOCKED ? FcsEnumerations.FilterClampState.READYTOCLAMP : (this.lockStatus == FcsEnumerations.LockStatus.UNLOCKED ? FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY : FcsEnumerations.FilterClampState.UNDEFINED)) : FcsEnumerations.FilterClampState.UNDEFINED)));
    }

    private void computeClampStateWhenReleasing() {
        if (this.name.contains("Xminus") && this.clampState == FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY) {
            this.clampState = FcsEnumerations.FilterClampState.READYTOCLAMP;
        }
    }

    @Command(level=3, type=Command.CommandType.ACTION, description="Release clamp in order to get ready to clamp a filter again")
    public void release() {
        FCSLOG.info((Object)("Checking conditions for release clamp " + this.name + " on socket at standby position."));
        this.carousel.updateSocketAtStandbyWithSensors();
        this.checkIsAtStandby();
        if (this.clampState != FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY) {
            throw new RejectedCommandException("Can't release a clamp if isn't unclamped and empty.");
        }
        FCSLOG.info((Object)("Releasing clamp " + this.name + " on socket at standby position."));
        this.executeAction(FcsEnumerations.MobileItemAction.RELEASE, this.timeoutForUnlocking);
    }

    @Command(level=3, type=Command.CommandType.ACTION, description="Check if controller has been disabled.")
    public boolean isReleased() {
        return !this.controller.isEnabled();
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Unlock the clamp")
    public void unlock() {
        FCSLOG.info((Object)(this.name + ": UNLOCK State1 = " + this.clampState.toString()));
        this.carousel.updateSocketAtStandbyWithSensors();
        this.checkIsAtStandby();
        if (this.clampState != FcsEnumerations.FilterClampState.CLAMPEDONFILTER) {
            throw new RejectedCommandException("Can't unlock a clamp if it is already unlocked.");
        }
        if (this.autochanger.isAtStandby() && !this.autochanger.isHoldingFilter()) {
            throw new RejectedCommandException("CANNOT UNLOCK A CLAMP if FILTER is not HELD by autochanger.");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.UNLOCK, this.timeoutForUnlocking);
    }

    public void checkIsAtStandby() {
        if (!this.isAtStandby()) {
            throw new RejectedCommandException(this.name + " is not at STANDBY. Can't be moved.");
        }
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCK) {
            this.controller.enable();
            this.controller.writeCurrent((short)this.currentToUnlock);
        } else if (action == FcsEnumerations.MobileItemAction.RELEASE) {
            this.controller.disableOperation();
        } else {
            throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
        }
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action == FcsEnumerations.MobileItemAction.UNLOCK) {
            return this.clampState == FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER;
        }
        if (action == FcsEnumerations.MobileItemAction.RELEASE) {
            return !this.controller.isEnabled();
        }
        throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.carousel.updateSocketAtStandbyWithSensors();
    }

    public double updateTemperature() {
        return 0.0;
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.info((Object)("Current Command: " + this.s.getCurrentAction()));
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

