/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerTruck;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.common.ADCInterface;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForLinearRail;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class AutochangerTwoTrucks
extends MobileItem
implements ClearAlertHandler {
    private AutochangerTruck truckXminus;
    private AutochangerTruck truckXplus;
    @ConfigurationParameter(description="minimal position for AC trucks")
    private final int minActualPositionValue = 0;
    @ConfigurationParameter(description="maximal position for AC trucks")
    private final int maxActualPositionValue = 1200000;
    @ConfigurationParameter(description="STANDBY position in micron")
    private int standbyPosition = 992000;
    @ConfigurationParameter(description="HANDOFF position in micron")
    private int handoffPosition = 70000;
    @ConfigurationParameter(description="ONLINE position in micron")
    private int onlinePosition = 2600;
    @ConfigurationParameter(description="tim for trucks motion from ONLINE to STANDBY in milliseconds")
    private long timeoutForTrucksMotion = 20000L;
    @ConfigurationParameter(description="prelimary ONLINE position in micron, used by process whichmoves a filter at ONLINE position.")
    private int prelimaryTargetPosition = 3367;
    @ConfigurationParameter(description="natural position at ONLINE position in micron  used by process whichmoves a filter at ONLINE position.")
    private int naturalPosition = 3215;
    @ConfigurationParameter(description="lowest position to be used by command moveAndClampFilterOnline.")
    private int minTargetPosition = 1800;
    @ConfigurationParameter(description="minimum value of voltage read on proximitySensor.", units="Volt")
    private double umin = 4.2;
    @ConfigurationParameter(description="maximum value of voltage read on proximitySensor. Unit: Volts")
    private double umax = 4.6;
    @ConfigurationParameter(description="voltage target on proximitySensor. Unit: Volts")
    private double utarget = 3.85;
    @ConfigurationParameter(description="adjustment factor. Unit: micrometre/volt")
    private double adjustmentFactor = 835.0;
    @ConfigurationParameter(description="low speed to approch STANDBY position")
    private int lowSpeed = 50;
    @ConfigurationParameter(description="high speed to approch STANDBY position")
    private int highSpeed = 310;
    @ConfigurationParameter(description="low acceleration to approch STANDBY position")
    private int lowAcceleration = 150;
    @ConfigurationParameter(description="high acceleration to approch STANDBY position")
    private int highAcceleration = 310;
    @ConfigurationParameter(description="low deceleration to approch STANDBY position")
    private int lowDeceleration = 50;
    @ConfigurationParameter(description="high deceleration to approch STANDBY position")
    private int highDeceleration = 310;
    @ConfigurationParameter(description="approch STANDBY position")
    private int approchPosition = 960000;
    private int current = 0;
    private int speed = 0;
    private long profileVelocity;
    private int masterPosition;
    private int slavePosition;
    private int deltaPosition;
    @ConfigurationParameter(description="masterPosition is reached if |targetPosition - masterPosition| < positionRange")
    private int positionRange = 2;
    @ConfigurationParameter(description="an alignment of slave must be done when |deltaPosition| > deltaPositionMax")
    private int deltaPositionMax = 100;
    private int absoluteTargetPosition = 0;
    private int slaveTargetPosition = 0;
    private EPOSControllerForLinearRail linearRailMasterController;
    private EPOSControllerForLinearRail linearRailSlaveController;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule main;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private ADCInterface proximitySensorsDevice;
    @ConfigurationParameter(description="input number on the ADC where proximity sensor is plugged", range="1..4")
    private int proximitySensorInput = 1;
    private boolean atHandoff = false;
    private boolean atOnline = false;
    private boolean atStandby = false;

    public AutochangerTwoTrucks(AutochangerTruck truckXminus, AutochangerTruck truckXplus, EPOSControllerForLinearRail linearRailMasterController, EPOSControllerForLinearRail linearRailSlaveController) {
        this.truckXminus = truckXminus;
        this.truckXplus = truckXplus;
        this.linearRailMasterController = linearRailMasterController;
        this.linearRailSlaveController = linearRailSlaveController;
    }

    @ConfigurationParameterChanger
    public void setNaturalPosition(int pos) {
        int minLimit = this.onlinePosition - 1500;
        int maxLimit = this.onlinePosition + 1500;
        if (pos < minLimit || pos > maxLimit) {
            throw new IllegalArgumentException(pos + " bad value for natural position must be > " + minLimit + " and < " + maxLimit);
        }
        this.naturalPosition = pos;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return actual trucks position (master position). Doesn't read again the position on the controller.")
    public int getPosition() {
        return this.masterPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return HANDOFF position. Doesn't read again the position on the controller.")
    public int getHandoffPosition() {
        return this.handoffPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return STANDBY position. Doesn't read again the position on the controller.")
    public int getStandbyPosition() {
        return this.standbyPosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return ONLINE position. Doesn't read again the position on the controller.")
    public int getOnlinePosition() {
        return this.onlinePosition;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return timeout for trucks motion.")
    public long getTimeoutForTrucksMotion() {
        return this.timeoutForTrucksMotion;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at handoff position. This command doesn't read again the sensors.")
    public boolean isAtHandoff() {
        return this.atHandoff;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at ONLINE position. This command doesn't read again the sensors.")
    public boolean isAtOnline() {
        return this.atOnline;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the carrier is at STANDBY position. This command doesn't read again the sensors.")
    public boolean isAtStandby() {
        return this.atStandby;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the homing of the trucks has been done.")
    public boolean isHomingDone() {
        return this.linearRailSlaveController.isHomingDone() && this.linearRailMasterController.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if TruckXminus position sensors or TruckXminus position sensors are in error.")
    public boolean isPositionSensorsInError() {
        return this.truckXminus.isPositionSensorsInError() || this.truckXplus.isPositionSensorsInError() || this.positionSensorsNonConsistant();
    }

    private boolean positionSensorsNonConsistant() {
        return this.isAtStandby() && this.isAtHandoff() || this.isAtStandby() && this.isAtOnline() || this.isAtHandoff() && this.isAtOnline();
    }

    private void checkControllersName() {
        if (!this.truckXminus.getControllerName().contains("Master")) {
            throw new FcsHardwareException("truckXminus has to be controlled by Master controller.");
        }
        FCSLOG.info((Object)(this.name + " is controlled by " + this.truckXminus.getControllerName()));
        if (!this.truckXplus.getControllerName().contains("Slave")) {
            throw new FcsHardwareException("truckXplus has to be controlled by Slave controller.");
        }
        FCSLOG.info((Object)(this.name + " is controlled by " + this.truckXplus.getControllerName()));
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.linearRailSlaveController.isBooted() && this.linearRailMasterController.isBooted()) {
            this.initializeControllers();
        }
        if (this.proximitySensorsDevice.isBooted()) {
            this.proximitySensorsDevice.initializeAndCheckHardware();
            this.proximitySensorsDevice.publishData();
        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " can't clamp at ONLINE if proximitySensorsDevice not booted", this.name);
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    public void initializeControllers() {
        try {
            this.checkControllersName();
            this.linearRailSlaveController.initializeAndCheckHardware();
            this.linearRailMasterController.initializeAndCheckHardware();
            if (this.autochanger.isLinearRailMotionAllowed()) {
                this.homing();
            }
        }
        catch (FailedCommandException | FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "Couldn't initialize controllers", this.name, (Exception)ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Configure Autochanger trucks master and slave controllers.", alias="initControllers")
    public void configureControllers() {
        FCSLOG.info((Object)(this.name + " Begin configuration of the controllers"));
        this.linearRailMasterController.configureDigitalInputOfLinearRails();
        this.linearRailSlaveController.configureDigitalInputOfLinearRails();
        this.linearRailMasterController.configureDigitalOutputOfLinearRails();
        this.linearRailSlaveController.configureDigitalOutputOfLinearRails();
        FCSLOG.info((Object)(this.name + " End configuration of the controllers"));
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if both controllers are initialized and homing of trucks are done.")
    public boolean isInitialized() {
        return this.linearRailMasterController.isInitialized() && this.linearRailSlaveController.isInitialized() && this.isHomingDone();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the motion of trucks are allowed.")
    public void checkConditionsForTrucksMotion() {
        this.autochanger.checkFilterSafetyBeforeMotion();
        this.checkPrerequisitesForTrucksMotion();
    }

    private void checkPrerequisitesForTrucksMotion() {
        if (!this.linearRailSlaveController.isInitialized() || !this.linearRailMasterController.isInitialized()) {
            String msg = this.name + " can't move autochanger trucks because controllers are not both initialized:\n";
            FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
        this.updatePosition();
        this.checkDeltaPosition();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Handoff position.", alias="goToHandoff")
    public void goToHandOff() {
        this.moveToAbsoluteTargetPosition(this.handoffPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Online position.")
    public void goToOnline() {
        this.moveToAbsoluteTargetPosition(this.onlinePosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the Standby position.")
    public void goToStandby() {
        this.moveToAbsoluteTargetPosition(this.standbyPosition);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move Autochanger trucks to the absolute position given as argument. At the end of motion : doesn't align slave, active brakes and disable controllers", alias="mobeABSPos", timeout=20000)
    public void moveToAbsoluteTargetPosition(int targetPosition) {
        if (targetPosition < 0 || targetPosition > 1200000) {
            throw new IllegalArgumentException(this.name + "argument has to be between " + 0 + " and " + 1200000);
        }
        this.updatePosition();
        if (this.masterPosition == targetPosition) {
            FCSLOG.info((Object)(this.name + " is already at target position=" + targetPosition));
        } else {
            this.checkConditionsForTrucksMotion();
            this.checkControllersMode();
            this.checkReadyForAction();
            this.absoluteTargetPosition = targetPosition;
            FCSLOG.info((Object)(this.name + " going to absolute position: " + this.absoluteTargetPosition));
            if (this.absoluteTargetPosition == this.handoffPosition) {
                this.main.updateAgentState(FcsEnumerations.FilterState.MOVING_TRUCKS_TO_HANDOFF, FcsEnumerations.FilterReadinessState.NOT_READY);
            } else if (this.absoluteTargetPosition == this.standbyPosition) {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY, FcsEnumerations.FilterReadinessState.NOT_READY});
            } else if (this.absoluteTargetPosition == this.onlinePosition) {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE, FcsEnumerations.FilterReadinessState.NOT_READY});
            } else {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS, FcsEnumerations.FilterReadinessState.NOT_READY});
            }
            this.goToPosition(this.absoluteTargetPosition);
            this.checkPositionSensors();
            this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.TRUCKS_STOPPED, FcsEnumerations.FilterReadinessState.READY});
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Move Autochanger trucks to the absolute position given as argument. At the end of motion : doesn't align slave, active brakes and disable controllers VERY DANGEROUS COMMAND. Only for tests with prototype.", timeout=20000)
    public void moveToAbsoluteTargetPositionDangerous(int targetPosition) {
        if (targetPosition < 0 || targetPosition > 1200000) {
            throw new IllegalArgumentException(this.name + " argument has to be between " + 0 + " and " + 1200000);
        }
        this.updatePosition();
        if (this.masterPosition == targetPosition) {
            FCSLOG.info((Object)(this.name + " is already at target position=" + targetPosition));
        } else {
            this.checkPrerequisitesForTrucksMotion();
            this.checkControllersMode();
            this.checkReadyForAction();
            this.absoluteTargetPosition = targetPosition;
            FCSLOG.info((Object)(this.name + " going to absolute position: " + this.absoluteTargetPosition));
            if (this.absoluteTargetPosition == this.handoffPosition) {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_HANDOFF, FcsEnumerations.FilterReadinessState.NOT_READY});
            } else if (this.absoluteTargetPosition == this.standbyPosition) {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY, FcsEnumerations.FilterReadinessState.NOT_READY});
            } else if (this.absoluteTargetPosition == this.onlinePosition) {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE, FcsEnumerations.FilterReadinessState.NOT_READY});
            } else {
                this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS, FcsEnumerations.FilterReadinessState.NOT_READY});
            }
            this.goToPosition(this.absoluteTargetPosition);
            this.checkPositionSensors();
            this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.TRUCKS_STOPPED, FcsEnumerations.FilterReadinessState.READY});
            this.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="goToOnline with filter, adjust position, close and lock clamps", timeout=20000)
    public void moveAndClampFilterOnline() {
        FCSLOG.info((Object)(this.name + " BEGIN process docking ONLINE."));
        this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_ONLINE, FcsEnumerations.FilterReadinessState.NOT_READY});
        this.moveToAbsoluteTargetPosition(this.prelimaryTargetPosition);
        this.alignSlave();
        double umeasured = this.readProximitySensorDevice();
        int newTargetPosition = (int)((double)this.prelimaryTargetPosition + this.adjustmentFactor * (this.utarget - umeasured));
        FCSLOG.info((Object)(this.name + " new computed target position=" + newTargetPosition));
        newTargetPosition = Math.max(this.minTargetPosition, newTargetPosition);
        FCSLOG.info((Object)(this.name + " new target position=" + newTargetPosition));
        this.goToPosition(newTargetPosition);
        this.autochanger.getOnlineClamps().closeAndLockClamps();
        umeasured = this.readProximitySensorDevice();
        if (umeasured > this.umax) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_TRUCKS_ERROR, " voltage returned by proximity sensor is too high.");
        } else if (umeasured < this.umin) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.AC_TRUCKS_ERROR, " voltage returned by proximity sensor is too low.");
        }
        this.goToPosition(this.naturalPosition);
        FCSLOG.info((Object)(this.name + " END process docking ONLINE."));
        this.autochanger.updateFCSStateToReady();
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, description="move filter to STANDBY with high speed, and move to STANDBY with lowSpeed.", timeout=20000)
    public void moveFilterToStandby() {
        this.updatePosition();
        if (this.masterPosition < this.approchPosition + 1000) {
            this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.MOVING_TRUCKS_TO_STANDBY, FcsEnumerations.FilterReadinessState.NOT_READY});
            this.raiseProfileVelocity();
            this.moveToAbsoluteTargetPosition(this.approchPosition);
            this.slowProfileVelocity();
            this.goToPosition(this.standbyPosition);
        }
    }

    private void goToPosition(int targetPosition) {
        FCSLOG.info((Object)(this.name + " moving to position " + targetPosition));
        this.absoluteTargetPosition = targetPosition;
        this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION, this.timeoutForTrucksMotion);
        this.agentStateService.updateAgentState(new Enum[]{FcsEnumerations.FilterState.TRUCKS_STOPPED, FcsEnumerations.FilterReadinessState.READY});
    }

    private void stopGoingToPosition() {
        this.linearRailMasterController.activateBrake();
        this.linearRailSlaveController.activateBrake();
        FcsUtils.sleep(100, this.name);
        this.linearRailMasterController.stopPosition();
        this.linearRailMasterController.disableOperation();
        this.linearRailSlaveController.disableOperation();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Activate brakes and disable the 2 controllers.")
    public void activateBrakesAndDisable() {
        this.linearRailMasterController.activateBrake();
        this.linearRailSlaveController.activateBrake();
        this.linearRailMasterController.disableOperation();
        this.linearRailSlaveController.disableOperation();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        this.autochanger.checkLinearRailMotionAllowed();
        if (!this.isHomingDone()) {
            this.homing();
        }
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                this.checkControllersMode();
                this.enableControllersAndReleaseBrake();
                this.linearRailMasterController.writeTargetPosition(this.absoluteTargetPosition);
                this.linearRailMasterController.writeControlWord(63);
                this.autochanger.increaseLinearRailsCurrentMonitoring();
                break;
            }
            case ALIGN_SLAVE: {
                this.linearRailSlaveController.enableAndReleaseBrake();
                this.linearRailSlaveController.writeTargetPosition(this.slaveTargetPosition);
                this.linearRailSlaveController.writeControlWord(63);
                break;
            }
            case MOVE_TRUCK_XMINUS: {
                this.linearRailMasterController.enableAndReleaseBrake();
                this.linearRailMasterController.writeTargetPosition(this.absoluteTargetPosition);
                this.linearRailMasterController.writeControlWord(63);
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.info((Object)(this.name + " STOPPING action: " + action.toString()));
        if (action == FcsEnumerations.MobileItemAction.MOVE_TO_ABSOLUTE_POSITION) {
            this.stopGoingToPosition();
            this.autochanger.decreaseLinearRailsCurrentMonitoring();
        } else if (action == FcsEnumerations.MobileItemAction.ALIGN_SLAVE) {
            this.stopAlignSlave();
        } else {
            this.linearRailMasterController.disableOperation();
            this.linearRailSlaveController.disableOperation();
        }
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.linearRailMasterController.quickStop();
        this.linearRailSlaveController.quickStop();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Enable and release brake for the 2 controllers.")
    public void enableControllersAndReleaseBrake() {
        this.linearRailMasterController.enable();
        this.linearRailSlaveController.enable();
        this.linearRailMasterController.doReleaseBrake();
        if (!this.linearRailMasterController.isEnabled()) {
            throw new FcsHardwareException(this.name + " can't release Slave Controller brake  because Master Controller is disabled.");
        }
        this.linearRailSlaveController.doReleaseBrake();
    }

    private void checkControllersMode() {
        if (!this.linearRailMasterController.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new FcsHardwareException(this.name + " : linearRailMasterController is not in PROFILE_POSITION mode, can't move.");
        }
        if (!this.linearRailSlaveController.isInMode(EPOSEnumerations.EposMode.MASTER_ENCODER)) {
            throw new FcsHardwareException(this.name + " : linearRailSlaveController is not in MASTER_ENCODER mode, can't move. Slave controller mode =" + this.linearRailSlaveController.getMode());
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Align slave controller position to master controller position.", timeout=20000)
    public void alignSlave() {
        if (this.linearRailMasterController.isEnabled()) {
            throw new FcsHardwareException(this.name + " master controller must be disabled.");
        }
        if (!this.linearRailMasterController.isBrakeActivated()) {
            throw new FcsHardwareException(this.name + " master controller brake must be activated.");
        }
        this.updatePosition();
        if (Math.abs(this.deltaPosition) > this.deltaPositionMax) {
            this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
            this.doAlignSlave(this.masterPosition);
        }
    }

    private void stopAlignSlave() {
        FCSLOG.info((Object)(this.name + " STOP ALIGN SLAVE"));
        this.linearRailSlaveController.activateBrake();
        FcsUtils.sleep(100, this.name);
        this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.MASTER_ENCODER);
        this.linearRailSlaveController.disableOperation();
        FCSLOG.info((Object)(this.name + " END STOP ALIGN SLAVE"));
    }

    private void doAlignSlave(int pos) {
        FCSLOG.info((Object)(this.name + " slave's alignment to be done. deltaPosition= " + this.deltaPosition));
        if (!this.linearRailSlaveController.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new FcsHardwareException(this.name + " can't align slave truck because couldn't change its mode to PROFILE_POSITION.");
        }
        this.slaveTargetPosition = pos;
        this.executeAction(FcsEnumerations.MobileItemAction.ALIGN_SLAVE, this.timeoutForTrucksMotion);
    }

    @Command(type=Command.CommandType.QUERY, description="move truckXminus (master controller) independently of truckXplus (slave controller)")
    public void moveTruckXminus(int newPos) {
        int slavePos = this.linearRailSlaveController.readPosition();
        if (Math.abs(slavePos - newPos) >= 2000) {
            throw new IllegalArgumentException(this.name + " newPos must be such as |newPos - slavePosition| < 2000");
        }
        this.activateBrakesAndDisable();
        this.linearRailSlaveController.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.absoluteTargetPosition = newPos;
        this.executeAction(FcsEnumerations.MobileItemAction.MOVE_TRUCK_XMINUS, this.timeoutForTrucksMotion);
    }

    public void checkPositionSensors() {
        this.autochanger.updateStateWithSensors();
        if (this.absoluteTargetPosition == this.standbyPosition && !this.atStandby) {
            throw new FailedCommandException(this.name + ": check with sensors: STANDBY sensors don't confirm trucks position.");
        }
        if (this.absoluteTargetPosition == this.handoffPosition && !this.atHandoff) {
            FCSLOG.info((Object)("this.absoluteTargetPosition=" + this.absoluteTargetPosition));
            FCSLOG.info((Object)("this.handoffPosition=" + this.handoffPosition));
            FCSLOG.info((Object)("this.atHandoff=" + this.atHandoff));
            throw new FailedCommandException(this.name + ": check with sensors: HANDOFF sensors don't confirm trucks position.");
        }
        if (this.absoluteTargetPosition == this.onlinePosition && !this.atOnline) {
            throw new FailedCommandException(this.name + ": check with sensors: ONLINE sensors don't confirm trucks position.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Do homing for both  controllers.")
    public void homing() {
        this.linearRailMasterController.homing();
        this.linearRailSlaveController.homing();
        this.updatePosition();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Update trucks position in reading controller.")
    public void updatePosition() {
        this.truckXminus.updatePosition();
        this.truckXplus.updatePosition();
        this.masterPosition = this.truckXminus.getPosition();
        this.slavePosition = this.truckXplus.getPosition();
        this.deltaPosition = this.masterPosition - this.slavePosition;
        this.publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read position on controllers, compute difference and throw exceptionif difference is > 1000.")
    public void checkDeltaPosition() {
        this.updatePosition();
        if (Math.abs(this.deltaPosition) > 1000) {
            String msg = "Too much difference between trucks position. Alignment of Slave Truck to be done.";
            throw new FcsHardwareException(this.name + ":" + msg);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Update trucks position in reading controller and return position.")
    public int readPosition() {
        this.updatePosition();
        return this.masterPosition;
    }

    @Command(type=Command.CommandType.QUERY, description="Return a voltage in mV which represents a distance between between filterand filter beam.")
    public double readProximitySensorDevice() {
        return this.proximitySensorsDevice.readVoltage(this.proximitySensorInput);
    }

    @Override
    public boolean myDevicesReady() {
        return this.isInitialized();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case MOVE_TO_ABSOLUTE_POSITION: {
                FCSLOG.finest((Object)(this.name + " linearRailMasterController.isTargetReached()=" + this.linearRailMasterController.isTargetReached() + " /masterPosition=" + this.masterPosition + " /absoluteTargetPosition=" + this.absoluteTargetPosition));
                return this.linearRailMasterController.isTargetReached() && Math.abs(this.masterPosition - this.absoluteTargetPosition) < this.positionRange;
            }
            case ALIGN_SLAVE: {
                return this.linearRailSlaveController.isTargetReached() && Math.abs(this.deltaPosition) < this.deltaPositionMax;
            }
            case MOVE_TRUCK_XMINUS: {
                return this.linearRailMasterController.isTargetReached() && Math.abs(this.masterPosition - this.absoluteTargetPosition) < this.positionRange;
            }
        }
        assert (false) : action;
        return false;
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        try {
            this.linearRailMasterController.checkFault();
            this.linearRailSlaveController.checkFault();
            this.updatePosition();
            int maCurrent = this.linearRailMasterController.readCurrentAverageValue();
            int saCurrent = this.linearRailSlaveController.readCurrentAverageValue();
            FCSLOG.finest((Object)(this.name + " position=" + this.masterPosition));
            FCSLOG.finest((Object)(this.name + " master averageCurrent=" + maCurrent));
            FCSLOG.finest((Object)(this.name + " slave averageCurrent=" + saCurrent));
            this.autochanger.updateStateWithSensors();
        }
        catch (SDORequestException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, "=> ERROR IN READING CONTROLLERS:", this.name, (Exception)((Object)ex));
        }
    }

    synchronized void updateState() {
        this.atHandoff = this.truckXminus.isAtHandoff() && this.truckXplus.isAtHandoff();
        this.atOnline = this.truckXminus.isAtOnline() && this.truckXplus.isAtOnline();
        this.atStandby = this.truckXminus.isAtStandby() && this.truckXplus.isAtStandby();
        this.updatePosition();
    }

    @Command(type=Command.CommandType.ACTION, description="change ProfileVelocity parameter to lowSpeed, slowProfileAcceleration and slowProfileDeceleration")
    public void slowProfileVelocity() {
        this.profileVelocity = this.lowSpeed;
        this.linearRailMasterController.changeProfileVelocity(this.lowSpeed);
        this.linearRailSlaveController.changeProfileVelocity(this.lowSpeed);
        this.checkProfileVelocity();
        FCSLOG.info((Object)(this.name + " new ProfileVelocity=" + this.lowSpeed));
        this.slowProfileAcceleration();
        this.slowProfileDeceleration();
    }

    @Command(type=Command.CommandType.ACTION, description="change ProfileVelocity, ProfileAcceleration, ProfileDeceleration parameters to highSpeed")
    public void raiseProfileVelocity() {
        this.profileVelocity = this.highSpeed;
        this.linearRailMasterController.changeProfileVelocity(this.highSpeed);
        this.linearRailSlaveController.changeProfileVelocity(this.highSpeed);
        this.checkProfileVelocity();
        FCSLOG.info((Object)(this.name + " new ProfileVelocity=" + this.highSpeed));
        this.raiseProfileAcceleration();
        this.raiseProfileDeceleration();
    }

    private void checkProfileVelocity() {
        int masterV;
        int slaveV = this.linearRailSlaveController.readVelocity();
        if (slaveV != (masterV = this.linearRailMasterController.readVelocity())) {
            throw new FcsHardwareException(this.name + " master and slave ProfileVelocity are not the same.");
        }
    }

    @Command(type=Command.CommandType.ACTION, description="change ProfileAcceleration parameter to highAcceleration")
    public void raiseProfileAcceleration() {
        this.linearRailMasterController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.highAcceleration);
        this.linearRailSlaveController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.highAcceleration);
        FCSLOG.info((Object)(this.name + " new ProfileAcceleration=" + this.highAcceleration));
    }

    @Command(type=Command.CommandType.ACTION, description="change ProfileAcceleration parameter to lowAcceleration")
    public void slowProfileAcceleration() {
        this.linearRailMasterController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.lowAcceleration);
        this.linearRailSlaveController.writeParameter(EPOSEnumerations.Parameter.ProfileAcceleration, this.lowAcceleration);
        FCSLOG.info((Object)(this.name + " new ProfileAcceleration=" + this.lowAcceleration));
    }

    @Command(type=Command.CommandType.ACTION, description="change ProfileAcceleration parameter to highAcceleration")
    public void raiseProfileDeceleration() {
        this.linearRailMasterController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.highDeceleration);
        this.linearRailSlaveController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.highDeceleration);
        FCSLOG.info((Object)(this.name + " new ProfileDeceleration=" + this.highDeceleration));
    }

    @Command(type=Command.CommandType.ACTION, description="change ProfileAcceleration parameter to lowAcceleration")
    public void slowProfileDeceleration() {
        this.linearRailMasterController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.lowDeceleration);
        this.linearRailSlaveController.writeParameter(EPOSEnumerations.Parameter.ProfileDeceleration, this.lowDeceleration);
        FCSLOG.info((Object)(this.name + " new ProfileDeceleration=" + this.lowDeceleration));
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
    }

    public StatusDataPublishedByAutoChangerTrucks createStatusDataPublishedByAutoChangerTrucks() {
        StatusDataPublishedByAutoChangerTrucks s = new StatusDataPublishedByAutoChangerTrucks();
        s.setMasterPosition(this.masterPosition);
        s.setSlavePosition(this.slavePosition);
        s.setCurrent(this.current);
        s.setSpeed(this.speed);
        s.setProfileVelocity(this.profileVelocity);
        s.setHomingDone(this.isHomingDone());
        s.setAtHandoff(this.atHandoff);
        s.setAtOnline(this.atOnline);
        s.setAtStandby(this.atStandby);
        s.setInError(this.isPositionSensorsInError());
        return s;
    }

    @Override
    public void publishData() {
        this.s.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)this.createStatusDataPublishedByAutoChangerTrucks()));
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.linearRailMasterController.isBooted() && this.linearRailSlaveController.isBooted()) {
            this.linearRailMasterController.disableOperation();
            this.linearRailSlaveController.disableOperation();
        }
        FCSLOG.info((Object)(this.name + " is shutdown."));
    }
}

