/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.security.SecureRandom;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselMain;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselStandalonePlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;

public class CarouselTest
extends CcsTestCaseTemplate {
    private static Subsystem carouselSubsystem = null;
    private static CarouselMain main;
    private static Carousel carousel;
    private static CarouselClamp clampXminus1;
    private static CarouselClamp clampXplus1;
    private static CarouselClamp clampXminus2;
    private static CarouselClamp clampXplus2;
    private static CarouselClamp clampXminus3;
    private static CarouselClamp clampXplus3;
    private static CarouselClamp clampXminus4;
    private static CarouselClamp clampXplus4;
    private static CarouselClamp clampXminus5;
    private static CarouselClamp clampXplus5;
    private static CarouselClamp[] clampsList;
    private static SimuCarouselController carouselController;
    private final SecureRandom randomGenerator = new SecureRandom();
    private static SimuCarouselStandalonePlutoGateway plutoGateway;
    private static SimuTTC580 hyttc580;
    private static FilterManager filterManager;
    private static CanOpenProxy tcpProxy;
    private static ComponentLookup lookup;
    private static Filter filterU;
    private static Filter filterG;
    private static Filter filterR;
    private static Filter filterI;
    private static Filter filterZ;
    private static final String FILTER_U_NAME = "filterU";
    private static final String FILTER_G_NAME = "filterG";
    private static final String FILTER_R_NAME = "filterR";
    private static final String FILTER_I_NAME = "filterI";
    private static final String FILTER_Z_NAME = "filterZ";
    private static int LOCKA;
    private static int LOCKB;
    private static int LOCKC;
    private static int FILTERPRESENCEA;
    private static int FILTERPRESENCEB;
    private static int FILTERPRESENCEC;
    private static int socket1StandbyPos;
    private static CarouselSocket socket1;

    public CarouselTest() {
        socket1StandbyPos = carousel.getSocketByName("socket1").getStandbyPosition();
    }

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("********************************************************************************");
        System.out.println("                   TESTS OF CAROUSEL IN STANDALONE MODE");
        System.out.println("********************************************************************************");
        CCS.initializeScriptingEnvironment();
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        props.setProperty("org.lsst.ccs.run.mode", "simulation");
        carouselSubsystem = BootUtils.getSubsystemFromFile((String)"carousel__hardware", (String)"");
        carouselSubsystem.startAgent();
        ((AgentStateService)carouselSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        lookup = carouselSubsystem.getComponentLookup();
        main = (CarouselMain)lookup.getComponentByName("main");
        carousel = (Carousel)lookup.getComponentByName("carousel");
        carouselController = (SimuCarouselController)lookup.getComponentByName("carouselController");
        Assert.assertTrue((String)"carousel hardware is ready", (boolean)carousel.myDevicesReady());
        carouselController.initializeAndCheckHardware();
        Assert.assertTrue((String)"carouselController is initialized", (boolean)carouselController.isInitialized());
        carousel.homing();
        Assert.assertTrue((String)"carousel homing is done", (boolean)carousel.isHomingDone());
        plutoGateway = (SimuCarouselStandalonePlutoGateway)lookup.getComponentByName("fakePlutoGateway");
        hyttc580 = (SimuTTC580)lookup.getComponentByName("hyttc580");
        tcpProxy = (CanOpenProxy)lookup.getComponentByName("tcpProxy");
        filterManager = (FilterManager)lookup.getComponentByName("filterManager");
        filterManager.init();
        filterU = (Filter)filterManager.getFiltersMapByName().get(FILTER_U_NAME);
        filterG = (Filter)filterManager.getFiltersMapByName().get(FILTER_G_NAME);
        filterR = (Filter)filterManager.getFiltersMapByName().get(FILTER_R_NAME);
        filterI = (Filter)filterManager.getFiltersMapByName().get(FILTER_I_NAME);
        filterZ = (Filter)filterManager.getFiltersMapByName().get(FILTER_Z_NAME);
        clampXminus1 = (CarouselClamp)lookup.getComponentByName("clampXminus1");
        clampXplus1 = (CarouselClamp)lookup.getComponentByName("clampXplus1");
        clampXminus2 = (CarouselClamp)lookup.getComponentByName("clampXminus2");
        clampXplus2 = (CarouselClamp)lookup.getComponentByName("clampXplus2");
        clampXminus3 = (CarouselClamp)lookup.getComponentByName("clampXminus3");
        clampXplus3 = (CarouselClamp)lookup.getComponentByName("clampXplus3");
        clampXminus4 = (CarouselClamp)lookup.getComponentByName("clampXminus4");
        clampXplus4 = (CarouselClamp)lookup.getComponentByName("clampXplus4");
        clampXminus5 = (CarouselClamp)lookup.getComponentByName("clampXminus5");
        clampXplus5 = (CarouselClamp)lookup.getComponentByName("clampXplus5");
        for (CarouselClamp clamp : clampsList = new CarouselClamp[]{clampXminus1, clampXplus1, clampXminus2, clampXplus2, clampXminus3, clampXplus3, clampXminus4, clampXplus4, clampXminus5, clampXplus5}) {
            clamp.setLockSensorValueA(Integer.valueOf(LOCKA));
            clamp.setLockSensorValueB(Integer.valueOf(LOCKB));
            clamp.setLockSensorMaxValue(Integer.valueOf(LOCKC));
            clamp.setFilterPresenceMinValue(Integer.valueOf(FILTERPRESENCEA));
            clamp.setFilterPresenceValueA(Integer.valueOf(FILTERPRESENCEB));
            clamp.setFilterPresenceValueB(Integer.valueOf(FILTERPRESENCEC));
        }
        socket1 = (CarouselSocket)lookup.getComponentByName("socket1");
    }

    private static void initializeSimulation() throws DriverException {
        hyttc580.initializeAndCheckHardware();
        System.out.println("socket1 initialization");
        hyttc580.simulateSocketAtStandby((short)1);
        hyttc580.simulateSlaveStatus((short)1);
        hyttc580.simulateClampIsLocked(clampXminus1);
        hyttc580.simulateClampIsLocked(clampXplus1);
        hyttc580.simulateClampFilterIsLockable(clampXminus1);
        hyttc580.simulateClampFilterIsLockable(clampXplus1);
        System.out.println("socket2 initialization");
        hyttc580.simulateSocketNotAtStandby((short)2);
        hyttc580.simulateSlaveStatusNotAtS((short)2);
        hyttc580.simulateClampIsLockedNotAtS(clampXminus2);
        hyttc580.simulateClampIsLockedNotAtS(clampXplus2);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXminus2);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXplus2);
        System.out.println("hyttc580:" + hyttc580);
        tcpProxy.updatePDOData();
        clampXminus1.updateState();
        clampXplus1.updateState();
        clampXminus2.updateState();
        clampXplus2.updateState();
        socket1.updateState();
        carousel.updateState();
        System.out.println("socket3 initialization");
        hyttc580.simulateSocketNotAtStandby((short)3);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXminus3);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXplus3);
        System.out.println("hyttc580:" + hyttc580);
        tcpProxy.updatePDOData();
        clampXminus3.updateState();
        clampXplus3.updateState();
        System.out.println("socket4 initialization");
        hyttc580.simulateSocketNotAtStandby((short)4);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXminus4);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXplus4);
        tcpProxy.updatePDOData();
        clampXminus4.updateState();
        clampXplus4.updateState();
        System.out.println("socket5 initialization");
        hyttc580.simulateSocketNotAtStandby((short)5);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXminus5);
        hyttc580.simulateClampFilterIsLockableNotAtS(clampXplus5);
        System.out.println("hyttc580:" + hyttc580);
        tcpProxy.updatePDOData();
        clampXminus5.updateState();
        clampXplus5.updateState();
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("*******************************************************************");
        System.out.println("********* end of TESTS OF CAROUSEL IN STANDALONE MODE *************");
        System.out.println("*******************************************************************");
        carouselSubsystem.shutdownAgent();
        ((AgentStateService)carouselSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Before
    public void setUp() throws FcsHardwareException, DriverException {
        System.out.println("################################################");
        System.out.println("###            CarouselTest                  ###");
        System.out.println("###  Go back to initial conditions:          ###");
        System.out.println("###   socket1 at STANDBY                     ###");
        System.out.println("###   carousel holding a filter at STANDBY   ###");
        System.out.println("###   socket at STANDBY CLAMPEDONFILTER      ###");
        System.out.println("################################################");
        carouselSubsystem.getAlertService().clearAllAlerts();
        carouselController.setSsiPosition(socket1StandbyPos);
        carousel.updatePosition();
        Assert.assertEquals((String)"carousel position is socket1 STANDBY position", (long)socket1StandbyPos, (long)carousel.getPosition());
        CarouselTest.initializeSimulation();
        Assert.assertEquals((String)"socket in STANDBY is socket1", (Object)"socket1", (Object)carousel.getSocketAtStandby().getName());
        Assert.assertEquals((String)"socket at standby ID", (long)1L, (long)carousel.getSocketAtStandby().getId());
        Assert.assertTrue((String)"clampXminus1 is LOCKED", (boolean)clampXminus1.isLocked());
        Assert.assertTrue((String)"clampXplus1 is LOCKED", (boolean)clampXplus1.isLocked());
        Assert.assertTrue((String)"clampXminus1 is LOCKABLE", (boolean)clampXminus1.isFilterEngaged());
        Assert.assertTrue((String)"clampXplus1 is LOCKABLE", (boolean)clampXplus1.isFilterEngaged());
        Assert.assertEquals((String)"clampXminus1 clampState", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)clampXminus1.getClampState());
        Assert.assertEquals((String)"clampXplus1 clampState", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)clampXplus1.getClampState());
        CarouselSocket socketAtStandby = carousel.getSocketAtStandby();
        hyttc580.simulateSlaveStatus((short)1);
        tcpProxy.updatePDOData();
        carousel.updateStateWithSensors();
        socketAtStandby.updateState();
        Assert.assertEquals((String)"socket at STANDBY slave status", (Object)FcsEnumerations.SlaveModuleStatus.IS_SOCKET_AT_STANDBY, (Object)socketAtStandby.getSlaveModuleStatus());
        Assert.assertEquals((String)"socket at STANDBY state", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)socketAtStandby.getClampsState());
        Assert.assertTrue((String)"carousel is holding a filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        Assert.assertTrue((String)"Socket at STANDBY is LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testClamps() throws FcsHardwareException, DriverException {
        System.out.println("*** test of clamps state ***");
        for (int i = 1; i <= 5; ++i) {
            String clampXminusName = "clampXminus" + i;
            System.out.println("Checking ClampState for " + clampXminusName);
            CarouselClamp clampXminus = (CarouselClamp)lookup.getComponentByName(clampXminusName);
            Assert.assertTrue((String)(clampXminusName + " contains a filter."), (boolean)clampXminus.isFilterEngaged());
            Assert.assertTrue((String)(clampXminusName + " is LOCKED."), (boolean)clampXminus.isLocked());
            String clampXplusName = "clampXplus" + i;
            System.out.println("Checking ClampState for " + clampXplusName);
            CarouselClamp clampXplus = (CarouselClamp)lookup.getComponentByName(clampXplusName);
            Assert.assertTrue((String)(clampXplusName + " contains a filter."), (boolean)clampXplus.isFilterEngaged());
            Assert.assertTrue((String)(clampXplusName + " is LOCKED."), (boolean)clampXplus.isLocked());
        }
        System.out.println("Test clamps state is in UNDEFINED state");
        hyttc580.simulateClampIsUnlocked(carousel.getSocketAtStandby().getClampXminus());
        carousel.updateStateWithSensors();
        FcsEnumerations.FilterClampState state = FcsEnumerations.FilterClampState.UNDEFINED;
        Assert.assertEquals((String)"Socket At STANDBY clampsState", (Object)state, (Object)carousel.getSocketAtStandby().getClampsState());
        System.out.println("Test unLockClamps when a filter is not clamped at standby");
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXminus());
        tcpProxy.updatePDOData();
        carousel.getSocketAtStandby().getClampXminus().updateLockStatus();
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXplus());
        tcpProxy.updatePDOData();
        carousel.getSocketAtStandby().getClampXplus().updateLockStatus();
        carousel.updateStateWithSensors();
        state = FcsEnumerations.FilterClampState.CLAMPEDONFILTER;
        Assert.assertEquals((String)"Clamps at STANDBY is not ClampedOnFilter.", (Object)state, (Object)carousel.getSocketAtStandby().getClampsState());
        try {
            carousel.unlockClamps();
            Assert.fail((String)"Clamps at STANDBY are not ClampedOnFilter. unlockClamps should raise an Exception.");
        }
        catch (FailedCommandException | RejectedCommandException ex) {
            System.out.println("Clamps at STANDBY are not ClampedOnFilter. Raised exception=" + ex);
        }
        System.out.println("Go back to initial conditions");
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXminus());
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXplus());
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    public void testClampSensors() throws DriverException {
        System.out.println("*** testClampSensors ***");
        try {
            carousel.unlockClamps();
            Assert.fail((String)"Filter is not held by fakeAutochanger. unlockClamps should raise an Exception.");
        }
        catch (FailedCommandException | RejectedCommandException ex) {
            System.out.println("Filter is not held by fakeAutochanger. Raised exception=" + ex);
        }
        plutoGateway.simulateAutochangerIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"carousel is still holding filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        Assert.assertTrue((String)"filter is also held by autochanger", (boolean)carousel.isAutochangerHoldingFilter());
        carousel.unlockClamps();
        Assert.assertEquals((String)"socket at STANDBY is ", (Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER, (Object)carousel.getSocketAtStandby().getClampsState());
        for (int i = 2; i < 5; ++i) {
            String socketName = "socket" + i;
            Assert.assertEquals((String)"sockets else than socket1 are CLAMPEDONFILTER", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketByName(socketName).getClampsState());
        }
        System.out.println("Go back to initial conditions");
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXminus());
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXplus());
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testIsHoldingFilter() throws FcsHardwareException, DriverException {
        System.out.println("*** test of isHoldingFilterAtStandby ***");
        hyttc580.simulateClampIsUnlocked(carousel.getSocketAtStandby().getClampXminus());
        hyttc580.simulateClampIsUnlocked(carousel.getSocketAtStandby().getClampXplus());
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"carousel is NOT holding a filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        System.out.println("Go back to initial conditions");
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXminus());
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXplus());
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testCheckConditionForRotation() throws FcsHardwareException, DriverException {
        System.out.println("*** test of checkConditionsForRotation");
        try {
            carousel.checkConditionsForRotation();
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            Assert.fail((String)("in initial conditions, rotation is allowed. No exception should be raised:" + ex));
        }
        System.out.println("Simulate clamps at STANDBY are UNLOCKED");
        hyttc580.simulateClampIsUnlocked(carousel.getSocketAtStandby().getClampXminus());
        hyttc580.simulateClampIsUnlocked(carousel.getSocketAtStandby().getClampXplus());
        carousel.updateStateWithSensors();
        String msg = "Clamps are UNLOCKED but filter is still there.";
        Assert.assertTrue((String)msg, (boolean)carousel.getSocketAtStandby().isUnclampedOnFilter());
        try {
            carousel.checkConditionsForRotation();
            Assert.fail((String)(msg + " checkConditionsForRotation should raise an Exception."));
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            System.out.println("Carousel can't rotate because " + msg + ex);
        }
        System.out.println("Go back to initial conditions. simulate clamps at STANDBY are LOCKED");
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXminus());
        hyttc580.simulateClampIsLocked(carousel.getSocketAtStandby().getClampXplus());
        carousel.updateStateWithSensors();
    }

    public void testHoming() {
        System.out.println("test homing of class CarouselModule");
        Assert.assertEquals((String)"carousel position is socket1 STANDBY position", (long)socket1StandbyPos, (long)carousel.getPosition());
        carousel.homing();
        carousel.updatePosition();
        Assert.assertEquals((String)"carousel position should not change with homing", (long)socket1StandbyPos, (long)carousel.getPosition());
        Assert.assertTrue((String)"homing is done", (boolean)carousel.isHomingDone());
    }

    public void testRotateSocketToStandby() throws FcsHardwareException {
        System.out.println("TEST rotateSocketToStandby");
        System.out.println("rotateSocketToStandby socket1");
        carousel.rotateSocketToStandby("socket1");
        Assert.assertEquals((String)"socket at STANDBY id", (long)1L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket2");
        carousel.rotateSocketToStandby("socket2");
        Assert.assertEquals((String)"carousel position should be socket2 standbyPosition", (long)carousel.getSocketByName("socket2").getStandbyPosition(), (long)carousel.getPosition());
        Assert.assertEquals((String)"socket at STANDBY id", (long)2L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket4");
        carousel.rotateSocketToStandby("socket4");
        Assert.assertEquals((String)"socket at STANDBY id", (long)4L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket3");
        carousel.rotateSocketToStandby("socket3");
        Assert.assertEquals((String)"socket at STANDBY id", (long)3L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket5");
        carousel.rotateSocketToStandby("socket5");
        Assert.assertEquals((String)"socket at STANDBY id", (long)5L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket1");
        carousel.rotateSocketToStandby("socket1");
        Assert.assertEquals((String)"carousel position", (long)carousel.getSocketByName("socket1").getStandbyPosition(), (long)carousel.getPosition());
        System.out.println("pdo1 = " + Long.toBinaryString(hyttc580.getPdo1()));
        Assert.assertEquals((String)"socket id at standby", (long)1L, (long)hyttc580.getSocketId(hyttc580.getPdo1()));
        carousel.updateSocketAtStandbyState();
        Assert.assertEquals((String)"socket at STANDBY id", (long)1L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket3");
        carousel.rotateSocketToStandby("socket3");
        Assert.assertEquals((String)"socket at STANDBY id", (long)3L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket5");
        carousel.rotateSocketToStandby("socket5");
        Assert.assertEquals((String)"socket at STANDBY id", (long)5L, (long)carousel.getSocketAtStandby().getId());
        System.out.println("rotateSocketToStandby socket1");
        carousel.rotateSocketToStandby("socket1");
        Assert.assertEquals((String)"carousel position", (long)carousel.getSocketByName("socket1").getStandbyPosition(), (long)carousel.getPosition());
        System.out.println("pdo1 = " + Long.toBinaryString(hyttc580.getPdo1()));
        Assert.assertEquals((String)"socket id at standby", (long)1L, (long)hyttc580.getSocketId(hyttc580.getPdo1()));
        carousel.updateSocketAtStandbyState();
        Assert.assertEquals((String)"socket at STANDBY id", (long)1L, (long)carousel.getSocketAtStandby().getId());
    }

    public void testRotateSocketToStandbyWithRandomGenerator() throws FcsHardwareException {
        System.out.println("rotateSocketToStandby with randomGenerator");
        for (int i = 0; i < 10; ++i) {
            int socketNumber = this.randomGenerator.nextInt(5);
            String socketName = "socket" + socketNumber;
            System.out.println("rotateSocketToStandby(" + socketName + ")");
            if (socketNumber == 0) {
                try {
                    carousel.rotateSocketToStandby(socketName);
                    Assert.fail((String)"socket0 is an invalid socket name. Should raise an exception of type IllegalArgumentException");
                }
                catch (IllegalArgumentException ex) {
                    System.out.println("socket0 is an invalid socket name. Exception raised:" + ex);
                }
                continue;
            }
            carousel.rotateSocketToStandby(socketName);
            Assert.assertEquals((String)"socket at STANDBY id", (long)socketNumber, (long)carousel.getSocketAtStandby().getId());
        }
    }

    @Test
    public void testRotateEmptySocketAtStandby() {
        System.out.println("rotateEmptySocketAtStandby");
        try {
            carousel.rotateEmptySocketAtStandby();
        }
        catch (FailedCommandException | FcsHardwareException | RejectedCommandException ex) {
            Assert.fail((String)("rotateEmptySocketAtStandby should do nothing but not raised an Exception:" + ex));
        }
    }

    @Test
    public void testComputeNewPosition() {
        System.out.println("###computeNewPosition");
        int pos = -43;
        Assert.assertEquals((String)("new position is " + pos), (long)pos, (long)carousel.computeNewPosition(pos));
        int compteur = 10;
        for (int n = 0; n < compteur; ++n) {
            pos = carousel.getEncoderSign() * this.randomGenerator.nextInt(carousel.getStepNB());
            Assert.assertEquals((String)("new position is " + pos), (long)pos, (long)carousel.computeNewPosition(pos));
        }
        pos = carousel.getStepNB();
        Assert.assertEquals((String)"new position is 0", (long)0L, (long)carousel.computeNewPosition(pos));
        pos = carousel.getEncoderSign() * (carousel.getStepNB() + 50);
        int newPos = carousel.getEncoderSign() * 50;
        Assert.assertEquals((String)("new position is " + newPos), (long)newPos, (long)carousel.computeNewPosition(pos));
    }

    @Test
    public void testComputeShortestRelativePosition() {
        System.out.println("###computeShortestRelativePosition");
        int d = (carousel.getStepNB() / 2 - 10) * carousel.getEncoderSign();
        Assert.assertEquals((String)"d is the shortestWay", (long)d, (long)carousel.computeShortestRelativePosition(d));
        d = (carousel.getStepNB() / 2 + 10) * carousel.getEncoderSign();
        int shortWay = 2181110;
        Assert.assertEquals((String)"d is the shortestWay", (long)shortWay, (long)carousel.computeShortestRelativePosition(d));
    }

    @Test
    public void testUpdatePosition() {
        System.out.println("test of updatePosition");
        int pos = this.randomGenerator.nextInt(Math.abs(carousel.getStepNB()));
        carouselController.setSsiPosition(pos);
        Assert.assertEquals((String)("carouselController position is " + pos), (long)pos, (long)carouselController.readPosition());
        carousel.updatePosition();
        Assert.assertEquals((String)("carousel position is " + pos), (long)pos, (long)carousel.getPosition());
    }

    @Test
    public void testWriteTargetPosition() throws FcsHardwareException {
        System.out.println("test of SimuCarouselController");
        int pos = this.randomGenerator.nextInt(Math.abs(carousel.getStepNB())) * carousel.getEncoderSign();
        System.out.println("testCarouselController: rotate to position " + pos);
        int initialPosition = carousel.getPosition();
        int finalPosition = carousel.getPosition() + pos;
        carouselController.writeTargetPosition(pos);
        carousel.updatePosition();
        Assert.assertEquals((String)("test with pos=" + pos + " and initialPosition=" + initialPosition + " carousel position is " + finalPosition), (long)finalPosition, (long)carousel.getPosition());
    }

    public void launchScript() throws Exception {
        System.out.println("************************************************");
        System.out.println("*** Launch Python SCRIPT carouselTest.py ***");
        System.out.println("************************************************");
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/carouselTest.py", (String[])new String[0]);
    }

    static {
        LOCKA = 1000;
        LOCKB = 2000;
        LOCKC = 3000;
        FILTERPRESENCEA = 500;
        FILTERPRESENCEB = 1500;
        FILTERPRESENCEC = 2500;
    }
}

