
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;

/**
 * This class is for the Single Filter Test carousel. 
 * The carousel in Single Filter Test has only one socket and doesn't rotate.
 *
 * @author virieux
 */
public class SftCarousel extends Carousel {
    
    @Override
    public CarouselSocket getSocketAtStandby() {
        return getSocketByName("socket1");
    }

    @Override
    public int getPosition() {
        return 0;
    }
    
    /**
     * Executed during Initialization phase by the framework.
     */
    @Override
    public void postStart() {
        if (this.ai814.isBooted()) {
            this.ai814.initializeAndCheckHardware();

        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "ai814 not booted", ai814.getName());
        }
    }

    @Override
    public boolean isRotating() {
        return false;
    }
    
    /**
     * Read the clamps state from PDO : all the clamp sensors are read at one
     * time.
     *
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    @Override
    public void updateClampsStateWithSensorsFromPDO() {

        this.tcpProxy.updatePDOData();
        PDOData pdoStore = tcpProxy.getPDOData();
        
        FCSLOG.finest(name + ":pdoStore=" + pdoStore.toString());
        socketsMap.values().stream().forEach((socket) -> {
            socket.updateState();
        });
    }  
    
    /**
     * Read the clamps state from PDO : all the clamp sensors are read at one
     * time. Tested with success on single-filter-test in April 2013
     *
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1,
            description = "Read sensors and update state")
    @Override
    public void updateStateWithSensors() {
        updateClampsStateWithSensorsFromPDO();
    }

    /**
     * Carousel can't rotate in single-filter-test
     * @param angle
     * @return 
     */
    public String rotate(float angle) {
        throw new UnsupportedOperationException("Operation rotate not available in Single Filter Test");
    }
}
