
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This represents the motor that moves an autochanger truck along its rail in
 * the single-filter-test test bench.
 *
 * @author virieux
 */
public class CanOpenTruckMotor extends SftTruckMotor {

    /**
     * The Digital Input-output which controls the motor.
     */
    private final CompactIO dio;

    /**
     * Number of the output on the DIO8 where the motor is plugged
     * Used only to be printed.
     */
    @ConfigurationParameter(range="0..7",
            description="The numero of the output of DIO where we send a current for the trucks to go to standby")
    private final int outputNumeroToStandby;
    
    /**
     * Number of the output on the DIO8 where the motor is plugged
     * Used only to be printed.
     */
    @ConfigurationParameter(range="0..7",
            description="The numero of the output of DIO where we send a current for the trucks to go to standback")
    private final int outputNumeroToStandback;
    
    /**
     * Creates a CanOpenTruckMotor with a tickMillis value.
     * 
     * @param dio
     * @param outputNumeroToStandby
     * @param outputNumeroToStandback 
     */
    public CanOpenTruckMotor(
            CompactIO dio, int outputNumeroToStandby, int outputNumeroToStandback) {
        this.dio = dio;
        this.outputNumeroToStandby = outputNumeroToStandby;
        this.outputNumeroToStandback = outputNumeroToStandback;
    }
    
    /**
     * Move SFT autochanger trucks to STANDBACK position.
     * @throws FcsHardwareException 
     */
    @Override
    public void moveToStandback()  {
        this.setMovingToStandback(true);
        dio.getTcpProxy().writeSDO(dio.getNodeID(), 0x6200, 1, 1, 1);
    }

    /**
     * Move SFT autochanger trucks to STANDBY position.
     * @throws FcsHardwareException 
     */
    @Override
    public void moveToStandby()  {
        this.setMovingToStandby(true);
        dio.getTcpProxy().writeSDO(dio.getNodeID(), 0x6200, 1, 1, 2);
    }

    @Override
    public void off()  {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
        dio.getTcpProxy().writeSDO(dio.getNodeID(), 0x6200, 1, 1, 0);
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\noutputNumeroToStandby=");
        sb.append(outputNumeroToStandby);
        sb.append("\noutputNumeroToStandback=");
        sb.append(outputNumeroToStandback);
        return sb.toString();
    }

}
