
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.drivers.commons.DriverException;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FcsAlert;

/**
 * A class for Loader when it's in whole Exchange System.
 * Hardware can be missing. Loader can be connected and disconnected.
 * @author virieux
 */
public class LoaderCanOpenProxy extends CanOpenProxy {

    public LoaderCanOpenProxy(long hardwareBootTimeout) {
        super(hardwareBootTimeout);
    }
    
    @Override
    public void start() {
        //nothing to be started automatically.
    }
    
    @Override
    public void postStart() {
        //nothing to be started automatically.
    }
    
    @Override
    public void connectToCANbus() {
        FCSLOG.info(name + " connecting to CANbus. " + this.toString());
        
        try {
            canInterface.init(master, baud, busName, masterNodeID); // for JNI
            canbusConnected = true;
            
        } catch (DriverException ex) {
            String msg = name + " could not init canInterface. " + this.toString();
            this.raiseAlarm(FcsAlert.HARDWARE_ERROR, msg, ex);
        }
        
        try {
            canInterface.scan();
            Thread.sleep(hardwareBootTimeout);
            
        } catch (DriverException | InterruptedException ex) {
            this.raiseAlarm(FcsAlert.HARDWARE_ERROR, name + " could not scan CANbus." + this.toString(), ex);
        }
    }
}
