package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerWithBrake;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

/**
 * This class is the driver for the EPOS controller which controls the
 * Autochanger ONLINE clamps. 
 *
 *
 * @author virieux
 */
public class CanOpenEPOSOnlineClamp extends CanOpenEPOS implements EPOSControllerWithBrake {

    /**
     * build a new CanOpenEPOS70
     *
     * @param nodeID
     * @param serialNB
     */
    public CanOpenEPOSOnlineClamp(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }



    /**
     * Release brake to be able to open or close clamp. 
     * Only for tests for end users.
     *
     * releaseBrake for an ONlineClamp controller consists in forcing to ZERO
     * bit 15 of parameter DigitalOutputFonctionnalityState.
     *
     * @throws org.lsst.ccs.subsystems.fcs.errors.SDORequestException
     */
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1,
            description = "Release brake to be able to move clamp.")
    public void releaseBrake() {
        //If the controller is not enabled and we release brakes it could lead to a 
        //lost of a filter.
        if (!isEnabled()) {
            throw new RejectedCommandException(name + " can't releaseBrake if not enabled.");
        }
        doReleaseBrake();
    }

    @Override
    public void activateBrakeAndDisable() {
        activateBrake();
        disableOperation();
    }
    
    @Override
    public void shutdown() {
        if (isBooted()) {
            activateBrakeAndDisable();
        }
    }
    
}
