
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * The autochanger module for the whole Filter Exchange System or the fake autochanger module 
 * implements this interface.
 * In the case of the whole Filter Exchange System, when there is a carousel, an
 * autochanger and a loader, the sensors of the autochanger latches tell us if
 * the filter is held by autochanger or not.
 * When carousel or loader are in standalone mode, there is no autochanger hardware.
 * But sometimes we want to test that the hardware as if the autochanger was holding 
 * a filter. This is done usualy with a numeric switch and a sensor that can be read 
 * to know the value of the switch. 
 * 
 * @author virieux
 */
public interface FilterHolder {
    
    /**
     * Return true if the FilterHolder is holding a filter, false otherwise.
     * Example : latches CLOSED on filter (AF3=1)
     * @return true if holding filter
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException 
     */
    boolean isHoldingFilter();
    
    /**
     * Return true if FilterHolder is NOT holding filter, false otherwise.
     * Example : latches OPENED (AF0=1)
     * It can't be just !isHoldingFilter() because hardware can be in an intermediate state.
     * For example, when opening or closing autochanger latches, latches go in state IN_TRAVEL.
     * So we can have state where AF3=0 and AF2=0
     * @return true if NOT holding filter
     */
    boolean isNotHoldingFilter();
    
    /**
     * This method returns true if the autochanger trucks are at HANDOFF position, false otherwise.
     * @return 
     */
    boolean isAtHandoff();
    
    /**
     * This method returns true if the autochanger trucks are at STANDBY position, false otherwise.
     * @return 
     */
    boolean isAtStandby();
    
    /**
     * This method read values sent by the sensors and update state from this new values.
     * @throws FcsHardwareException 
     */
    void updateStateWithSensors();

    int getFilterID();
    
}
