/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FilterIdentificator;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.simulation.AutochangerTruckPositionListener;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLinearRailController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenStrainGauge;
import org.lsst.ccs.subsystems.fcs.simulation.SimuFilterIDPlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGateway;

public class SimuAutochangerPlutoGateway
extends SimuPlutoGateway
implements SimuFilterIDPlutoGatewayInterface {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private FilterIdentificator filterIdentificator;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private FilterHolder carousel;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    private AutochangerTwoTrucks trucks;
    private SimuAutochangerLinearRailController linearRailMasterController;
    private SimuAutochangerLinearRailController linearRailSlaveController;
    private AutochangerOnlineClamp onlineClampXminus;
    private AutochangerOnlineClamp onlineClampXplus;
    private AutochangerOnlineClamp onlineClampYminus;
    private SimuCanOpenStrainGauge onlineStrainGauge;
    private ComplementarySensors loaderConnectedSensors;
    private DigitalSensor lpmLinearRailMasterStatus;
    private DigitalSensor lpmLinearRailSlaveStatus;
    private DigitalSensor lpmOnlineClampsStatus;
    private DigitalSensor lpmLatchesStatus;
    private ComplementarySensors closeSensorsLatchXminus;
    private ComplementarySensors closeSensorsLatchXplus;
    private ComplementarySensors openSensorsLatchXminus;
    private ComplementarySensors openSensorsLatchXplus;
    private ComplementarySensors filterEngagedSensorsLatchXminus;
    private ComplementarySensors filterEngagedSensorsLatchXplus;
    private ComplementarySensors handoffPositionSensorsXminus;
    private ComplementarySensors onlinePositionSensorsXminus;
    private ComplementarySensors standbyPositionSensorsXminus;
    private ComplementarySensors handoffPositionSensorsXplus;
    private ComplementarySensors onlinePositionSensorsXplus;
    private ComplementarySensors standbyPositionSensorsXplus;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Set<AutochangerTruckPositionListener> truckListeners = new HashSet<AutochangerTruckPositionListener>();

    public SimuAutochangerPlutoGateway(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public List<DigitalSensor> getFilterIDSensors() {
        return this.filterIdentificator.getFilterIDSensors();
    }

    @Override
    public void init() {
        super.init();
        ComponentLookup lookup = this.subs.getComponentLookup();
        this.lpmLinearRailMasterStatus = (DigitalSensor)lookup.getComponentByName("lpmLinearRail1Status");
        this.lpmLinearRailSlaveStatus = (DigitalSensor)lookup.getComponentByName("lpmLinearRail2Status");
        this.lpmOnlineClampsStatus = (DigitalSensor)lookup.getComponentByName("lpmOnlineClampsStatus");
        this.lpmLatchesStatus = (DigitalSensor)lookup.getComponentByName("lpmLatchesStatus");
        this.loaderConnectedSensors = (ComplementarySensors)lookup.getComponentByName("loaderConnectedSensors");
        this.linearRailMasterController = (SimuAutochangerLinearRailController)lookup.getComponentByName("linearRailMasterController");
        this.linearRailSlaveController = (SimuAutochangerLinearRailController)lookup.getComponentByName("linearRailSlaveController");
        this.trucks = (AutochangerTwoTrucks)lookup.getComponentByName("autochangerTrucks");
        this.closeSensorsLatchXminus = (ComplementarySensors)lookup.getComponentByName("closeSensorsLatchXminus");
        this.openSensorsLatchXminus = (ComplementarySensors)lookup.getComponentByName("openSensorsLatchXminus");
        this.filterEngagedSensorsLatchXminus = (ComplementarySensors)lookup.getComponentByName("filterEngagedSensorsLatchXminus");
        this.closeSensorsLatchXplus = (ComplementarySensors)lookup.getComponentByName("closeSensorsLatchXplus");
        this.openSensorsLatchXplus = (ComplementarySensors)lookup.getComponentByName("openSensorsLatchXplus");
        this.filterEngagedSensorsLatchXplus = (ComplementarySensors)lookup.getComponentByName("filterEngagedSensorsLatchXplus");
        this.onlineClampXminus = (AutochangerOnlineClamp)lookup.getComponentByName("onlineClampXminus");
        this.onlineClampXplus = (AutochangerOnlineClamp)lookup.getComponentByName("onlineClampXplus");
        this.onlineClampYminus = (AutochangerOnlineClamp)lookup.getComponentByName("onlineClampYminus");
        this.onlineStrainGauge = (SimuCanOpenStrainGauge)lookup.getComponentByName("onlineStrainGauge");
        this.handoffPositionSensorsXminus = (ComplementarySensors)lookup.getComponentByName("handoffPositionSensorsXminus");
        this.handoffPositionSensorsXplus = (ComplementarySensors)lookup.getComponentByName("handoffPositionSensorsXplus");
        this.onlinePositionSensorsXminus = (ComplementarySensors)lookup.getComponentByName("onlinePositionSensorsXminus");
        this.onlinePositionSensorsXplus = (ComplementarySensors)lookup.getComponentByName("onlinePositionSensorsXplus");
        this.standbyPositionSensorsXminus = (ComplementarySensors)lookup.getComponentByName("standbyPositionSensorsXminus");
        this.standbyPositionSensorsXplus = (ComplementarySensors)lookup.getComponentByName("standbyPositionSensorsXplus");
    }

    protected void simuLPMStatusOn() {
        this.replaceSensorValue(this.lpmLinearRailMasterStatus, true);
        this.replaceSensorValue(this.lpmLinearRailSlaveStatus, true);
        this.replaceSensorValue(this.lpmOnlineClampsStatus, true);
        this.replaceSensorValue(this.lpmLatchesStatus, true);
    }

    protected void simuComplementarySensorsOn(ComplementarySensors sensors) {
        this.replaceSensorValue(sensors.getSensor(), true);
        this.replaceSensorValue(sensors.getSensorC(), false);
    }

    protected void simuComplementarySensorsNotOn(ComplementarySensors sensors) {
        this.replaceSensorValue(sensors.getSensor(), false);
        this.replaceSensorValue(sensors.getSensorC(), true);
    }

    protected void simuComplementarySensorsInError(ComplementarySensors sensors) {
        this.replaceSensorValue(sensors.getSensor(), true);
        this.replaceSensorValue(sensors.getSensorC(), true);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksAreAtHandoff() {
        ComplementarySensors[] sensors;
        FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksAreAtHandoff");
        this.simuComplementarySensorsOn(this.handoffPositionSensorsXminus);
        this.simuComplementarySensorsOn(this.handoffPositionSensorsXplus);
        for (ComplementarySensors coupleSensors : sensors = new ComplementarySensors[]{this.standbyPositionSensorsXminus, this.standbyPositionSensorsXplus, this.onlinePositionSensorsXminus, this.onlinePositionSensorsXplus}) {
            this.simuComplementarySensorsNotOn(coupleSensors);
        }
        this.setTrucksPosition(this.trucks.getHandoffPosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksAreOnline() {
        ComplementarySensors[] sensors;
        FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksAreOnline");
        this.simuComplementarySensorsOn(this.onlinePositionSensorsXminus);
        this.simuComplementarySensorsOn(this.onlinePositionSensorsXplus);
        for (ComplementarySensors coupleSensors : sensors = new ComplementarySensors[]{this.standbyPositionSensorsXminus, this.standbyPositionSensorsXplus, this.handoffPositionSensorsXminus, this.handoffPositionSensorsXplus}) {
            this.simuComplementarySensorsNotOn(coupleSensors);
        }
        this.setTrucksPosition(this.trucks.getOnlinePosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksAreAtStandby() {
        ComplementarySensors[] sensors;
        FCSCst.FCSLOG.info((Object)"simulateAutochangerTrucksAreAtStandby");
        this.simuComplementarySensorsOn(this.standbyPositionSensorsXminus);
        this.simuComplementarySensorsOn(this.standbyPositionSensorsXplus);
        for (ComplementarySensors coupleSensors : sensors = new ComplementarySensors[]{this.onlinePositionSensorsXminus, this.onlinePositionSensorsXplus, this.handoffPositionSensorsXminus, this.handoffPositionSensorsXplus}) {
            this.simuComplementarySensorsNotOn(coupleSensors);
        }
        this.setTrucksPosition(this.trucks.getStandbyPosition());
        this.simulateFilterIDAtStandby();
        FCSCst.FCSLOG.info((Object)"end of simulateAutochangerTrucksAreAtStandby");
    }

    private void setTrucksPosition(int pos) {
        this.linearRailMasterController.setPosition(pos);
        this.linearRailMasterController.setSsiPosition(this.linearRailMasterController.getEncoderRibbonMinValue() + pos);
        this.linearRailSlaveController.setPosition(pos);
        this.linearRailSlaveController.setSsiPosition(this.linearRailSlaveController.getEncoderRibbonMinValue() + pos);
        for (AutochangerTruckPositionListener l : this.truckListeners) {
            l.onTruckPositionChange(pos);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksAreInTravel() {
        ComplementarySensors[] sensors;
        for (ComplementarySensors coupleSensors : sensors = new ComplementarySensors[]{this.onlinePositionSensorsXminus, this.onlinePositionSensorsXplus, this.handoffPositionSensorsXminus, this.handoffPositionSensorsXplus, this.standbyPositionSensorsXminus, this.standbyPositionSensorsXplus}) {
            this.simuComplementarySensorsNotOn(coupleSensors);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsConnected() {
        FCSCst.FCSLOG.info((Object)(this.name + " simulateLoaderIsConnected"));
        this.simuComplementarySensorsOn(this.loaderConnectedSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsDisconnected() {
        FCSCst.FCSLOG.info((Object)(this.name + " simulateLoaderIsDisconnected"));
        this.simuComplementarySensorsNotOn(this.loaderConnectedSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsOnAutochanger() {
        FCSCst.FCSLOG.info((Object)(this.name + " simulateFilterIsOnAutochanger"));
        this.simuComplementarySensorsOn(this.filterEngagedSensorsLatchXminus);
        this.simuComplementarySensorsOn(this.filterEngagedSensorsLatchXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerIsEmpty() {
        FCSCst.FCSLOG.info((Object)(this.name + " simulateAutochangerIsEmpty"));
        this.simuComplementarySensorsNotOn(this.filterEngagedSensorsLatchXminus);
        this.simuComplementarySensorsNotOn(this.filterEngagedSensorsLatchXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchesAreLocked() {
        FCSCst.FCSLOG.info((Object)(this.name + " simulateAutochangerLatchesAreLocked"));
        this.simuComplementarySensorsOn(this.closeSensorsLatchXminus);
        this.simuComplementarySensorsOn(this.closeSensorsLatchXplus);
        this.simuComplementarySensorsNotOn(this.openSensorsLatchXminus);
        this.simuComplementarySensorsNotOn(this.openSensorsLatchXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchesAreUnlocked() {
        FCSCst.FCSLOG.info((Object)(this.name + " simulateAutochangerLatchesAreUnlocked"));
        this.simuComplementarySensorsNotOn(this.closeSensorsLatchXminus);
        this.simuComplementarySensorsNotOn(this.closeSensorsLatchXplus);
        this.simuComplementarySensorsOn(this.openSensorsLatchXminus);
        this.simuComplementarySensorsOn(this.openSensorsLatchXplus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchIsLocked(String latchName) {
        if (latchName.contains("Xminus")) {
            this.simuComplementarySensorsOn(this.closeSensorsLatchXminus);
            this.simuComplementarySensorsNotOn(this.openSensorsLatchXminus);
        } else if (latchName.contains("Xplus")) {
            this.simuComplementarySensorsOn(this.closeSensorsLatchXplus);
            this.simuComplementarySensorsNotOn(this.openSensorsLatchXplus);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerLatchIsUnlocked(String latchName) {
        if (latchName.contains("Xminus")) {
            this.simuComplementarySensorsNotOn(this.closeSensorsLatchXminus);
            this.simuComplementarySensorsOn(this.openSensorsLatchXminus);
        } else if (latchName.contains("Xplus")) {
            this.simuComplementarySensorsNotOn(this.closeSensorsLatchXplus);
            this.simuComplementarySensorsOn(this.openSensorsLatchXplus);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLatchLockSensorsInError(String latchName) {
        if (latchName.contains("Xminus")) {
            this.simuComplementarySensorsInError(this.closeSensorsLatchXminus);
        } else if (latchName.contains("Xplus")) {
            this.simuComplementarySensorsInError(this.closeSensorsLatchXplus);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreLocked() {
        FCSCst.FCSLOG.info((Object)"simulateAutochangerOnlineClampsAreLocked");
        this.simulateAutochangerOnlineClampIsLocked(this.onlineClampXminus);
        this.simulateAutochangerOnlineClampIsLocked(this.onlineClampXplus);
        this.simulateAutochangerOnlineClampIsLocked(this.onlineClampYminus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreClosed() {
        FCSCst.FCSLOG.info((Object)"simulateAutochangerOnlineClampsAreClosed");
        this.simulateAutochangerOnlineClampIsClosed(this.onlineClampXminus);
        this.simulateAutochangerOnlineClampIsClosed(this.onlineClampXplus);
        this.simulateAutochangerOnlineClampIsClosed(this.onlineClampYminus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampsAreOpened() {
        FCSCst.FCSLOG.info((Object)"simulateAutochangerOnlineClampsAreOpened");
        this.simulateAutochangerOnlineClampIsOpened(this.onlineClampXminus);
        this.simulateAutochangerOnlineClampIsOpened(this.onlineClampXplus);
        this.simulateAutochangerOnlineClampIsOpened(this.onlineClampYminus);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsClosed(AutochangerOnlineClamp clamp) {
        this.simuComplementarySensorsOn(clamp.getCloseSensors());
        this.simuComplementarySensorsNotOn(clamp.getOpenSensors());
        clamp.setSentCurrent(clamp.getFinalCurrentToClose());
        this.simuStrainGaugeClosed();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsLocked(AutochangerOnlineClamp clamp) {
        this.simuComplementarySensorsOn(clamp.getCloseSensors());
        this.simuComplementarySensorsNotOn(clamp.getOpenSensors());
        clamp.setSentCurrent(clamp.getCurrentToClamp());
        this.simuStrainGaugeLocked();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerOnlineClampIsOpened(AutochangerOnlineClamp clamp) {
        this.simuComplementarySensorsOn(clamp.getOpenSensors());
        this.simuComplementarySensorsNotOn(clamp.getCloseSensors());
        clamp.setSentCurrent(clamp.getCurrentToOpen());
        this.simuStrainGaugeOpened();
    }

    private void simuStrainGaugeLocked() {
        this.onlineStrainGauge.setStrain((short)1000);
    }

    private void simuStrainGaugeClosed() {
        this.onlineStrainGauge.setStrain((short)1500);
    }

    private void simuStrainGaugeOpened() {
        this.onlineStrainGauge.setStrain((short)1700);
    }

    private void simulateFilterIDAtStandby() {
        if (this.carousel instanceof Carousel && ((Carousel)this.carousel).isAtStandby()) {
            this.simulateFilterID(((Carousel)this.carousel).getSocketAtStandby().getFilterID());
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIDOnAutochanger(int id) {
        this.simulateFilterIsOnAutochanger();
        this.simulateFilterID(id);
        this.autochanger.setFilterOnTrucksID(id);
    }

    public void postStart() {
        FCSCst.FCSLOG.info((Object)(this.name + " BEGIN postStart"));
        this.simuLPMStatusOn();
        if (this.autochanger.getFilterID() != 0) {
            this.simulateAutochangerTrucksAreOnline();
            this.simulateFilterIsOnAutochanger();
            this.simulateAutochangerLatchesAreLocked();
            this.simulateAutochangerOnlineClampsAreLocked();
        } else {
            this.simulateAutochangerTrucksAreAtHandoff();
            this.simulateAutochangerIsEmpty();
            this.simulateAutochangerLatchesAreUnlocked();
            this.simulateAutochangerOnlineClampsAreOpened();
        }
        FCSCst.FCSLOG.info((Object)(this.name + " END postStart"));
    }
}

