/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public class CompactIO
extends CanOpenDevice {
    public int value = 0;
    private volatile boolean updatingValue = false;
    private final Lock lock = new ReentrantLock();
    private final Condition valueUpdated = this.lock.newCondition();

    public CompactIO(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    public int readNewValue() {
        try {
            this.value = (int)this.tcpProxy.readSDO(this.nodeID, 24576, 1);
        }
        catch (SDORequestException ex) {
            String message = this.name + "=> ERROR IN READING SENSOR:";
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, message, this.name, (Exception)((Object)ex));
        }
        return this.value;
    }

    public int getValue() {
        this.lock.lock();
        try {
            while (this.updatingValue) {
                try {
                    this.valueUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.name + ex.getMessage()));
                }
            }
            int n = this.value;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updateValue() {
        this.lock.lock();
        try {
            this.updatingValue = true;
            this.value = this.readNewValue();
            FCSCst.FCSLOG.debug((Object)(this.name + " VALUE READ=" + this.value));
        }
        finally {
            this.updatingValue = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }

    public void writeDigitalOutput(int outputNB, int value) {
        if (!this.tcpProxy.allDevicesBooted()) {
            String message = String.format("DAC %s / nodeID=%s is NOT BOOTED", this.getName(), this.nodeID);
            FCSCst.FCSLOG.error((Object)message);
            throw new HardwareNotDetectedException("a CanOpenDIO is missing", this.getName(), this.nodeID, this.serialNB);
        }
        if (outputNB < 1 || outputNB > 8) {
            throw new IllegalArgumentException("CAN-CBX-DIO8 : input has to be 1..8");
        }
        this.tcpProxy.writeSDO(this.nodeID, 25088, outputNB, 2, value);
    }

    public void writeMask() {
        this.tcpProxy.writeSDO(this.nodeID, 8784, 1, 1, 3);
    }

    public boolean checkMask() {
        return this.tcpProxy.readSDO(this.nodeID, 24576, 1) == 3L;
    }
}

