/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;

public class SimuEPOSController
extends CanOpenEPOS
implements HasLifecycle {
    protected int targetPosition;
    protected int position = 0;
    protected int ssiPosition;
    protected int targetCurrent;
    protected int actualCurrent;
    private int statusWord = 0;

    public SimuEPOSController(int nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
        this.mode = EPOSEnumerations.EposMode.PROFILE_POSITION;
        this.enabledToPublish = true;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="For simulator only : Update position with a position given as argument.")
    public void setPosition(int actualPosition) {
        this.position = actualPosition;
    }

    @Override
    public boolean isTargetReached() {
        return this.position == this.targetPosition || this.actualCurrent == this.targetCurrent;
    }

    @Override
    public boolean isParametersOK() {
        return true;
    }

    @Override
    public void defineAbsolutePosition(int position) {
        this.position = position;
    }

    @Override
    public void writeParameters(EPOSEnumerations.EposMode mode) {
    }

    @Override
    public void writeParameter(EPOSEnumerations.Parameter param, int value) {
        FCSCst.FCSLOG.debug((Object)(this.name + "writeParameter"));
    }

    @Override
    public void writeTargetPosition(int position) {
        this.position = position;
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) {
    }

    @Override
    public void writeCurrent(int aValue) {
        this.actualCurrent = aValue;
    }

    @Override
    public void stopAction() {
    }

    @Override
    public int readPosition() {
        return this.position;
    }

    @Override
    public int readSSIPosition() {
        return this.ssiPosition;
    }

    @Override
    public int readCurrent() {
        return this.actualCurrent;
    }

    @Override
    public EPOSEnumerations.EposMode readMode() {
        return this.mode;
    }

    @Override
    public int readStatusWord() {
        return this.statusWord;
    }

    @Override
    public void quickStop() {
        FCSCst.FCSLOG.finest((Object)(this.name + " quickStop done."));
    }

    @Override
    public int readNumberOfErrors() {
        return 0;
    }

    @Override
    public int readErrorRegister() {
        return 0;
    }

    @Override
    public int[] readErrorHistory() {
        return new int[0];
    }

    @Override
    public String displayErrorHistory() {
        return "No ERROR";
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the Controller is in fault.")
    public void checkFault() {
    }

    @Override
    public long readProfileVelocity() {
        return 0L;
    }

    @Override
    public String readParameters(EPOSEnumerations.EposMode mode) {
        return this.getName() + ":no parameter to read.";
    }

    @Override
    public void checkParameters(EPOSEnumerations.EposMode aMode) {
    }

    @Override
    public void writeControlWord(int w) {
        FCSCst.FCSLOG.debug((Object)(this.name + " writeControlWord : 0x" + Integer.toHexString(w) + " (in decimal:" + w + ")"));
        this.statusWord = w;
    }

    @Override
    public void switchOnEnableOperation() {
        this.writeControlWord(7);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Enable controller and go to relative position. Doesn't check condition. DANGER !!!! ")
    public void enableAndWriteRelativePosition(int pos) {
        this.enable();
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.writeTargetPosition(this.position + pos);
        this.writeControlWord(127);
    }

    @Override
    public void checkCurrent(int aValue) {
    }

    public void postStart() {
        FCSCst.FCSLOG.info((Object)(this.name + " BEGIN postStart"));
        FCSCst.FCSLOG.info((Object)(this.name + " END postStart"));
    }
}

