/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.common.EPOSControllerForCarousel;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;

public class SimuCarouselController
extends SimuEPOSController
implements EPOSControllerForCarousel {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Carousel carousel;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private SimuTTC580 hyttc580;

    public SimuCarouselController(int nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
    }

    public void setSsiPosition(int ssiPosition) {
        this.ssiPosition = ssiPosition;
        this.position = ssiPosition;
    }

    public void init() {
        this.setSsiPosition(this.carousel.getSocketByName("socket1").getStandbyPosition());
    }

    @Override
    public void enableAndWriteRelativePosition(int pos) {
        this.enable();
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_POSITION);
        this.writeTargetPosition(pos);
        this.writeControlWord(127);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position.")
    public void writeTargetPosition(int relativePosition) throws FcsHardwareException {
        FCSCst.FCSLOG.info((Object)(this.name + "=> carousel is rotating."));
        FCSCst.FCSLOG.info((Object)(this.name + "=> position initiale=" + this.position));
        FCSCst.FCSLOG.info((Object)(this.name + "=> relative target position=" + relativePosition));
        int iterNB = 10;
        int step = relativePosition / iterNB;
        FCSCst.FCSLOG.info((Object)("step=" + step));
        int initialPosition = this.carousel.getPosition();
        try {
            for (int i = 1; i < iterNB; ++i) {
                int newPos = this.carousel.computeNewPosition(initialPosition + i * step);
                this.setSsiPosition(newPos);
                FCSCst.FCSLOG.info((Object)(this.name + " i=" + i + ", position=" + this.position));
                try {
                    Thread.sleep(250L);
                    if (!this.carousel.getHaltRequired().get()) continue;
                    FCSCst.FCSLOG.fine((Object)(this.name + " STOP simulated carousel motion."));
                    return;
                }
                catch (InterruptedException ex) {
                    throw new FcsHardwareException(this.name + " sleep was interrupted.", (Throwable)ex);
                }
            }
            int finalPos = this.carousel.computeNewPosition(initialPosition + relativePosition);
            this.setSsiPosition(finalPos);
            this.carousel.updatePosition();
            this.simulateSocketSensors(finalPos);
        }
        catch (FcsHardwareException ex) {
            FCSCst.FCSLOG.error((Object)(this.name + " should not raise an Exception:"), (Throwable)ex);
        }
    }

    private void simulateSocketSensors(int pos) {
        System.out.println(this.name + " simulateSocketSensors with position = " + pos);
        this.carousel.getSocketsMap().values().stream().forEach(socket -> {
            if (socket.getStandbyPosition() == pos) {
                this.hyttc580.simulateSocketAtStandby((short)socket.getId());
                this.hyttc580.simulateSlaveStatus((short)1);
            } else {
                this.hyttc580.simulateSocketNotAtStandby((short)socket.getId());
                this.hyttc580.simulateSlaveStatusNotAtS((short)2);
            }
            try {
                this.tcpProxy.updatePDOData();
                this.carousel.updateState();
            }
            catch (DriverException ex) {
                FCSCst.FCSLOG.error((Object)(this.name + " error in simulation "), (Throwable)ex);
            }
        });
    }
}

