/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.ComplementarySensors;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.common.ControlledBySensors;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.common.MovedByEPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class AutochangerLatch
extends MobileItem
implements MovedByEPOSController,
ControlledBySensors {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Autochanger autochanger;
    private final EPOSController latchController;
    private final ComplementarySensors filterEngagedSensors;
    private final ComplementarySensors closeSensors;
    private final ComplementarySensors openSensors;
    @ConfigurationParameter(description="in mA current to be sent to the controller to open the latch.")
    private int currentToOpen = 300;
    @ConfigurationParameter(description="current to close Autochanger latch in mA")
    private int currentToClose = -this.currentToOpen;
    @ConfigurationParameter(description="timeout for opening a latch in milliseconds.")
    private long timeoutForOpening = 3000L;
    @ConfigurationParameter(description="timeout for closing a latch in milliseconds.")
    private long timeoutForClosing = 3000L;
    private int readCurrent;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    private volatile boolean initialized;

    public AutochangerLatch(EPOSController latchController, ComplementarySensors closeSensors, ComplementarySensors openSensors, ComplementarySensors filterEngagedSensors) {
        this.latchController = latchController;
        this.closeSensors = closeSensors;
        this.openSensors = openSensors;
        this.filterEngagedSensors = filterEngagedSensors;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns this latch controller name.")
    public String getControllerName() {
        return this.latchController.getName();
    }

    public EPOSController getLatchController() {
        return this.latchController;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if latch is initialized.")
    public boolean isInitialized() {
        return this.initialized;
    }

    public int getCurrentToClose() {
        return this.currentToClose;
    }

    public long getTimeoutForOpening() {
        return this.timeoutForOpening;
    }

    public long getTimeoutForClosing() {
        return this.timeoutForClosing;
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        return this.lockStatus;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=LOCKED. Doesn't read again sensors.", alias="isClosed")
    public boolean isClosed() {
        return this.closeSensors.isOn();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=UNLOCKED. Doesn't read again sensors.", alias="isOpen")
    public boolean isOpened() {
        return this.openSensors.isOn();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if LockStatus=ERROR, this means that openSensor and closeSensor return non consistant values. Doesn't read again sensors.")
    public boolean isInError() {
        return this.lockStatus == FcsEnumerations.LockStatus.ERROR;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if autochanger is empty. Doesn't read again sensors.")
    public boolean isEmpty() {
        return !this.filterEngagedSensors.isOn();
    }

    public void init() {
        if (this.latchController == null) {
            FCSLOG.error((Object)(this.name + "==>>> latchController == null - Please fix groovy description file."));
            throw new IllegalArgumentException(this.name + "==>>> null latchController - fix groovy description file.");
        }
    }

    public void postStart() {
        FCSLOG.fine((Object)(this.name + " BEGIN postStart."));
        if (this.latchController.isBooted()) {
            this.initializeController();
        }
        FCSLOG.fine((Object)(this.name + " END postStart."));
    }

    private void initializeController() {
        try {
            this.latchController.initializeAndCheckHardware();
            this.initialized = true;
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " could not initialize controller", this.latchController.getName(), (Exception)((Object)ex));
        }
        try {
            this.latchController.changeMode(EPOSEnumerations.EposMode.CURRENT);
        }
        catch (FcsHardwareException ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.HARDWARE_ERROR, this.name + " could not change mode of controller", this.latchController.getName(), (Exception)((Object)ex));
        }
    }

    protected void updateState() {
        boolean inError;
        boolean closed = this.closeSensors.isOn();
        boolean opened = this.openSensors.isOn();
        boolean someSensorsInError = this.filterEngagedSensors.isInError() || this.closeSensors.isInError() || this.openSensors.isInError();
        boolean bl = inError = closed && opened || someSensorsInError;
        this.lockStatus = inError ? FcsEnumerations.LockStatus.ERROR : (closed ? FcsEnumerations.LockStatus.CLOSED : (opened ? FcsEnumerations.LockStatus.OPENED : FcsEnumerations.LockStatus.INTRAVEL));
        this.publishData();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Update latch current in reading controller.")
    public void updateCurrent() {
        try {
            this.readCurrent = this.latchController.readCurrent();
            this.publishData();
        }
        catch (Exception ex) {
            this.raiseWarning(FcsEnumerations.FcsAlert.SDO_ERROR, " could not updateCurrent", this.latchController.getName(), ex);
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if autochanger CANopen hardware is connected and ready.")
    public boolean myDevicesReady() {
        return this.autochanger.isCANDevicesReady();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Close latch.")
    public void close() {
        this.updateStateAndCheckSensors();
        if (this.isClosed()) {
            throw new RejectedCommandException(this.name + " is already CLOSED.");
        }
        this.autochanger.checkConditionsForClosingLatches();
        this.executeAction(FcsEnumerations.MobileItemAction.CLOSE, this.timeoutForClosing);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Open latch.")
    public void open() {
        this.updateStateAndCheckSensors();
        if (this.isOpened()) {
            throw new RejectedCommandException(this.name + " is already OPENED.");
        }
        this.autochanger.checkConditionsForOpeningLatches();
        this.executeAction(FcsEnumerations.MobileItemAction.OPEN, this.timeoutForOpening);
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPEN: {
                return this.lockStatus == FcsEnumerations.LockStatus.OPENED;
            }
            case CLOSE: {
                return this.lockStatus == FcsEnumerations.LockStatus.CLOSED;
            }
        }
        assert (false) : action;
        return false;
    }

    public void updateStateAndCheckSensors() {
        this.autochanger.updateStateWithSensors();
        this.checkSensors(FcsEnumerations.FcsAlert.AC_SENSOR_ERROR, this.name);
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.autochanger.updateStateWithSensors();
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) {
        switch (action) {
            case OPEN: {
                this.latchController.enableAndWriteCurrent((short)this.currentToOpen);
                break;
            }
            case CLOSE: {
                this.latchController.enableAndWriteCurrent((short)this.currentToClose);
                break;
            }
            default: {
                assert (false) : action;
                break;
            }
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        FCSLOG.debug((Object)(this.name + " STOPPING action " + action.toString() + " within delay " + delay));
        this.latchController.stopAction();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        this.abortAction(action, delay);
    }

    public StatusDataPublishedByAutochangerLatch createStatusDataPublishedByLatch() {
        StatusDataPublishedByAutochangerLatch status = new StatusDataPublishedByAutochangerLatch();
        status.setLockSensorValue(this.closeSensors.isOn());
        status.setUnlockSensorValue(this.openSensors.isOn());
        status.setFilterPresenceSensorValue(this.filterEngagedSensors.isOn());
        status.setLockStatus(this.lockStatus);
        status.setControllerInFault(this.latchController.isInError());
        status.setLockSensorsInError(this.closeSensors.isInError());
        status.setUnlockSensorsInError(this.openSensors.isInError());
        status.setFilterEngagedSensorsInError(this.filterEngagedSensors.isInError());
        status.setInError(this.lockStatus == FcsEnumerations.LockStatus.ERROR);
        return status;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Publish Data on the Status Bus.")
    public void publishData() {
        StatusDataPublishedByAutochangerLatch status = this.createStatusDataPublishedByLatch();
        this.s.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)status));
    }
}

