/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.LoaderCarrier;
import org.lsst.ccs.subsystems.fcs.LoaderClamp;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderStandalonePlutoGateway;

public class LoaderTest
extends CcsTestCaseTemplate {
    private static ComponentLookup lookup;
    private static Subsystem loaderSubsystem;
    private static LoaderClamp clamp;
    private static LoaderCarrier carrier;
    private static Loader loader;
    private static SimuLoaderStandalonePlutoGateway gateway;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF LOADER IN STANDALONE MODE");
        System.out.println("***************************************");
        CCS.initializeScriptingEnvironment();
        loaderSubsystem = BootUtils.getSubsystemFromFile((String)"loader__simulation");
        loaderSubsystem.startAgent();
        ((AgentStateService)loaderSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        lookup = loaderSubsystem.getComponentLookup();
        clamp = (LoaderClamp)lookup.getComponentByName("clamp");
        carrier = (LoaderCarrier)lookup.getComponentByName("carrier");
        loader = (Loader)lookup.getComponentByName("loader");
        gateway = (SimuLoaderStandalonePlutoGateway)lookup.getComponentByName("loaderPlutoGateway");
    }

    @Before
    public void setUp() {
        gateway.simulateFilterIsOnLoader();
        gateway.simulateLoaderClampIsClosed();
        gateway.simulateLoaderIsConnectedOnCamera();
        loader.updateStateWithSensors();
        loader.getAlertService().clearAllAlerts();
    }

    @Test
    public void testCheckSensors() {
        System.out.println("*** test of checkCheckSensors of class LoaderClampModule ***");
        gateway.simulateClampIsInError();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is in Error", (boolean)clamp.isInError());
        try {
            clamp.checkSensors(FcsEnumerations.FcsAlert.LO_SENSOR_ERROR, "loader");
            Assert.fail((String)"Clamps sensors are in error. An Exception should have been raised.");
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            System.out.println("Clamps sensors are in error. Raised exception:" + ex);
        }
    }

    @Test
    public void testCheckConditionsForCarrierMotion() {
        System.out.println("*** test of checkConditionsForForCarrierMotion ***");
        gateway.simulateLoaderCarrierIsAtHandoff();
        loader.updateStateWithSensors();
        int targetPosition = carrier.getEngagedPosition() + 5;
        loader.checkConditionsForCarrierMotion(targetPosition);
        targetPosition = carrier.getEngagedPosition() - 5;
        try {
            loader.checkConditionsForCarrierMotion(targetPosition);
        }
        catch (RejectedCommandException ex) {
            System.out.println("carrier has to go to ENGAGED first:" + (Object)((Object)ex));
        }
        carrier.goToAbsolutePosition(carrier.getEngagedPosition() + 5);
        carrier.updatePosition();
        Assert.assertTrue((String)"carrier.getPosition() == carrier.getEngagedPosition() + 5", (carrier.getPosition() == carrier.getEngagedPosition() + 5 ? 1 : 0) != 0);
        try {
            loader.checkConditionsForCarrierMotion(carrier.getStoragePosition());
        }
        catch (RejectedCommandException ex) {
            System.out.println("carrier has to be CLAMPED:" + (Object)((Object)ex));
        }
        gateway.simulateLoaderClampIsClamped();
        loader.updateStateWithSensors();
        loader.checkConditionsForCarrierMotion(carrier.getStoragePosition());
        loader.checkConditionsForCarrierMotion(carrier.getEngagedPosition());
        try {
            loader.checkConditionsForCarrierMotion(carrier.getHandoffPosition());
        }
        catch (RejectedCommandException ex) {
            System.out.println("carrier has to be UNCLAMPED:" + (Object)((Object)ex));
        }
        gateway.simulateLoaderClampIsClosed();
        loader.updateStateWithSensors();
        loader.checkConditionsForCarrierMotion(carrier.getHandoffPosition());
        gateway.simulateLoaderCarrierIsAtHandoff();
        gateway.simulateFilterIsOnLoader();
        gateway.simulateLoaderClampIsOpened();
        loader.updateStateWithSensors();
        targetPosition = carrier.getEngagedPosition() + 50;
        loader.checkConditionsForCarrierMotion(targetPosition);
    }

    @Test
    public void testCheckConditionsForOpeningHooks() {
        System.out.println("*** test of checkConditionsForOpeningHooks ***");
        gateway.simulateClampIsInError();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is in Error", (boolean)clamp.isInError());
        try {
            loader.checkConditionsForOpeningHooks();
            Assert.fail((String)"Clamps sensors are in error. Can't open hooks an Exception should have been raised.");
        }
        catch (FcsHardwareException | RejectedCommandException ex) {
            System.out.println("Clamps sensors are in error. Raised exception:" + ex);
        }
    }

    @Test
    public void testCheckConditionsForUnclampingHooks() {
        System.out.println("*** test of checkConditionsForUnclampingHooks ***");
        gateway.simulateLoaderClampIsClamped();
        gateway.simulateLoaderCarrierIsAtEngaged();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is CLAMPED at ENGAGED", (boolean)carrier.isAtEngaged());
        loader.checkConditionsForUnclampingHooks();
        gateway.simulateLoaderClampIsClamped();
        gateway.simulateLoaderCarrierIsAtStorage();
        loader.updateStateWithSensors();
        try {
            loader.checkConditionsForUnclampingHooks();
        }
        catch (RejectedCommandException ex) {
            System.out.println("can't unclamp at STORAGE:" + (Object)((Object)ex));
        }
        gateway.simulateLoaderCarrierIsAtHandoff();
        loader.updateStateWithSensors();
        try {
            loader.checkConditionsForUnclampingHooks();
        }
        catch (RejectedCommandException ex) {
            System.out.println("can't unclamp at HANDOFF:" + (Object)((Object)ex));
        }
    }

    @Test
    public void testCheckConnectedOnCamera() {
        System.out.println("*** checkConnectedOnCamera");
        gateway.simulateLoaderIsConnectedOnCamera();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"loader is connected on camera", (boolean)loader.isConnectedOnCamera());
        loader.checkConnectedOnCamera();
        gateway.simulateLoaderIsNotConnectedOnCamera();
        loader.updateStateWithSensors();
        Assert.assertFalse((String)"loader is NOT connected on camera", (boolean)loader.isConnectedOnCamera());
        try {
            loader.checkConnectedOnCamera();
            Assert.fail((String)"loader is NOT connected on camera");
        }
        catch (Exception ex) {
            System.out.println("loader is not connected on camera. Exception raised=" + ex);
        }
    }

    @Test
    public void testCarrierReadPosition() {
        System.out.println("*** tests of readPosition of class LoaderCarrierModule ***");
        int posInitial = carrier.getPosition();
        Assert.assertEquals((String)"in simulation readPosition should not change position", (long)posInitial, (long)carrier.readPosition());
    }

    @Test
    public void testIsCarrierAtStoragePosition() {
        System.out.println("*** isCarrierAtStoragePosition");
        gateway.simulateLoaderCarrierIsAtStorage();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"Carrier is at STORAGE position", (boolean)loader.getCarrier().isAtStorage());
    }

    @AfterClass
    public static void after() throws Exception {
        loaderSubsystem.shutdownAgent();
        ((AgentStateService)loaderSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 60L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    public void launchScript() throws Exception {
        System.out.println("******************************************************");
        System.out.println("*** Launch Python SCRIPT loaderClampCarrierTest.py ***");
        System.out.println("******************************************************");
        Assert.assertTrue((String)"loaderSubsystem should be in OPERATIONAL phase.", (boolean)loaderSubsystem.isInState((Enum)PhaseState.OPERATIONAL));
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/loaderClampCarrierTest.py", (String[])new String[0]);
    }

    static {
        loaderSubsystem = null;
    }
}

