/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystems.fcs.Autochanger;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.AutochangerTwoTrucks;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsMain;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuTTC580;

public class FcsToto
extends CcsTestCaseTemplate {
    private static Subsystem fcsSubsystem = null;
    private static FcsMain main;
    private static Autochanger autochanger;
    private static AutochangerTwoTrucks trucks;
    private static AutochangerTwoLatches latches;
    private static Carousel carousel;
    private static SimuCarouselController carouselController;
    private static SimuTTC580 ttc580;
    private static SimuAutochangerPlutoGateway acPlutoGateway;
    private static FilterManager filterManager;
    private static Filter filterI;
    private static int socket1StandbyPos;
    private static AutochangerOnlineClamp onlineClampXminus;
    private static AutochangerOnlineClamp onlineClampXplus;
    private static AutochangerOnlineClamp onlineClampYminus;
    private static AutochangerOnlineClamp[] onelineClampsList;
    private static CarouselClamp clampXminus1;
    private static CarouselClamp clampXplus1;
    private static CarouselClamp clampXminus2;
    private static CarouselClamp clampXplus2;
    private static CarouselClamp clampXminus3;
    private static CarouselClamp clampXplus3;
    private static CarouselClamp clampXminus4;
    private static CarouselClamp clampXplus4;
    private static CarouselClamp clampXminus5;
    private static CarouselClamp clampXplus5;
    private static CarouselClamp[] clampsList;
    private static int LOCKA;
    private static int LOCKB;
    private static int LOCKC;
    private static int FILTERPRESENCEA;
    private static int FILTERPRESENCEB;
    private static int FILTERPRESENCEC;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("************************************************************************************");
        System.out.println("***                  TESTS OF THE WHOLE FCS SIMULATED                            ***");
        System.out.println("************************************************************************************");
        fcsSubsystem = BootUtils.getSubsystemFromFile((String)"fcs__simulation", (String)"");
        fcsSubsystem.startAgent();
        ((AgentStateService)fcsSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = fcsSubsystem.getComponentLookup();
        main = (FcsMain)lookup.getComponentByName("main");
        autochanger = (Autochanger)lookup.getComponentByName("autochanger");
        carousel = (Carousel)lookup.getComponentByName("carousel");
        carouselController = (SimuCarouselController)lookup.getComponentByName("carouselController");
        ttc580 = (SimuTTC580)lookup.getComponentByName("hyttc580");
        acPlutoGateway = (SimuAutochangerPlutoGateway)lookup.getComponentByName("acSensorsGateway");
        acPlutoGateway.simulateAutochangerTrucksAreAtHandoff();
        acPlutoGateway.simulateAutochangerOnlineClampsAreOpened();
        autochanger.updateStateWithSensors();
        trucks = (AutochangerTwoTrucks)lookup.getComponentByName("autochangerTrucks");
        trucks.updatePosition();
        latches = (AutochangerTwoLatches)lookup.getComponentByName("latches");
        filterManager = (FilterManager)lookup.getComponentByName("filterManager");
        filterI = filterManager.getFilterByName("filterI");
        onlineClampXminus = (AutochangerOnlineClamp)lookup.getComponentByName("onlineClampXminus");
        onlineClampXplus = (AutochangerOnlineClamp)lookup.getComponentByName("onlineClampXplus");
        onlineClampYminus = (AutochangerOnlineClamp)lookup.getComponentByName("onlineClampYminus");
        for (AutochangerOnlineClamp autochangerOnlineClamp : onelineClampsList = new AutochangerOnlineClamp[]{onlineClampXminus, onlineClampXplus, onlineClampYminus}) {
            autochangerOnlineClamp.setIncrementCurrentToClose(300);
            autochangerOnlineClamp.setIncrementCurrentToOpen(300);
            autochangerOnlineClamp.setIncrementCurrentToClamp(532);
            autochangerOnlineClamp.setInitialCurrentToClose(300);
            autochangerOnlineClamp.setFinalCurrentToClose(1800);
            autochangerOnlineClamp.setCurrentToOpen(-300);
            autochangerOnlineClamp.setCurrentToClamp(4992);
            autochangerOnlineClamp.setMaxTimeToClose(1000);
            autochangerOnlineClamp.setMaxTimeToOpen(1400);
            autochangerOnlineClamp.setMaxTimeToLock(1200);
            autochangerOnlineClamp.setMaxTimeToUnlock(1200);
        }
        clampXminus1 = (CarouselClamp)lookup.getComponentByName("clampXminus1");
        clampXplus1 = (CarouselClamp)lookup.getComponentByName("clampXplus1");
        clampXminus2 = (CarouselClamp)lookup.getComponentByName("clampXminus2");
        clampXplus2 = (CarouselClamp)lookup.getComponentByName("clampXplus2");
        clampXminus3 = (CarouselClamp)lookup.getComponentByName("clampXminus3");
        clampXplus3 = (CarouselClamp)lookup.getComponentByName("clampXplus3");
        clampXminus4 = (CarouselClamp)lookup.getComponentByName("clampXminus4");
        clampXplus4 = (CarouselClamp)lookup.getComponentByName("clampXplus4");
        clampXminus5 = (CarouselClamp)lookup.getComponentByName("clampXminus5");
        clampXplus5 = (CarouselClamp)lookup.getComponentByName("clampXplus5");
        clampsList = new CarouselClamp[]{clampXminus1, clampXplus1, clampXminus2, clampXplus2, clampXminus3, clampXplus3, clampXminus4, clampXplus4, clampXminus5, clampXplus5};
        for (AutochangerOnlineClamp autochangerOnlineClamp : clampsList) {
            autochangerOnlineClamp.setLockSensorValueA(Integer.valueOf(LOCKA));
            autochangerOnlineClamp.setLockSensorValueB(Integer.valueOf(LOCKB));
            autochangerOnlineClamp.setLockSensorMaxValue(Integer.valueOf(LOCKC));
            autochangerOnlineClamp.setFilterPresenceMinValue(Integer.valueOf(FILTERPRESENCEA));
            autochangerOnlineClamp.setFilterPresenceValueA(Integer.valueOf(FILTERPRESENCEB));
            autochangerOnlineClamp.setFilterPresenceValueB(Integer.valueOf(FILTERPRESENCEC));
        }
        Assert.assertTrue((String)"AutochangerTrucks are at HANDOFF", (boolean)trucks.isAtHandoff());
        Assert.assertTrue((String)"Carousel and Autochanger hardware is ready", (boolean)main.isChangerReady());
        Assert.assertTrue((String)"fcsSubsystem.isInState(PhaseState.OPERATIONAL", (boolean)fcsSubsystem.isInState((Enum)PhaseState.OPERATIONAL));
    }

    @Before
    public void setUp() throws DriverException {
        Utils.printJoliSetUp("FcsTest");
        socket1StandbyPos = carousel.getSocketByName("socket1").getStandbyPosition();
        carouselController.initializeAndCheckHardware();
        carouselController.setSsiPosition(socket1StandbyPos);
        carousel.updatePosition();
        Assert.assertEquals((String)("socket1StandbyPos is " + socket1StandbyPos), (long)socket1StandbyPos, (long)carousel.getSocketByName("socket1").getStandbyPosition());
        Assert.assertEquals((String)"carousel position is socket1 STANDBY position", (long)socket1StandbyPos, (long)carousel.getPosition());
        Assert.assertEquals((String)"socket in STANDBY is socket1", (Object)"socket1", (Object)carousel.getSocketAtStandby().getName());
        Assert.assertEquals((String)"socket1 is at STANDBY", (Object)carousel.getSocketAtStandby(), (Object)carousel.getSocketByName("socket1"));
        FcsToto.initializePDOs();
        carousel.updateStateWithSensors();
    }

    private static void initializePDOs() throws DriverException {
        CarouselClamp[] clampsAtStandby;
        CarouselClamp[] clampsNotAtStandby;
        ttc580.setPdo1(0L);
        ttc580.setPdo2(0L);
        for (CarouselClamp clamp : clampsNotAtStandby = new CarouselClamp[]{clampXminus2, clampXplus2, clampXminus3, clampXplus3, clampXminus4, clampXplus4, clampXminus5, clampXplus5}) {
            ttc580.simulateClampIsLockedNotAtS(clamp);
            ttc580.simulateClampFilterIsLockableNotAtS(clamp);
        }
        for (int i = 2; i < 6; ++i) {
            System.out.println("socket" + i + " initialization");
            ttc580.simulateSocketNotAtStandby((short)i);
        }
        System.out.println("socket1 initialization");
        ttc580.simulateSocketAtStandby((short)1);
        for (CarouselClamp clamp : clampsAtStandby = new CarouselClamp[]{clampXminus1, clampXplus1}) {
            ttc580.simulateClampIsLocked(clamp);
            ttc580.simulateClampFilterIsLockable(clamp);
        }
    }

    @Test
    public void testExchangeBetweenCarouselAndAutochanger() throws DriverException {
        System.out.println("*******************************************************");
        System.out.println("*** test Exchange Between Carousel And Autochanger  ***");
        System.out.println("*******************************************************");
        System.out.println(" from carousel to autochanger");
        trucks.goToStandby();
        carousel.updateClampsStateWithSensorsFromPDO();
        autochanger.grabFilterAtStandby();
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((boolean)autochanger.isHoldingFilter());
        int filterID = autochanger.getFilterOnTrucksID();
        Filter filter = filterManager.getFilterByID(filterID);
        carousel.ungrabFilterAtStandby(filter.getName());
        trucks.goToOnline();
        carousel.updateClampsStateWithSensorsFromPDO();
        Assert.assertEquals((String)"socket1 is socketAtStandby", (Object)carousel.getSocketAtStandby(), (Object)carousel.getSocketByName("socket1"));
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        Assert.assertFalse((String)"carousel is no more holding filter at STANDBY", (boolean)carousel.isHoldingFilter());
        Assert.assertFalse((String)"socket2 is NOT at STANDBY", (boolean)carousel.getSocketByName("socket2").isAtStandby());
        Assert.assertEquals((String)"socket2 is CLAMPEDONFILTER", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketByName("socket2").getClampsState());
        Assert.assertEquals((String)"socket1 is UNCLAMPEDEMPTY", (Object)FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY, (Object)carousel.getSocketByName("socket1").getClampsState());
        Assert.assertTrue((String)"Filter is now on Autochanger", (autochanger.getFilterOnTrucksID() != 0 ? 1 : 0) != 0);
        carousel.releaseClamps();
        Assert.assertEquals((String)"clamps at STANDBY are READYTOCLAMP", (Object)FcsEnumerations.FilterClampState.READYTOCLAMP, (Object)carousel.getSocketAtStandby().getClampsState());
        System.out.println(" from autochanger to carousel");
        trucks.goToStandby();
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        carousel.grabFilterAtStandby(filterManager.getFilterByID(filterID));
        Assert.assertTrue((String)"carousel is holding filter at STANDBY", (boolean)carousel.isHoldingFilter());
        Assert.assertEquals((String)"socket1 is now CLAMPEDONFILTER", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketByName("socket1").getClampsState());
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        latches.open();
        trucks.goToHandOff();
        Assert.assertTrue((String)"Autochanger is now empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"Autochanger is at HANDOFF", (boolean)autochanger.getAutochangerTrucks().isAtHandoff());
        Assert.assertTrue((String)"Filter is now on Carousel", (boolean)carousel.isFilterOnCarousel(filterID));
    }

    @Test
    public void testSetFilter() {
        System.out.println("**********************************");
        System.out.println("***       testSetFilter        ***");
        System.out.println("**********************************");
        System.out.println("********  setFilter(filterU)  *********************");
        String filterName = "filterU";
        System.out.println("Filter List:" + filterManager.getFiltersMapByName());
        main.setFilter(filterName.substring(6, filterName.length()));
        Assert.assertEquals((String)("Now filter at ONLINE is " + filterName), (Object)filterName, (Object)main.getOnlineFilterName());
        Assert.assertTrue((String)"Carousel is ready to grab a filter at STANDBY", (boolean)carousel.isReadyToGrabAFilterAtStandby());
        System.out.println("********  setFilter(filterT)  *********************");
        filterName = "filterT";
        try {
            main.setFilter(filterName.substring(6, filterName.length()));
            Assert.fail((String)(filterName + " unknown filtername. Should raise an IllegalArgumentException"));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(filterName + " unknown filtername. Exception raised:" + ex);
        }
        System.out.println("********  setFilter(filterY)  *********************");
        filterName = "filterY";
        try {
            main.setFilter(filterName.substring(6, filterName.length()));
            Assert.fail((String)(filterName + " out of camera. Should raise an RejectedCommandException"));
        }
        catch (RejectedCommandException ex) {
            System.out.println(filterName + " filterY is out of camera. Exception raised:" + (Object)((Object)ex));
        }
        System.out.println("********  setFilter(filterG)  *********************");
        filterName = "filterG";
        System.out.println("Filter List:" + filterManager.getFiltersMapByName());
        main.setFilter(filterName.substring(6, filterName.length()));
        Assert.assertEquals((String)("Now filter at ONLINE is " + filterName), (Object)filterName, (Object)main.getOnlineFilterName());
        Assert.assertTrue((String)"Carousel is ready to grab a filter at STANDBY", (boolean)carousel.isReadyToGrabAFilterAtStandby());
        System.out.println("********  setFilter(filterI)  *********************");
        filterName = "filterI";
        System.out.println("Filter List:" + filterManager.getFiltersMapByName());
        main.setFilter(filterName.substring(6, filterName.length()));
        Assert.assertEquals((String)("Now filter at ONLINE is " + filterName), (Object)filterName, (Object)main.getOnlineFilterName());
        Assert.assertTrue((String)"Carousel is ready to grab a filter at STANDBY", (boolean)carousel.isReadyToGrabAFilterAtStandby());
        System.out.println("********  store filter on carousel again   ********");
        autochanger.getOnlineClamps().unlockAndOpenClamps();
        trucks.goToStandby();
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        carousel.grabFilterAtStandby(filterManager.getFilterByID(autochanger.getFilterOnTrucksID()));
        Assert.assertTrue((String)"carousel is holding filter at STANDBY", (boolean)carousel.isHoldingFilter());
        Assert.assertEquals((String)"socket at STANDBY is now CLAMPEDONFILTER", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketAtStandby().getClampsState());
        Assert.assertFalse((String)"Autochanger is NOT empty", (boolean)autochanger.isEmpty());
        latches.open();
        trucks.goToHandOff();
        Assert.assertTrue((String)"Autochanger is now empty", (boolean)autochanger.isEmpty());
        Assert.assertTrue((String)"Autochanger is at HANDOFF", (boolean)autochanger.getAutochangerTrucks().isAtHandoff());
        Assert.assertTrue((String)"Filter I is now on Carousel", (boolean)carousel.isFilterOnCarousel(filterI.getFilterID()));
    }

    @AfterClass
    public static void after() throws Exception {
        fcsSubsystem.shutdownAgent();
        ((AgentStateService)fcsSubsystem.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 60L, TimeUnit.SECONDS);
    }

    public void launchScript() throws Exception {
        System.out.println("**************************************");
        System.out.println("***       launch  fcsTest.py       ***");
        System.out.println("**************************************");
        CCS.initializeScriptingEnvironment();
        Assert.assertTrue((String)"fcsSubsystem should be in OPERATIONAL phase.", (boolean)fcsSubsystem.isInState((Enum)PhaseState.OPERATIONAL));
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/fcsTest.py", (String[])new String[0]);
        System.out.println("**************************************");
        System.out.println("*** end of execution of fcsTest.py ***");
        System.out.println("**************************************");
    }

    static {
        LOCKA = 1000;
        LOCKB = 2000;
        LOCKC = 3000;
        FILTERPRESENCEA = 500;
        FILTERPRESENCEB = 1500;
        FILTERPRESENCEC = 2500;
    }
}

