
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.common.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This is a Model for a sensor on a can open bus which communicates over Can
 * Open protocol. The sensor is supposed to be connected to a ADC with analogics
 * input.(CAN-CBX-AI814)
 *
 * @author virieux
 */
public class CanOpenSensor14bits extends Sensor14bits implements HasLifecycle {

    /**
     * The ADC on which this sensor is plugged.
     */
    protected CanCBXAI814 adc;

    /**
     * The numero of analog input where the sensor is plugged.
     */
    //TODO range should be 1..8 fix because a CAN-CBX-AI814 has only 8 inputs.
    @ConfigurationParameter(range="1..8",
            description="The numero of the input of ADC where this sensor is plugged on.")
    protected int numOfAnalogInput;

    /**
     * Build a CanOpenSensor14bits with an ADC name a numero of input and a tickMillis of 1000.
     * @param adc
     * @param numOfAnalogInput 
     */
    public CanOpenSensor14bits(CanCBXAI814 adc, int numOfAnalogInput) {
        this.adc = adc;
        this.numOfAnalogInput = numOfAnalogInput;
    }

    public int getNumOfAnalogInput() {
        return numOfAnalogInput;
    }

    /**
     * Read a new value of this sensor on the ADC from PDO.
     * @return
     * @throws FcsHardwareException 
     */
    @Override
    public int readNewValue()  {
        value = adc.getInputs()[this.numOfAnalogInput];
        return value;
    }
    

    @Override
    public String getDeviceName() {
        return adc.getName();
    }


    @Override
    public void updateValue(int newValue) {
        value = newValue;
    }    
    

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/adcName=");
        sb.append(adc.name);
        sb.append("/inputNumero=");
        sb.append(this.numOfAnalogInput);
        return sb.toString();
    }


}
