/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.Map;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

public interface EPOSController
extends PieceOfHardware,
HasLifecycle,
ClearAlertHandler {
    public boolean isEnabledToPublish();

    public void setEnabledToPublish(boolean var1);

    public int readStatusWord();

    public short readControlWord();

    public void writeControlWord(int var1);

    @Command(type=Command.CommandType.ACTION, level=1, description="Shutdown the controller.")
    default public void shutdownController() {
        this.writeControlWord(6);
        this.setEnabledToPublish(false);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": is DISABLED/SHUTDOWN."));
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Disable voltage. This command does not activate holding brake. cf doc EPOS2_Firmware_Specification \u00a7 3.2 Device Control")
    default public void disableVoltage() {
        short cw = this.readControlWord();
        int mask = 65405;
        this.writeControlWord(cw & mask);
        this.setEnabledToPublish(false);
        FCSCst.FCSLOG.info((Object)(this.getName() + " High-level power is switched off."));
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Disable operation. This command activates holding brake. cf doc EPOS2_Firmware_Specification \u00a7 3.2 Device Control")
    default public void disableOperation() {
        short cw = this.readControlWord();
        int mask = 65399;
        int cw2 = cw & mask;
        int mask2 = 7;
        this.writeControlWord(cw2 | mask2);
        this.setEnabledToPublish(false);
        FCSCst.FCSLOG.info((Object)(this.getName() + " Drive function is disabled."));
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Switch on and enable controller.")
    default public void switchOnEnableOperation() {
        this.writeControlWord(15);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Stop action and disable(shutdown) controller.")
    default public void stopAction() {
        if (this.getMode() == EPOSEnumerations.EposMode.HOMING) {
            this.writeControlWord(287);
        } else if (this.getMode() == EPOSEnumerations.EposMode.CURRENT) {
            this.writeCurrent(0);
        } else if (this.getMode() == EPOSEnumerations.EposMode.PROFILE_POSITION) {
            this.stopPosition();
        } else if (this.getMode() == EPOSEnumerations.EposMode.PROFILE_VELOCITY) {
            this.stopVelocity();
        }
        this.disableOperation();
        FCSCst.FCSLOG.info((Object)(this.getName() + " ACTION STOPPED"));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="QuickStop.")
    default public void quickStop() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " running QUICKSTOP command."));
        if (this.getMode().equals((Object)EPOSEnumerations.EposMode.HOMING) || this.getMode().equals((Object)EPOSEnumerations.EposMode.PROFILE_POSITION) || this.getMode().equals((Object)EPOSEnumerations.EposMode.VELOCITY)) {
            this.writeControlWord(11);
        } else if (this.getMode().equals((Object)EPOSEnumerations.EposMode.CURRENT)) {
            this.writeControlWord(2);
        } else {
            throw new IllegalArgumentException(this.getName() + " has invalid Epos mode:" + (Object)((Object)this.getMode()));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="This methods enables the controller : i.e. this makes it able to receive commands.")
    default public void enable() {
        this.shutdownController();
        this.switchOnEnableOperation();
        this.checkEnabled();
        this.setEnabledToPublish(true);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ": is ENABLED."));
        this.publishData();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Check if controller is enabled otherwise, throw an Exception.")
    default public void checkEnabled() {
        long timeout = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        boolean enabled = false;
        while (!enabled && duration <= timeout) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " is not enabled yet. duration = " + duration));
            duration = System.currentTimeMillis() - timeStart;
            enabled = this.isEnabled();
        }
        if (!enabled) {
            FCSCst.FCSLOG.error((Object)(this.getName() + " NOT ENABLED StatusWord=" + this.readStatusWord()));
            this.checkFault();
            throw new FcsHardwareException(this.getName() + " couldn't be enabled during time allocated of " + timeout + " ms");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Check if controller is enabled otherwise, throw an Exception.")
    default public void checkDisabled() {
        long timeout = 500L;
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        boolean disabled = false;
        while (!disabled && duration <= timeout) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " is not disabled yet. duration = " + duration));
            duration = System.currentTimeMillis() - timeStart;
            disabled = !this.isEnabled();
        }
        if (!disabled) {
            FCSCst.FCSLOG.error((Object)(this.getName() + " IS STILL ENABLED StatusWord=" + this.readStatusWord()));
            this.checkFault();
            throw new FcsHardwareException(this.getName() + " couldn't be operation disabled during time allocated of " + timeout + " ms");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if the controller is enabled.")
    default public boolean isEnabled() {
        try {
            int statusWord = this.readStatusWord();
            int bit0 = statusWord & 1;
            int bit1 = statusWord >> 1 & 1;
            int bit2 = statusWord >> 2 & 1;
            int bit3 = statusWord >> 3 & 1;
            FCSCst.FCSLOG.debug((Object)(this.getName() + ": statusWord = " + statusWord + " => bit0=" + bit0 + ",bit1=" + bit1 + ",bit2=" + bit2 + ",bit3=" + bit3));
            return bit0 == 1 && bit1 == 1 && bit2 == 1 && bit3 == 0;
        }
        catch (SDORequestException ex) {
            String msg = this.getName() + " couldn't read status word because SDORequestException :" + ex.getMessage();
            FCSCst.FCSLOG.error((Object)msg);
            FCSCst.FCSLOG.error((Object)ex);
            throw new FcsHardwareException(msg, ex);
        }
    }

    public void changeMode(EPOSEnumerations.EposMode var1);

    public EPOSEnumerations.EposMode readMode();

    public EPOSEnumerations.EposMode getMode();

    @Command(type=Command.CommandType.QUERY, description="return true if this controller is in the mode given as argument.")
    default public boolean isInMode(EPOSEnumerations.EposMode aMode) {
        return aMode.equals((Object)this.getMode());
    }

    public int readCurrent();

    public int readCurrentAverageValue();

    public int readVelocity();

    public int readFollowingError();

    @Command(type=Command.CommandType.ACTION, level=1, description="In current mode this methods send a current to the motor.")
    public void writeCurrent(int var1) throws EPOSConfigurationException;

    @Command(type=Command.CommandType.ACTION, level=3, description="Enables controller and sets the current value in the EPOS CPU.")
    default public void enableAndWriteCurrent(int aValue) {
        this.checkCurrent(aValue);
        this.enable();
        this.writeCurrent(aValue);
    }

    default public void checkCurrent(int aValue) {
        if ((long)Math.abs(aValue) > this.readParameter("ContinuousCurrentLimit")) {
            throw new IllegalArgumentException(aValue + " is greater than ContinuousCurrentLimit.");
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Define the actual position as position given as argument.")
    default public void defineAbsolutePosition(int position) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " Defining Absolute Position:" + position));
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomePosition, position);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 35);
        this.enable();
        this.writeControlWord(31);
    }

    default public void definePositionFromNegativeLimitSwitch() {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " Homing with homing method negative limit switch"));
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.Parameter.HomePosition, 0);
        this.writeParameter(EPOSEnumerations.Parameter.HomingMethod, 17);
        this.enable();
        this.writeControlWord(31);
    }

    @Command(type=Command.CommandType.QUERY, level=1, alias="readPositionActualValue", description="In PROFILE_POSITION Mode this methods returns the actual position.")
    default public int readPosition() {
        return (int)this.readParameter(EPOSEnumerations.Parameter.PositionActualValue);
    }

    public int getPosition();

    public int getCurrent();

    public int getVelocity();

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the position returned by the absolute encoder (single serial data).")
    default public int readSSIPosition() {
        return (int)this.readParameter(EPOSEnumerations.Parameter.SSIEncoderActualPosition);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="In PROFILE_POSITION returns the value of the parameter ProfileVelocity.")
    default public long readProfileVelocity() {
        long profileVelocity = this.readParameter(EPOSEnumerations.Parameter.ProfileVelocity);
        FCSCst.FCSLOG.debug((Object)(this.getName() + ":readProfileVelocity=" + profileVelocity));
        return profileVelocity;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read PositionSensorType.")
    default public int readPositionSensorType() {
        return (int)this.readParameter(EPOSEnumerations.Parameter.PositionSensorType);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_POSITION mode this methods set the target position.")
    public void writeTargetPosition(int var1);

    @Command(type=Command.CommandType.ACTION, level=1, description="In PROFILE_VELOCITY mode this methods set the target velocity.")
    public void writeTargetVelocity(int var1);

    default public void changeProfileVelocity(int newVelocity) {
        FCSCst.FCSLOG.info((Object)(this.getName() + " changing ProfileVelocity to " + newVelocity));
        try {
            this.writeParameter(EPOSEnumerations.Parameter.ProfileVelocity, newVelocity);
        }
        catch (Exception ex) {
            String msg = this.getName() + " : could not change ProfileVelocity to value " + newVelocity;
            FCSCst.FCSLOG.error((Object)msg);
            throw new FcsHardwareException(msg, ex);
        }
    }

    public boolean isParametersOK();

    public long readParameter(EPOSEnumerations.Parameter var1);

    public void writeParameter(EPOSEnumerations.Parameter var1, int var2);

    public void checkParameters(EPOSEnumerations.EposMode var1);

    public void writeParameters(EPOSEnumerations.EposMode var1);

    @Command(type=Command.CommandType.ACTION, level=3, description="Write in the CPU of the EPOS device the values of the parameters set for the mode.")
    default public void writeParameters() {
        this.readMode();
        this.writeParameters(this.getMode());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Reads in the EPOS CPU the decimal value of the Parameter which parameter name is given as argument.")
    default public long readParameter(String parameterName) {
        EPOSEnumerations.Parameter param = EPOSEnumerations.Parameter.valueOf(parameterName);
        return this.readParameter(param);
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read the parameters for the actual mode.")
    default public String readParameters() {
        return this.readParameters(this.readMode().toString());
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="This methods reads in the CPU of the EPOS the values of the parameters for a given mode.")
    default public String readParameters(String modeInString) {
        return this.readParameters(EPOSEnumerations.EposMode.valueOf(modeInString));
    }

    default public String readParameters(EPOSEnumerations.EposMode aMode) {
        EPOSEnumerations.Parameter[] params;
        String modeIS = aMode.toString();
        StringBuilder sb = new StringBuilder(this.getName() + " parameters VALUES in decimal format for mode ");
        sb.append(modeIS);
        sb.append("\n");
        for (EPOSEnumerations.Parameter param : params = aMode.getParameters()) {
            sb.append(param.toString());
            sb.append("=");
            long valueInt = this.readParameter(param);
            sb.append(valueInt);
            sb.append("\n");
        }
        FCSCst.FCSLOG.debug((Object)(this.getName() + sb.toString()));
        return sb.toString();
    }

    default public void writeParameters(Map<String, Integer> paramMap) {
        for (Map.Entry<String, Integer> entry : paramMap.entrySet()) {
            String paramName = entry.getKey();
            int value = entry.getValue();
            this.writeParameter(EPOSEnumerations.Parameter.valueOf(paramName), value);
        }
    }

    public static long convertEPOSValue(EPOSEnumerations.Parameter param, long value, String myName) {
        if (!param.isSigned()) {
            return value;
        }
        if (param.getSize() == 4) {
            return (int)value;
        }
        if (param.getSize() == 2) {
            return (short)value;
        }
        if (param.getSize() == 1) {
            return (byte)value;
        }
        throw new EPOSConfigurationException(myName + ":\f" + param.getSize() + " => bad value for size");
    }

    public boolean isInError();

    public String getErrorRegister();

    public int[] getErrorHistory();

    public int readNumberOfErrors();

    public String displayErrorHistory();

    public void checkFault();

    @Command(type=Command.CommandType.QUERY, level=1, description="In HOMING mode and PROFILE_POSITION mode this indicates that the position is reached.")
    default public boolean isTargetReached() {
        return (this.readStatusWord() >> 10 & 1) == 1;
    }

    default public void checkTargetReached(long timeout) {
        long timeStart = System.currentTimeMillis();
        long duration = 0L;
        while (!this.isTargetReached() && duration <= timeout) {
            FCSCst.FCSLOG.info((Object)(this.getName() + " target is not yet reached."));
            duration = System.currentTimeMillis() - timeStart;
        }
        if (!this.isTargetReached()) {
            String msg = this.getName() + " couldn't reach target during time allocated of " + timeout + " ms";
            FCSCst.FCSLOG.info((Object)msg);
            throw new FcsHardwareException(msg);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Enable controller and go to absolute position. Doesn't check condition. DANGER !!!! ")
    default public void enableAndWriteAbsolutePosition(int pos) {
        this.enable();
        this.writeTargetPosition(pos);
        this.writeControlWord(63);
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Enable controller and go to relative position. Doesn't check condition. DANGER !!!! ")
    default public void enableAndWriteRelativePosition(int pos) {
        this.enable();
        this.writeTargetPosition(pos);
        this.writeControlWord(127);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Change to PROFILE_VELOCITY mode, and move with velocity given as argument. To stop motion command is stopVelocity.")
    default public void startVelocity(int velocity) {
        this.changeMode(EPOSEnumerations.EposMode.PROFILE_VELOCITY);
        this.enable();
        this.writeTargetVelocity(velocity);
        this.switchOnEnableOperation();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Stop motion when in mode PROFILE_POSITION.")
    default public void stopPosition() {
        if (!this.isInMode(EPOSEnumerations.EposMode.PROFILE_POSITION)) {
            throw new RejectedCommandException(this.getName() + " is not in PROFILE_POSITION mode.");
        }
        this.writeControlWord(271);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Stop motion when in mode PROFILE_VELOCITY.")
    default public void stopVelocity() {
        if (!this.isInMode(EPOSEnumerations.EposMode.PROFILE_VELOCITY)) {
            throw new RejectedCommandException(this.getName() + " is not in PROFILE_VELOCITY mode.");
        }
        this.writeControlWord(263);
    }

    default public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
    }

    default public StatusDataPublishedByEPOSController createStatusDataPublishedByEPOSController() {
        StatusDataPublishedByEPOSController status = new StatusDataPublishedByEPOSController(this.isBooted(), this.isInitialized());
        status.setInError(this.isInError());
        status.setErrorRegister(this.getErrorRegister());
        status.setErrorHistory(this.getErrorHistory());
        status.setEnabled(this.isEnabledToPublish());
        status.setMode(this.getMode());
        return status;
    }
}

