import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*

//Carousel Can Open Devices (CAN-CBX-AI814)
def adcName = "ai814"

//Carousel clamps controllers name
def clampXminusControllerName = "clampXminusController" //controller to unlock clamp on the side Xminus
def clampXplusControllerName =  "clampXplusController" //controller to unlock clamp on the side Xplus

//Autochanger Can Open Devices
def dacName = "ao412"  // to control the latches actuator
def railsSensorsDIOName = "dio8n1"  // to control the trucks and monitor the rails sensors
def filterSensorsDIOName = "dio8n2" // to monitor the filter sensors

CCSBuilder builder = ["testSftCarouselClamp"]

builder.
    main ( MainModule, bridge:ref("tcpProxy"), autochanger:ref("autochanger")) {

            tcpProxy (CanOpenProxy, hardwareBootTimeout:2500) {

                canInterface(SimuCanOpenInterface)

                ai814 (SimuCanOpenADC, 
                    nodeID:0x21,serialNB:"c7c40234",transmissionType:1)

                clampXminusController (SimuCarouselClampController,    
                    //name: clampXminusControllerName),
                    nodeID:0x1a,serialNB:"79003317",
                    paramsForCurrent:[MotorType:11, PositionSensorType:3,PolePairNumber:8,
                        ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                        ThermalTimeConstantWinding:160,
                        MaxSpeedInCurrentMode:25],
                    paramsForProfilePosition:[MotionProfileType:0],
                    paramsForHoming:[HomeOffset:0])  
            }
    
            //-------------------------
            // BEGIN clampXminus description
            clampXminus (CarouselClamp,
                
                filterPresenceSensor:ref("filterPresenceXminus"),
                lockSensor:ref("lockSensorXminus"),
            )
            {
                filterPresenceXminus (SimuCarouselClampFilterPresenceSensor,
                    adc:ref("$adcName"),numOfAnalogInput:1)
                
                lockSensorXminus (SimuCarouselClampLockSensor,
                    adc:ref("$adcName"),numOfAnalogInput:7)
            }

        
    }
