import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*

//Carousel CAN OPEN device to read carousel clamp sensors
def caTTC580Name = "hyttc580"

//Carousel clamps controllers name
def clampXminusControllerName = "clampXminusController" //controller to unlock clamp on the side Xminus
def clampXplusControllerName =  "clampXplusController" //controller to unlock clamp on the side Xplus

//Autochanger Can Open Devices
def dacName = "ao412"  // to control the latches actuator
def railsSensorsDIOName = "dio8n1"  // to control the trucks and monitor the rails sensors
def filterSensorsDIOName = "dio8n2" // to monitor the filter sensors

/* 
 * carousel positions when a socket is at STANDBY
 * example : socket 1 is at STANDBY when carousel position is -204200
 * */
def standbyPositionSocket = [-204200,-1075906,-1948470,-2821074,-3694258] as int[]

CCSBuilder builder = ["testCarouselClamp"]

builder.
    main ( MainModule, bridge:ref("tcpProxy")) {

            tcpProxy (CanOpenProxy, hardwareBootTimeout:2500) {

                canInterface(SimuCanOpenInterface)

                // can open devices to read clamps sensors
                hyttc580 (SimuTTC580, nodeID:0x3, serialNB:"TTC580A1")

                clampXminusController (SimuCarouselClampController,    
                    //name: clampXminusControllerName),
                    nodeID:0x1a,serialNB:"79003317",
                    paramsForCurrent:[MotorType:11, PositionSensorType:3,PolePairNumber:8,
                        ContinuousCurrentLimit:2360,OutputCurrentLimit:4720,
                        ThermalTimeConstantWinding:160,
                        MaxSpeedInCurrentMode:25],
                    paramsForProfilePosition:[MotionProfileType:0],
                    paramsForHoming:[HomeOffset:0])  
                
                clampXplusController (SimuCarouselClampController,
                    nodeID:0x1b, serialNB:"79003313",
                    paramsForCurrent: [
                        MotorType:11, 
                        PositionSensorType:3,
                        PolePairNumber:8,
                        ContinuousCurrentLimit:2360,
                        OutputCurrentLimit:4720,
                        ThermalTimeConstantWinding:160,
                        MaxSpeedInCurrentMode:25],
                    paramsForProfilePosition: [MotionProfileType:0],
                    paramsForHoming:[HomeOffset:0])

                carouselController (SimuCarouselController,
                    nodeID:0xc, serialNB:"80003117",
                    paramsForCurrent:[
                        ContinuousCurrentLimit:9375,
                        OutputCurrentLimit:12500,
                        MaxSpeedInCurrentMode:5000,
                        MotorType:11,PolePairNumber:12,
                        PositionSensorType:4],
                    paramsForProfilePosition: [
                        MinPositionLimit:-2147483648,
                        MaxPositionLimit:2147483647,
                        MotionProfileType:1, /*0:trapezoidal, 1:sinusoidal*/
                        ProfileAcceleration:2000,
                        ProfileDeceleration:2000,
                        MaxProfileVelocity:5371,
                        QuickStopDeceleration:10000],
                    paramsForHoming:[HomeOffset:0])
        
        }
    
        /**********************************************************************/
        /*                BEGIN OF CAROUSEL DESCRIPTION                       */
        /**********************************************************************/

    //----------------------------
    // BEGIN Carousel description
    carousel(Carousel)
    {//begin description of carousel's children
        /*SOCKET1*/
        for (int i = 1; i<6;i++ ) {
            "socket${i}" ( CarouselSocket,
                clampXminus:ref("clampXminus${i}"),
                clampXplus:ref("clampXplus${i}"),
                standbyPosition: standbyPositionSocket[i-1])
            {   
                //-------------------------
                // BEGIN clampXminus description
                "clampXminus${i}" (CarouselClamp,
                    filterPresenceSensor:ref("filterPresenceXminus${i}"),
                    lockSensor:ref("lockSensorXminus${i}"),
//                    thermometer:ref("thermometerXminus${i}")
                ) 
                {
                    "filterPresenceXminus${i}" (CarouselSensor, deviceName: caTTC580Name)
                    
                    "lockSensorXminus${i}" (CarouselSensor, deviceName: caTTC580Name) 
                    
//                    "thermometerXminus${i}" (SimuThermometer)
                }
                //-------------------------
                // END clampXminus description
                
                //-------------------------
                // BEGIN clampXplus description
                "clampXplus${i}" (CarouselClamp,
                    filterPresenceSensor:ref("filterPresenceXplus${i}"),
                    lockSensor:ref("lockSensorXplus${i}"),
//                    thermometer:ref("thermometerXplus${i}")
                )
                {
                    "filterPresenceXplus${i}" (CarouselSensor, deviceName: caTTC580Name)
                    "lockSensorXplus${i}" (CarouselSensor, deviceName: caTTC580Name)
//                    "thermometerXplus${i}" (SimuThermometer)
                }
                //-------------------------
                // END clampXplus description
            } // END carouselSocket /*SOCKET1*/ description
        }
    }//end description of carousel's children
    //END Carousel description
    // ------------------------
} // end of CarouselMain description

        
