/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenADC;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChanger;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftMain;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SimuCarouselClampFilterPresenceSensor;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SimuCarouselClampLockSensor;

public class SingleFilterToto
extends CcsTestCaseTemplate {
    private static Subsystem sftSubsystem = null;
    private static SftMain main;
    private static Carousel carousel;
    private static CarouselSocket socket1;
    private static SftAutoChanger autochanger;
    private static CarouselClamp clampXminus;
    private static CarouselClamp clampXplus;
    private static SimuCanOpenADC adc;
    private static SimuCarouselClampLockSensor lockSensorXminus;
    private static SimuCarouselClampLockSensor lockSensorXplus;
    private static SimuCarouselClampFilterPresenceSensor filterPresenceXminus;
    private static SimuCarouselClampFilterPresenceSensor filterPresenceXplus;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************");
        System.out.println("TESTS OF SINGLE-FILTER-TEST");
        System.out.println("***************************");
        CCS.initializeScriptingEnvironment();
        sftSubsystem = BootUtils.getSubsystemFromFile((String)"single-filter-test__simulation", (String)"");
        sftSubsystem.startAgent();
        sftSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 80L, TimeUnit.SECONDS);
        ComponentLookup lookup = sftSubsystem.getComponentLookup();
        main = (SftMain)lookup.getComponentByName("main");
        carousel = (Carousel)lookup.getComponentByName("carousel");
        socket1 = (CarouselSocket)lookup.getComponentByName("socket1");
        autochanger = (SftAutoChanger)lookup.getComponentByName("autochanger");
        clampXminus = (CarouselClamp)lookup.getComponentByName("clampXminus");
        clampXplus = (CarouselClamp)lookup.getComponentByName("clampXplus");
        adc = (SimuCanOpenADC)lookup.getComponentByName("ai814");
        lockSensorXminus = (SimuCarouselClampLockSensor)lookup.getComponentByName("lockSensorXminus");
        lockSensorXplus = (SimuCarouselClampLockSensor)lookup.getComponentByName("lockSensorXplus");
        filterPresenceXminus = (SimuCarouselClampFilterPresenceSensor)lookup.getComponentByName("filterPresenceXminus");
        filterPresenceXplus = (SimuCarouselClampFilterPresenceSensor)lookup.getComponentByName("filterPresenceXplus");
        adc.initializeAndCheckHardware();
        lockSensorXminus.simulateClampIsLOCKED();
        lockSensorXplus.simulateClampIsLOCKED();
        filterPresenceXminus.simulateFilterIsLockable();
        filterPresenceXplus.simulateFilterIsLockable();
        clampXminus.updateState();
        clampXplus.updateState();
        main.locateFilter();
    }

    @AfterClass
    public static void after() throws Exception {
        sftSubsystem.shutdownAgent();
        sftSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Before
    public void setUp() throws DriverException {
        System.out.println("***********  BEFORE test : setUp    *******************");
        Assert.assertTrue((String)"carousel is at standby", (boolean)carousel.isAtStandby());
        Assert.assertFalse((String)"carousel doesn't rotate in single-filter-test", (boolean)carousel.isRotating());
        Assert.assertEquals((String)"socket1 is at standby", (Object)socket1, (Object)carousel.getSocketAtStandby());
        Assert.assertFalse((String)"a filter is on socket1", (boolean)socket1.isEmpty());
        lockSensorXminus.simulateClampIsLOCKED();
        lockSensorXplus.simulateClampIsLOCKED();
        filterPresenceXminus.simulateFilterIsLockable();
        filterPresenceXplus.simulateFilterIsLockable();
        clampXminus.updateState();
        clampXplus.updateState();
        Assert.assertTrue((String)"clampXminus is LOCKED", (boolean)clampXminus.isLocked());
        Assert.assertTrue((String)"clampXminus is ENGAGED", (boolean)clampXminus.isFilterEngaged());
        Assert.assertTrue((String)"clampXplus is LOCKED", (boolean)clampXplus.isLocked());
        Assert.assertTrue((String)"clampXplus is ENGAGED", (boolean)clampXplus.isFilterEngaged());
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"clamps are CLAMPED", (boolean)socket1.isClampedOnFilter());
        Assert.assertTrue((String)"carousel is at holding a filter", (boolean)carousel.isHoldingFilter());
        autochanger.updateTrucksLocationWithSensors();
        Assert.assertFalse((String)"autochanger is not at standby", (boolean)autochanger.isAtStandby());
        Assert.assertTrue((String)"autochanger is at standback", (boolean)autochanger.isAtStandback());
        System.out.println("*******************************************************");
    }

    @Test
    public void launchScript() throws Exception {
        System.out.println("*** Launch singleFilterTest.py ***");
        Assert.assertTrue((String)"singleFilterSubsystem should be in OPERATIONAL phase.", (boolean)sftSubsystem.isInState((Enum)PhaseState.OPERATIONAL));
        JythonScriptExecutorUtils.executeScript((String)"org/lsst/ccs/subsystems/fcs/scripts/singleFilterTest.py", (String[])new String[0]);
    }
}

