/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.CompactIO;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SimuCompactIO
extends CompactIO
implements HasLifecycle {
    @ConfigurationParameter
    private int initialValue;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private DigitalSensor filterPresenceSensorLatchXminus;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private DigitalSensor filterPresenceSensorLatchXplus;

    public SimuCompactIO(int nodeID, String serialNB, int initialValue) {
        super(nodeID, serialNB);
        this.initialValue = initialValue;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    public void setValue(int hex) {
        this.value = hex;
    }

    public void init() {
        this.value = this.initialValue;
    }

    @Override
    public int readNewValue() {
        return this.value;
    }

    public void simulateFilterPresenceInLatches(int aDigitalValue) {
        int inputNumeroXminus = this.filterPresenceSensorLatchXminus.getInputNumero();
        int inputNumeroXplus = this.filterPresenceSensorLatchXplus.getInputNumero();
        this.replaceDigitalValues(inputNumeroXminus, aDigitalValue, inputNumeroXplus, aDigitalValue);
    }

    public void replaceDigitalValues(int channel1, int digitalValue1, int channel2, int digitalValue2) {
        if (channel1 < 0 || channel1 > 7) {
            throw new IllegalArgumentException("bad value for channel1 : Channel numero has to be between 1 and 8.");
        }
        if (channel2 < 0 || channel2 > 7) {
            throw new IllegalArgumentException("bad value for channel2 : Channel numero has to be between 1 and 8.");
        }
        if (digitalValue1 != 0 && digitalValue1 != 1) {
            throw new IllegalArgumentException("digitalValue1 has to be a String equals \"0\" or \"1\". ");
        }
        if (digitalValue2 != 0 && digitalValue2 != 1) {
            throw new IllegalArgumentException("digitalValue1 has to be a String equals \"0\" or \"1\". ");
        }
        FCSCst.FCSLOG.debug((Object)(this.name + "=> old value = " + this.value));
        int inter = FcsUtils.forceBit(this.value, channel1, digitalValue1);
        int newDIOValue = FcsUtils.forceBit(inter, channel2, digitalValue2);
        FCSCst.FCSLOG.debug((Object)(this.name + "=> new value = " + newDIOValue));
        this.value = newDIOValue;
    }
}

