/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.CompactIO;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.LatchActuator;

public class SftFilterLatch
extends MobileItem {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule mainModule;
    private boolean locked;
    private boolean unlocked;
    private boolean inError;
    private FcsEnumerations.FilterPresenceStatus presenceStatus = FcsEnumerations.FilterPresenceStatus.UNKNOWN;
    private FcsEnumerations.LockStatus lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    protected final LatchActuator latchActuator;
    protected DigitalSensor filterPresenceSensor;
    protected DigitalSensor lockSensor;
    protected DigitalSensor unlockSensor;
    private final CompactIO filterSensorsDIO;
    @ConfigurationParameter(description="timeout in milliseconds : if closing the autochanger latches last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForOpening = 10000L;
    @ConfigurationParameter(description="timeout in milliseconds : if opening the autochanger latches last more than this amount of time, then the subsystem goes in ERROR.")
    private long timeoutForClosing = 10000L;
    private final Condition stateUpdated = this.lock.newCondition();
    protected volatile boolean updatingState = false;

    public SftFilterLatch(CompactIO filterSensorsDIO, DigitalSensor lockSensor, DigitalSensor unlockSensor, DigitalSensor filterPresenceSensor, LatchActuator latchActuator) {
        this.filterSensorsDIO = filterSensorsDIO;
        this.lockSensor = lockSensor;
        this.unlockSensor = unlockSensor;
        this.filterPresenceSensor = filterPresenceSensor;
        this.latchActuator = latchActuator;
    }

    public long getTimeoutForClosing() {
        return this.timeoutForClosing;
    }

    public long getTimeoutForOpening() {
        return this.timeoutForOpening;
    }

    public DigitalSensor getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public LatchActuator getLatchActuator() {
        return this.latchActuator;
    }

    public DigitalSensor getLockSensor() {
        return this.lockSensor;
    }

    public DigitalSensor getUnlockSensor() {
        return this.unlockSensor;
    }

    public boolean isControllerInFault() {
        return false;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hardware is connected and ready.")
    public boolean myDevicesReady() {
        return this.mainModule.allDevicesBooted();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPEN)) {
            return this.getLockStatus().equals(FcsEnumerations.LockStatus.UNLOCKED);
        }
        if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSE)) {
            return this.getLockStatus().equals(FcsEnumerations.LockStatus.LOCKED);
        }
        throw new IllegalArgumentException("Action on latch must be OPEN or CLOSE");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() {
        this.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Reads latch sensors and updates latch state")
    public void updateStateWithSensors() {
        this.filterSensorsDIO.updateValue();
        int filterSensorsValue = this.filterSensorsDIO.getValue();
        this.updateState(filterSensorsValue);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws FcsHardwareException {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPEN)) {
            this.latchActuator.open();
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSE)) {
            this.latchActuator.close();
        } else {
            throw new IllegalArgumentException(this.name + "Action on latch must be OPEN or CLOSE");
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) {
        this.publishData();
    }

    public FcsEnumerations.LockStatus getLockStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)(this.name + ": getLockStatus was interrupted while waiting for update."));
                }
            }
            FcsEnumerations.LockStatus lockStatus = this.lockStatus;
            return lockStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLockStatus(FcsEnumerations.LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public FcsEnumerations.FilterPresenceStatus getPresenceStatus() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSLOG.error((Object)(this.name + ": getPresenceStatus was interrupted while waiting for update."));
                }
            }
            FcsEnumerations.FilterPresenceStatus filterPresenceStatus = this.presenceStatus;
            return filterPresenceStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Open latch")
    public String open() {
        this.updateStateWithSensors();
        if (!this.isLocked()) {
            return this.getName() + "is already OPEN";
        }
        Carousel carousel = (Carousel)this.s.getComponentLookup().getComponentByName("carousel");
        if (!carousel.isHoldingFilterAtStandby()) {
            throw new RejectedCommandException(this.name + "CANNOT OPEN LATCH at STANDBY : CAROUSEL is NOT HOLDING THE FILTER");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.OPEN, this.timeoutForOpening);
        this.latchActuator.powerOff();
        return this.getName() + " is OPEN";
    }

    @Command(type=Command.CommandType.ACTION, level=3, description="Close latch")
    public String close() {
        this.updateStateWithSensors();
        if (this.isLocked()) {
            return this.getName() + "is already CLOSED";
        }
        this.executeAction(FcsEnumerations.MobileItemAction.CLOSE, this.timeoutForClosing);
        this.latchActuator.powerOff();
        return this.getName() + " is CLOSED";
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Return true if the latch is closed")
    public boolean isLocked() {
        return this.getLockStatus().equals(FcsEnumerations.LockStatus.LOCKED);
    }

    public void updateState(int value) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.filterPresenceSensor.updateValue(value);
            this.lockSensor.updateValue(value);
            this.unlockSensor.updateValue(value);
            this.presenceStatus = this.filterPresenceSensor.isOn() ? FcsEnumerations.FilterPresenceStatus.ENGAGED : FcsEnumerations.FilterPresenceStatus.NOFILTER;
            this.locked = this.lockSensor.isOn();
            this.unlocked = this.unlockSensor.isOn();
            boolean bl = this.inError = this.locked && this.unlocked;
            this.lockStatus = this.inError ? FcsEnumerations.LockStatus.ERROR : (this.locked ? FcsEnumerations.LockStatus.LOCKED : (this.unlocked ? FcsEnumerations.LockStatus.UNLOCKED : FcsEnumerations.LockStatus.UNKNOWN));
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
        this.publishData();
    }

    public StatusDataPublishedByAutochangerLatch createStatusDataPublishedByLatch() {
        StatusDataPublishedByAutochangerLatch status = new StatusDataPublishedByAutochangerLatch();
        status.setLockSensorValue(this.getLockSensor().isOn());
        status.setUnlockSensorValue(this.getUnlockSensor().isOn());
        status.setFilterPresenceSensorValue(this.getFilterPresenceSensor().isOn());
        status.setLockStatus(this.getLockStatus());
        status.setControllerInFault(this.isControllerInFault());
        return status;
    }

    @Override
    public void publishData() {
        StatusDataPublishedByAutochangerLatch status = this.createStatusDataPublishedByLatch();
        this.s.publishSubsystemDataOnStatusBus(new KeyValueData(this.name, (Serializable)status));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/ lock sensor=");
        sb.append(this.lockSensor.getName());
        sb.append("/ unlock sensor=");
        sb.append(this.unlockSensor.getName());
        sb.append("/ filter presence sensor=");
        sb.append(this.filterPresenceSensor.getName());
        return sb.toString();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

