/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;

public class SftCarousel
extends Carousel {
    @Override
    public CarouselSocket getSocketAtStandby() {
        return this.getSocketByName("socket1");
    }

    @Override
    public int getPosition() {
        return 0;
    }

    @Override
    public void postStart() {
        if (this.ai814.isBooted()) {
            this.ai814.initializeAndCheckHardware();
        } else {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, "ai814 not booted", this.ai814.getName());
        }
    }

    @Override
    public boolean isRotating() {
        return false;
    }

    @Override
    public void updateClampsStateWithSensorsFromPDO() {
        PDOData pdoStore = this.tcpProxy.updatePDOData();
        try {
            this.ai814.updateFromPDO(pdoStore);
        }
        catch (DriverException ex) {
            FCSLOG.error((Object)this.name, (Throwable)ex);
        }
        FCSLOG.finest((Object)(this.name + ":pdoStore=" + pdoStore.toString()));
        this.socketsMap.values().stream().forEach(socket -> socket.updateClampsState());
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Read sensors and update state")
    public void updateStateWithSensors() {
        this.updateClampsStateWithSensorsFromPDO();
    }

    public String rotate(float angle) {
        throw new UnsupportedOperationException("Operation rotate not available in Single Filter Test");
    }
}

