/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.drivers.PlutoGateway;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SimuPlutoGateway
extends PlutoGateway
implements HasLifecycle {
    public SimuPlutoGateway(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public int[] readNewValues() {
        return this.readValues;
    }

    @Override
    public int[] readValuesFromPDO() {
        return this.readValues;
    }

    public void replaceValues(DigitalSensor sensor, boolean on) {
        this.lock.lock();
        try {
            this.updatingValues = true;
            this.replaceSensorValue(sensor, on);
        }
        finally {
            this.updatingValues = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }

    private void replaceSensorValue(DigitalSensor sensor, boolean on) {
        int byteNo = sensor.getByteNumero();
        int value = this.readValues[byteNo];
        int newValue = on ? FcsUtils.force2one(value, sensor.getInputNumero()) : FcsUtils.force2zero(value, sensor.getInputNumero());
        this.readValues[byteNo] = newValue;
    }
}

