/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.ForceSensor;
import org.lsst.ccs.subsystems.fcs.LoaderCarrier;
import org.lsst.ccs.subsystems.fcs.LoaderClamp;
import org.lsst.ccs.subsystems.fcs.RedondantSensors;
import org.lsst.ccs.subsystems.fcs.common.BinarySensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderCarrierController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGateway;

public class SimuLoaderPlutoGateway
extends SimuPlutoGateway {
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private LoaderCarrier carrier;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private LoaderClamp clamp;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private SimuLoaderCarrierController carrierController;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private SimuLoaderClampController hooksController;
    private DigitalSensor closeSensor1;
    private DigitalSensor openSensor1;
    private DigitalSensor closeSensor2;
    private DigitalSensor openSensor2;
    private DigitalSensor closeSensor3;
    private DigitalSensor openSensor3;
    private DigitalSensor closeSensor4;
    private DigitalSensor openSensor4;
    private DigitalSensor unclampedStatusSensor;
    private DigitalSensor underClampedStatusSensor;
    private DigitalSensor clampedStatusSensor;
    private DigitalSensor overClampedStatusSensor;
    private ForceSensor forceSensor0;
    private ForceSensor forceSensor1;
    private RedondantSensors filterPresenceSensors;
    private RedondantSensors loaderOnCameraSensors;
    private BinarySensor storagePositionSensors;
    private BinarySensor handoffPositionSensors;
    private BinarySensor engagedPositionSensors;

    public SimuLoaderPlutoGateway(int nodeID, String serialNB) {
        super(nodeID, serialNB);
    }

    @Override
    public void init() {
        super.init();
        ComponentLookup lookup = this.subs.getComponentLookup();
        this.closeSensor1 = (DigitalSensor)lookup.getComponentByName("loaderCloseSensor1");
        this.closeSensor2 = (DigitalSensor)lookup.getComponentByName("loaderCloseSensor2");
        this.closeSensor3 = (DigitalSensor)lookup.getComponentByName("loaderCloseSensor3");
        this.closeSensor4 = (DigitalSensor)lookup.getComponentByName("loaderCloseSensor4");
        this.openSensor1 = (DigitalSensor)lookup.getComponentByName("loaderOpenSensor1");
        this.openSensor2 = (DigitalSensor)lookup.getComponentByName("loaderOpenSensor2");
        this.openSensor3 = (DigitalSensor)lookup.getComponentByName("loaderOpenSensor3");
        this.openSensor4 = (DigitalSensor)lookup.getComponentByName("loaderOpenSensor4");
        this.clampedStatusSensor = (DigitalSensor)lookup.getComponentByName("clampedStatusSensor");
        this.unclampedStatusSensor = (DigitalSensor)lookup.getComponentByName("unclampedStatusSensor");
        this.underClampedStatusSensor = (DigitalSensor)lookup.getComponentByName("underClampedStatusSensor");
        this.overClampedStatusSensor = (DigitalSensor)lookup.getComponentByName("overClampedStatusSensor");
        this.forceSensor0 = (ForceSensor)lookup.getComponentByName("forceSensor0");
        this.forceSensor1 = (ForceSensor)lookup.getComponentByName("forceSensor1");
        this.loaderOnCameraSensors = (RedondantSensors)lookup.getComponentByName("loaderOnCameraSensors");
        this.filterPresenceSensors = (RedondantSensors)lookup.getComponentByName("loaderFilterPresenceSensors");
        this.storagePositionSensors = (RedondantSensors)lookup.getComponentByName("loaderStorageSensors");
        this.handoffPositionSensors = (BinarySensor)lookup.getComponentByName("loaderHandoffSensors");
        this.engagedPositionSensors = (BinarySensor)lookup.getComponentByName("loaderEngagedSensors");
        this.simulateLoaderClampIsClosed();
        this.simulateLoaderIsConnectedOnCamera();
        this.simulateClampedStatusSensorIsOn();
        this.simulateFilterIsOnLoader();
        this.simulateLoaderCarrierIsAtStorage();
    }

    protected void simuBinarySensorOn(BinarySensor sensor) {
        if (sensor instanceof RedondantSensors) {
            this.replaceValues(((RedondantSensors)sensor).getSensor(), true);
            this.replaceValues(((RedondantSensors)sensor).getSensorR(), true);
        } else {
            this.replaceValues((DigitalSensor)sensor, true);
        }
    }

    protected void simuBinarySensorOff(BinarySensor sensor) {
        if (sensor instanceof RedondantSensors) {
            this.replaceValues(((RedondantSensors)sensor).getSensor(), false);
            this.replaceValues(((RedondantSensors)sensor).getSensorR(), false);
        } else {
            this.replaceValues((DigitalSensor)sensor, false);
        }
    }

    protected void simuRedondantSensorsInError(RedondantSensors sensors) {
        this.replaceValues(sensors.getSensor(), true);
        this.replaceValues(sensors.getSensorR(), false);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsClosed() {
        this.simulateHooksAreClosed();
        this.simulateUnclampedStatusSensorIsOn();
        this.hooksController.setPosition(this.clamp.getRelativePositionToClose());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsClamped() {
        this.simulateHooksAreClosed();
        this.simulateClampedStatusSensorIsOn();
        this.hooksController.setPosition(this.clamp.getTargetPositionToClamp());
    }

    private void simulateHooksAreClosed() {
        this.simulateHookIsClosed(this.closeSensor1, this.openSensor1);
        this.simulateHookIsClosed(this.closeSensor2, this.openSensor2);
        this.simulateHookIsClosed(this.closeSensor3, this.openSensor3);
        this.simulateHookIsClosed(this.closeSensor4, this.openSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsOpened() {
        this.simulateHookIsOpened(this.closeSensor1, this.openSensor1);
        this.simulateHookIsOpened(this.closeSensor2, this.openSensor2);
        this.simulateHookIsOpened(this.closeSensor3, this.openSensor3);
        this.simulateHookIsOpened(this.closeSensor4, this.openSensor4);
        this.simulateUnclampedStatusSensorIsOn();
        this.hooksController.setPosition(this.clamp.getTargetPositionToOpen());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderClampIsInTravel() {
        this.simulateHookIsInTravel(this.closeSensor1, this.openSensor1);
        this.simulateHookIsInTravel(this.closeSensor2, this.openSensor2);
        this.simulateHookIsInTravel(this.closeSensor3, this.openSensor3);
        this.simulateHookIsInTravel(this.closeSensor4, this.openSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateClampIsUnknown() {
        this.simulateHookIsOpened(this.closeSensor1, this.openSensor1);
        this.simulateHookIsOpened(this.closeSensor2, this.openSensor2);
        this.simulateHookIsOpened(this.closeSensor3, this.openSensor3);
        this.simulateHookIsClosed(this.closeSensor4, this.openSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateClampIsInError() {
        this.simulateHookIsInError(this.closeSensor1, this.openSensor1);
        this.simulateHookIsOpened(this.closeSensor2, this.openSensor2);
        this.simulateHookIsOpened(this.closeSensor3, this.openSensor3);
        this.simulateHookIsClosed(this.closeSensor4, this.openSensor4);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsClosed(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.replaceValues(closeSensor, true);
        this.replaceValues(openSensor, false);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsOpened(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.replaceValues(closeSensor, false);
        this.replaceValues(openSensor, true);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsInError(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.replaceValues(closeSensor, true);
        this.replaceValues(openSensor, true);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHookIsInTravel(DigitalSensor closeSensor, DigitalSensor openSensor) {
        this.replaceValues(closeSensor, false);
        this.replaceValues(openSensor, false);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsConnectedOnCamera() {
        this.simuBinarySensorOn(this.loaderOnCameraSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsNotConnectedOnCamera() {
        this.simuBinarySensorOff(this.loaderOnCameraSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsOnLoader() {
        this.simuBinarySensorOn(this.filterPresenceSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateFilterIsNotOnLoader() {
        this.simuBinarySensorOff(this.filterPresenceSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsAtStorage() {
        this.simuBinarySensorOn(this.storagePositionSensors);
        this.simuBinarySensorOff(this.handoffPositionSensors);
        this.simuBinarySensorOff(this.engagedPositionSensors);
        this.carrierController.setPosition(this.carrier.getStoragePosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsAtHandoff() {
        this.simuBinarySensorOff(this.storagePositionSensors);
        this.simuBinarySensorOn(this.handoffPositionSensors);
        this.simuBinarySensorOn(this.engagedPositionSensors);
        this.carrierController.setPosition(this.carrier.getHandoffPosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsAtEngaged() {
        this.simuBinarySensorOff(this.storagePositionSensors);
        this.simuBinarySensorOff(this.handoffPositionSensors);
        this.simuBinarySensorOn(this.engagedPositionSensors);
        this.carrierController.setPosition(this.carrier.getEngagedPosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderCarrierIsInTravel() {
        this.simuBinarySensorOff(this.storagePositionSensors);
        this.simuBinarySensorOff(this.handoffPositionSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateHandoffSensorsAreInError() {
        this.simuRedondantSensorsInError((RedondantSensors)this.handoffPositionSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateStorageSensorsAreInError() {
        this.simuRedondantSensorsInError((RedondantSensors)this.storagePositionSensors);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateClampedStatusSensorIsOn() {
        this.replaceValues(this.clampedStatusSensor, true);
        this.replaceValues(this.unclampedStatusSensor, false);
        this.replaceValues(this.underClampedStatusSensor, false);
        this.replaceValues(this.overClampedStatusSensor, false);
        this.simulateForceSensorsOn();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateUnclampedStatusSensorIsOn() {
        this.replaceValues(this.unclampedStatusSensor, true);
        this.replaceValues(this.clampedStatusSensor, false);
        this.replaceValues(this.underClampedStatusSensor, false);
        this.replaceValues(this.overClampedStatusSensor, false);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateForceSensorsOn() {
        this.simulateForceSensorClamped(this.forceSensor0);
        this.simulateForceSensorClamped(this.forceSensor1);
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateForceSensorsOff() {
        this.simulateForceSensorUnclamped(this.forceSensor0);
        this.simulateForceSensorUnclamped(this.forceSensor1);
    }

    public void simulateForceSensorClamped(ForceSensor forceSensor) {
        this.updateForceSensor(forceSensor, 30);
    }

    public void simulateForceSensorUnclamped(ForceSensor forceSensor) {
        this.updateForceSensor(forceSensor, 10);
    }

    private void updateForceSensor(ForceSensor forceSensor, int voltage) {
        this.readValues[forceSensor.getByteNumero()] = voltage;
    }
}

