/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FilterLocator;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;

public class CarouselMain
extends MainModule
implements FilterLocator {
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Carousel carousel;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FilterManager filterManager;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PersistencyService persistenceService;
    private final boolean loadFilterLocationAtStartup = true;
    private final boolean loadFilterLocationAtShutdown = true;

    public CarouselMain(BridgeToHardware bridge) {
        super(bridge);
    }

    @Override
    public FilterManager getFilterManager() {
        return this.filterManager;
    }

    @Override
    public Carousel getCarousel() {
        return this.carousel;
    }

    @Override
    public PersistencyService getPersistenceService() {
        return this.persistenceService;
    }

    public void init() {
        if (!(this.autochanger instanceof FilterHolder)) {
            String MSG = this.name + " ==> autochanger doesn't implements FilterHolder - Please fix groovy description file or CarouselMainModule implementation.";
            FCSCst.FCSLOG.error((Object)MSG);
            throw new IllegalArgumentException(MSG);
        }
        this.subs.setAgentProperty("org.lsst.ccs.subsystem.fcs.carousel", "carousel");
        this.persistenceService.setAutomatic(true, true);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Update state in reading sensors.", timeout=2000)
    public void updateStateWithSensors() {
        super.updateStateWithSensors();
        this.carousel.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Update FCS state and FCS readyness state and publishes on the status bus.")
    public void updateFCSStateToReady() {
        if (this.carousel.isInitialized()) {
            this.subs.updateAgentState(new Enum[]{FcsEnumerations.FilterState.READY, FcsEnumerations.FilterReadinessState.READY});
        }
    }

    public void postStart() {
        this.checkFiltersLocation();
    }

    public void shutdown() {
        this.saveFilterLocation();
    }
}

