package testbenchAPC

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.description.groovy.CCSBuilder


CCSBuilder builder = ["testbenchAPC2CanBus"]

def loaderTcpProxyName = "loaderTcpProxy" // the name of the tcpProxy

builder.
    main ( APCTestBench2CanBusMain,
    bridge:ref("tcpProxy"),
    bridgeToLoader:ref("loaderTcpProxy"),
    thermometer:ref("thermometer"),
    led:ref("led"),
    fakeLed:ref("fakeLed"),
    fakeSensor:ref("fakeSensor"))

//begin description of Main submodules
{       
    // tcp Proxy
    tcpProxy (CanOpenProxy, hardwareBootTimeout:1000) {
        
        canInterface(FcsTcpProxy, clientName:"TestBench", portNumber:50000, fieldBusTimeout:2000)
        
        // can open devices for changer devices (autochanger and carousel)
        ao412 (CanOpenDAC, nodeID:2, serialNB:"c7c40227")
        
    }//end description of bridge0's children
    
    // Loader tcp Proxy
    loaderTcpProxy (LoaderCanOpenProxy,
        portNumber:51000, fieldBusTimeout:2000,clientName:"TestBench",
        hardwareBootTimeout:1000) {
        
        // can open devices
        ai814 (CanCBXAI814, 
            nodeID:0x3a, serialNB:"c7c50331",transmissionType:1)
        
    }//end description of bridge1's children
    
    // thermometer description 
    thermometer (CanOpenThermometer,adc:ref("ai814"),numOfAnalogInput:1)
    
    // fake Sensor description 
    fakeSensor (CanOpenThermometer,adc:ref("ai814"),numOfAnalogInput:3)
    
    // led description 
    led (CanOpenLED,dac:ref("ao412"),outputNumero:1)
    
    // fake led description 
    fakeLed (CanOpenLED,dac:ref("ao412"),outputNumero:2)
    
}//end description of Main submodules




