package loader

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.description.groovy.CCSBuilder


//********************************************************************************//
//Loader variables
//********************************************************************************//
def bridgeToLoaderName = "loaderTcpProxy" // to monitor the loader sensors
def loaderPlutoGatewayName = "loaderPlutoGateway" // to monitor the loader sensors
//********************************************************************************//

CCSBuilder builder = ["loader-standalone-simu"]

builder.
    main( LoaderMain,bridge:ref("$bridgeToLoaderName")) 
{   //begin description of Loader Main submodules
    
    // tcp Proxy
    "$bridgeToLoaderName" (CanOpenProxy, hardwareBootTimeout:1000) {
        
        canInterface(SimuCanOpenInterface)
        
        // description of plutoGateway
        "$loaderPlutoGatewayName" (SimuLoaderStandalonePlutoGateway, 
            nodeID:1,serialNB:"22d6")
        
        hooksController (SimuLoaderClampController,
            nodeID:0x1b,serialNB:"79007141",
            plutoGateway:ref("$loaderPlutoGatewayName"),
            paramsForCurrent:[
                ContinuousCurrentLimit:3440,
                OutputCurrentLimit:6880,
                MaxSpeedInCurrentMode:2000,
                MotorType:10,PolePairNumber:1,
                PositionSensorType:1],
            paramsForProfilePosition:[
                MinPositionLimit:-300,
                MaxPositionLimit:550000,
                MotionProfileType:0],
            paramsForHoming:[HomeOffset:0]) 
        
        carrierController (SimuLoaderCarrierController,
            nodeID:0x1a,serialNB:"80003184",
            plutoGateway:ref("$loaderPlutoGatewayName"),
            paramsForCurrent:[
                ContinuousCurrentLimit:7290,
                OutputCurrentLimit:14580,
                MaxSpeedInCurrentMode:9840,
                MotorType:10,
                PositionSensorType:4,
                ThermalTimeConstantWinding:187,
                PolePairNumber:1],
            paramsForProfilePosition:[
                MinPositionLimit:-250,
                MaxPositionLimit:1037700,
                MotionProfileType:0,
                MaxFollowingError:6000,
                MaxProfileVelocity:227, 
                ProfileVelocity:120,
                ProfileAcceleration:100,
                ProfileDeceleration:100,
                QuickStopDeceleration:10000],
            paramsForHoming:[
                HomeOffset:0,
                HomingAcceleration:1000,
                CurrentThresholdHomingMode:500])
        
    }//end description of Loader bridge's children
    //----------------------------------------------
    // END Bridge To LOADER description
    //----------------------------------------------

    /**********************************************************************/
    /*                FAKE AUTOCHANGER DESCRIPTION                       */
    /**********************************************************************/
    //in the loader standalone subsystem the fake autochanger is a switch which
    //simulate that autochanger holds a filter at HANDOFF 
    
    autochanger(FakeFilterHolder,plutoGateway:ref("$loaderPlutoGatewayName"),
        holdingFilterSensor:ref("autochangerHoldingFilterSensor"))
    {//begin description of fakeAutochanger's children 
        autochangerHoldingFilterSensor(DigitalSensor ,
            dioName:loaderPlutoGatewayName,inputNumero: 3,byteNumero: 10)
    }//end description of fakeAutochanger's children
    
    /**********************************************************************/
    /*                END of FAKE AUTOCHANGER DESCRIPTION                 */
    /**********************************************************************/

    //begin description of loader
    loader (Loader) {
        //begin description of loader's children
        carrier(LoaderCarrier,
            handoffSensors:ref("loaderHandoffSensors"),
            storageSensors:ref("loaderStorageSensors"),
            engagedSensors:ref("loaderEngagedSensors"),
        )
        {//begin description of loader carrier's children 
            loaderHandoffSensors (RedondantSensors,
                sensor:ref("loaderHandoffPositionSensor0"), 
                sensorR: ref("loaderHandoffPositionSensor1")
            )
            {//begin description of loader handoffSensors
                loaderHandoffPositionSensor0 ( DigitalSensor ,
                    dioName:loaderPlutoGatewayName,inputNumero:6,byteNumero:3)

                loaderHandoffPositionSensor1 ( DigitalSensor ,
                    dioName:loaderPlutoGatewayName,inputNumero:7,byteNumero:3)
            }//end description of loader handoffSensors

            loaderEngagedSensors (RedondantSensors,
                sensor:ref("loaderEngagedPositionSensor0"),
                sensorR:ref("loaderEngagedPositionSensor1"),
            )
            {//begin description of loader storageSensors
                loaderEngagedPositionSensor0 ( DigitalSensor ,
                    dioName:loaderPlutoGatewayName, inputNumero:0,byteNumero:10)

                loaderEngagedPositionSensor1 ( DigitalSensor ,
                    dioName:loaderPlutoGatewayName, inputNumero:1, byteNumero:10)  
            }//end description of loader storageSensors            
            loaderStorageSensors (RedondantSensors,
                sensor:ref("loaderStoragePositionSensor0"),
                sensorR:ref("loaderStoragePositionSensor1"),
            )
            {//begin description of loader storageSensors
                loaderStoragePositionSensor0 ( DigitalSensor ,
                    dioName:loaderPlutoGatewayName, inputNumero:4,byteNumero:3)

                loaderStoragePositionSensor1 ( DigitalSensor ,
                    dioName:loaderPlutoGatewayName, inputNumero:5, byteNumero:3)  
            }//end description of loader storageSensors
        }//end description of loader carrier's children
        
        clamp(LoaderClamp,
            hook1:ref("hook1"),hook2:ref("hook2"),hook3:ref("hook3"),hook4:ref("hook4"),
            forceSensor0:ref("forceSensor0"), forceSensor1:ref("forceSensor1"),
            clampedStatusSensor: ref("clampedStatusSensor"),
            )
        {//begin description of loader clamp's children
           int[] inputNumeroClose = [4,5,6,7];
            int[] inputNumeroOpen = [0,1,2,3];
            for (int i = 1; i<5; i++) {
            
            "hook${i}"(LoaderHook,
                    closeSensor:ref("loaderCloseSensor${i}"), openSensor:ref("loaderOpenSensor${i}"))
                {
                    "loaderCloseSensor${i}" ( DigitalSensor , //closeHookSensor0
                        dioName:loaderPlutoGatewayName, inputNumero:inputNumeroClose[i-1], byteNumero:0)
                       
                    "loaderOpenSensor${i}" ( DigitalSensor , //openHookSensor0
                        dioName:loaderPlutoGatewayName, inputNumero:inputNumeroOpen[i-1], byteNumero:0)
                }
            }
            
            forceSensor0(ForceSensor, deviceName: loaderPlutoGatewayName, byteNumero:4)
            
            forceSensor1(ForceSensor, deviceName: loaderPlutoGatewayName, byteNumero:8)
            
            forceSensorStatus0 ( DigitalSensor ,
                dioName:loaderPlutoGatewayName,inputNumero:2,byteNumero:7)
            
            forceSensorStatus1 ( DigitalSensor ,
                dioName:loaderPlutoGatewayName,inputNumero:3,byteNumero:7)
            
            clampedStatusSensor ( DigitalSensor ,
                dioName:loaderPlutoGatewayName,inputNumero:4,byteNumero:7)
        
        }//end description of loader clamp's children
            
        loaderFilterPresenceSensors (RedondantSensors,
            sensor:ref("loaderFilterPresenceSensor0"),
            sensorR:ref("loaderFilterPresenceSensor1"),
        )
        {
            loaderFilterPresenceSensor0 (DigitalSensor ,
                dioName:loaderPlutoGatewayName,inputNumero:0, byteNumero:3)

            loaderFilterPresenceSensor1 (DigitalSensor ,
                dioName:loaderPlutoGatewayName, inputNumero:1, byteNumero:3) 
        }

        loaderOnCameraSensors (RedondantSensors,
            sensor:ref("loaderOnCameraSensor0"),
            sensorR:ref("loaderOnCameraSensor1"),
        )
        {
            loaderOnCameraSensor0(DigitalSensor ,
                dioName:loaderPlutoGatewayName, inputNumero:2, byteNumero:3)

            loaderOnCameraSensor1(DigitalSensor ,
                dioName:loaderPlutoGatewayName, inputNumero:3, byteNumero:3)
        }
    }//end description of loader's children
    
} //end description of LoaderMain
