/*******************************************************************************/
/*        Description file for the carousel in standalone mode                 */
/*                                                                             */
/*******************************************************************************/


package carouselSimulation

import org.lsst.ccs.subsystems.fcs.*
import org.lsst.ccs.subsystems.fcs.singlefiltertest.*
import org.lsst.ccs.subsystems.fcs.common.*
import org.lsst.ccs.subsystems.fcs.drivers.*
import org.lsst.ccs.subsystems.fcs.simulation.*
import org.lsst.ccs.subsystems.fcs.testbench.*
import org.lsst.ccs.description.groovy.CCSBuilder

/* 
 * carousel positions when a socket is at STANDBY
 * example : socket 1 is at STANDBY when carousel position is -204200
 * */
def standbyPositionSocket = [-204200,-1075906,-1948470,-2821074,-3694258] as int[]

/* numOfAnalogInput on the CANopen device where we read the clamps sensors*/
def numOfAnalogInputFilterPresenceSensorXminus = [1, 2, 3, 4, 5] as int[]
def numOfAnalogInputLockSensorXminus = [6, 7, 8, 9, 10] as int[]
def numOfAnalogInputFilterPresenceSensorXplus = [11, 12, 13, 14, 15] as int[]
def numOfAnalogInputLockSensorXplus = [16, 17, 18, 19, 20] as int[]

////Carousel Can Open Devices (CAN-CBX-AI814) for Carousel brakes status + brakes temperatures
//def adcName = "ai814"

//Carousel CAN OPEN device to read carousel clamp sensors
def caTTC580Name = "hyttc580"

//Carousel clamps controllers name
def clampXminusControllerName = "clampXminusController" //controller to unlock clamp on the side Xminus
def clampXplusControllerName =  "clampXplusController" //controller to unlock clamp on the side Xplus

def plutoGatewayName = "fakePlutoGateway" // to monitor the fake autochanger sensors

CCSBuilder builder = ["carousel-standalone-simu"]

builder.
    main ( CarouselMain, bridge:ref("tcpProxy"), plutoGateway:ref("$plutoGatewayName")) 
{ //begin description of CarouselMain

    tcpProxy (CanOpenProxy, hardwareBootTimeout:2500) {
        
        canInterface(SimuCanOpenInterface)      
        
        clampXminusController (SimuCarouselClampController,
            nodeID:0x1a, serialNB:"79003317",
            paramsForCurrent: [
                MotorType:11, 
                PositionSensorType:3,
                PolePairNumber:8,
                ContinuousCurrentLimit:2360,
                OutputCurrentLimit:4720,
                ThermalTimeConstantWinding:160,
                MaxSpeedInCurrentMode:25],
            paramsForProfilePosition: [MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
        
        clampXplusController (SimuCarouselClampController,
            nodeID:0x1b, serialNB:"79003313",
            paramsForCurrent: [
                MotorType:11, 
                PositionSensorType:3,
                PolePairNumber:8,
                ContinuousCurrentLimit:2360,
                OutputCurrentLimit:4720,
                ThermalTimeConstantWinding:160,
                MaxSpeedInCurrentMode:25],
            paramsForProfilePosition: [MotionProfileType:0],
            paramsForHoming:[HomeOffset:0])
        
        carouselController (SimuCarouselController,
            nodeID:0xc, serialNB:"80003117",
            paramsForCurrent:[
                ContinuousCurrentLimit:9375,
                OutputCurrentLimit:12500,
                MaxSpeedInCurrentMode:5000,
                MotorType:11,PolePairNumber:12,
                PositionSensorType:4],
            paramsForProfilePosition: [
                MinPositionLimit:-2147483648,
                MaxPositionLimit:2147483647,
                MotionProfileType:1, /*0:trapezoidal, 1:sinusoidal*/
                ProfileAcceleration:2000,
                ProfileDeceleration:2000,
                MaxProfileVelocity:5371,
                QuickStopDeceleration:10000],
            paramsForHoming:[HomeOffset:0])
        
        // can open devices to read clamps sensors
        hyttc580 (SimuTTC580, nodeID:0x3, serialNB:"")
        
//        // can open devices to read brakes sensors and temperatures
//        ai814 (SimuCanOpenADC, nodeID:0x1e, serialNB:"", transmissionType:1)
        
        // can open devices to read brakes sensors and temperatures
        pt100 (CanOpenDevice, nodeID:0x1f, serialNB:"")  
        
        // description of plutoGateway 
        //this has to be changed because in carousel we don't have a plutoGateway.
        "$plutoGatewayName" (SimuCarouselStandalonePlutoGateway, nodeID:0x1, serialNB:"22d6")
    } //end of carousel's bridge hardware
    //**************************************************************************//
    // end of Bridge
    //**************************************************************************//
    //-------------------------
    // BEGIN Filter Manager description
    filterManager(FilterManager)
    {//begin description of filter manager's children
        filterU (Filter,filterID:1, weight:38, socketName:"socket1")
        filterG (Filter,filterID:2, weight:33, socketName:"socket2")
        filterR (Filter,filterID:3, weight:30, socketName:"socket3")
        filterI (Filter,filterID:4, weight:28, socketName:"socket4")
        filterZ (Filter,filterID:5, weight:28, socketName:"socket5")
        filterY (Filter,filterID:6, weight:22.5,socketName:"OUT")
        dummyFilter (Filter,filterID:10,weight:44.5,socketName:"OUT")
    }//end description of filter manager's children
    // END Filter Manager description
    // ------------------------------
    
    /**********************************************************************/
    /*                FAKE AUTOCHANGER DESCRIPTION                       */
    /**********************************************************************/
    //in the carousel standalone subsystem the fake autochanger is a switch which
    //simulate that autochanger holds a filter at STANDBY 
    
    autochanger(FakeFilterHolder,plutoGateway: ref("$plutoGatewayName"),
        holdingFilterSensor:ref("autochangerHoldingFilterSensors"),
    )
        {//begin description of fakeAutochanger's children 
           autochangerHoldingFilterSensors (ComplementarySensors,
               sensor:ref("autochangerHoldingFilterSensor0"),
               sensorC:ref("autochangerHoldingFilterSensor1"),
           ) 
           {
                autochangerHoldingFilterSensor0(DigitalSensor ,
                    dioName:plutoGatewayName, inputNumero: 4, byteNumero: 4)
                autochangerHoldingFilterSensor1(DigitalSensor ,
                    dioName:plutoGatewayName, inputNumero: 5, byteNumero: 4)
           }
        }//end description of fakeAutochanger's children

        /**********************************************************************/
        /*                END of FAKE AUTOCHANGER DESCRIPTION                 */
        /**********************************************************************/

        /**********************************************************************/
        /*                BEGIN OF CAROUSEL DESCRIPTION                       */
        /**********************************************************************/

    //----------------------------
    // BEGIN Carousel description
    carousel(Carousel)
    {//begin description of carousel's children
        /*SOCKET1*/
        for (int i = 1; i<6;i++ ) {
            "socket${i}" ( CarouselSocket,
                clampXminus:ref("clampXminus${i}"),
                clampXplus:ref("clampXplus${i}"),
                standbyPosition: standbyPositionSocket[i-1])
            {   
                //-------------------------
                // BEGIN clampXminus description
                "clampXminus${i}" (CarouselClamp,
                    filterPresenceSensor:ref("filterPresenceXminus${i}"),
                    lockSensor:ref("lockSensorXminus${i}"),
//                    thermometer:ref("thermometerXminus${i}")
                ) 
                {
                    "filterPresenceXminus${i}" (CarouselSensor, deviceName: caTTC580Name)
                    
                    "lockSensorXminus${i}" (CarouselSensor, deviceName: caTTC580Name) 
                }
                //-------------------------
                // END clampXminus description
                
                //-------------------------
                // BEGIN clampXplus description
                "clampXplus${i}" (CarouselClamp,
                    filterPresenceSensor:ref("filterPresenceXplus${i}"),
                    lockSensor:ref("lockSensorXplus${i}"),
                )
                {
                    "filterPresenceXplus${i}" (CarouselSensor, deviceName: caTTC580Name)
                    "lockSensorXplus${i}" (CarouselSensor, deviceName: caTTC580Name)
                }
                //-------------------------
                // END clampXplus description
            } // END carouselSocket /*SOCKET1*/ description
        }
    }//end description of carousel's children
    //END Carousel description
    // ------------------------
} // end of CarouselMain description
