###############################################################
# Script to test the real hardware of autochanger
# on autochanger prototype in standalone mode
# Initial Conditions : 
#   autochanger loaded with a filter, latches closed, trucks at ONLINE position
# Sequence of actions:
# - unlockAndOpenClamps
# - moveToAbsoluteTargetPosition 900000
# - moveAndClampFilterOnline
###############################################################
from org.lsst.ccs.scripting import CCS
from java.lang import Exception
from org.lsst.ccs.command import *
from time import sleep
#import datetime


#####################################################################
### change iteration number / nombre d'iterations a changer si besoin est
iter = int(2)
#####################################################################
waitTime = int(0)

CCS.setThrowExceptions(True)

#####################################################################
# launch autochanger-standalone subsystem and initialize
#####################################################################
acSubsName="autochanger-standalone"
autochangerStandalone = CCS.attachSubsystem(acSubsName)

print "Connected to autochanger-standalone=> ", autochangerStandalone

ccsVersion= autochangerStandalone.synchCommandLine(5,"getCCSVersions")
print "TESTS of autochanger sequence1 with CCS version number"
print ccsVersion.getResult()

#tcpProxy
tcpProxy = CCS.attachSubsystem(acSubsName + "/tcpProxy")

result = tcpProxy.synchCommandLine(5, "allDevicesBooted")
if result.getResult():
    print "allDevicesBooted", result.getResult()
else:
    print "not all hardware boooted"
#    raise Exception("CANopen Hardware not ready")

###plutoGateway
plutoGateway = CCS.attachSubsystem(acSubsName + "/acSensorsGateway")

###autochanger
autochanger = CCS.attachSubsystem(acSubsName + "/autochanger")

###autochangerTrucks
autochangerTrucks = CCS.attachSubsystem(acSubsName + "/autochangerTrucks")

###onlineClamps
onlineClamps = CCS.attachSubsystem(acSubsName + "/onlineClamps")

###latches
latches = CCS.attachSubsystem(acSubsName + "/latches")

####getting timeouts
autochangerConfigFuture = autochangerStandalone.asynchCommandLine("getConfigurationInfo")
print "getting loader configuration info"
autochangerConfig = autochangerConfigFuture.get()
timeoutForLockingClamps = autochangerConfig.getCurrentValueForParameter("onlineClamps//timeoutForLockingClamps")
timeoutForTrucksMotion = autochangerConfig.getCurrentValueForParameter("autochangerTrucks//timeoutForTrucksMotion")

####getting welknown positions

standbyPosition = int((autochangerTrucks.synchCommandLine(5, "getStandbyPosition")).getResult())
print "STANDBY position=", standbyPosition

handoffPosition = int((autochangerTrucks.synchCommandLine(5, "getHandoffPosition")).getResult())
print "HANDOFF position = ", handoffPosition

onlinePosition = int((autochangerTrucks.synchCommandLine(5, "getOnlinePosition")).getResult())
print "ONLINE position =", onlinePosition

############################################################################
# Check controllers and plutoGateway are READY
############################################################################
#hardware is READY 
#print "Check that controllers and plutoGateway are initialized...."
if plutoGateway.synchCommandLine(5, "isInitialized").getResult():
    print "plutoGateway.isInitialized()=", result.getResult()
else:
    raise Exception("plutoGateway not Ready")


#Read of the linearRailSlaveController mode
slaveCtl = CCS.attachSubsystem(acSubsName + "/linearRailSlaveController")
slaveMode = slaveCtl.synchCommandLine(5, "readMode")
print "Slave Controller Mode =", slaveMode.getResult()

#Read of the linearRailMasterController mode
masterCtl = CCS.attachSubsystem(acSubsName + "/linearRailMasterController")
masterMode = masterCtl.synchCommandLine(5, "readMode")
print "Master Controller Mode =", masterMode.getResult()

if slaveCtl.synchCommandLine(5, "isInitialized").getResult():
    print "linearRailSlaveController.isInitialized()=", result.getResult()
else:
    raise Exception("linearRailSlaveController not initialized")

if masterCtl.synchCommandLine(5, "isInitialized").getResult():
    print "linearRailMasterController.isInitialized()=", result.getResult()
else:
    raise Exception("linearRailMasterController not initialized")

if str(masterMode.getResult()) != 'PROFILE_POSITION' :
   #  raise Exception("ERROR on master Controller mode")
   print "ERROR on master Controller mode - have to change it."
   result = masterCtl.synchCommandLine(5, "changeMode PROFILE_POSITION")
else:
   print "master Controller is in mode", masterMode.getResult()

if str(slaveMode.getResult()) != 'MASTER_ENCODER' :
   #  raise Exception("ERROR on slave Controller mode")
   print "ERROR on slave Controller mode - have to change it."
   result = slaveCtl.synchCommandLine(5,"changeMode MASTER_ENCODER")
else:
   print "slave Controller is in mode", slaveMode.getResult()


######################################################################
# check that initial conditions are OK
######################################################################
#not empty, latches locked, onlineClamps clamped

#autochanger is loaded with a filter
if autochanger.synchCommandLine(5, "isEmpty").getResult():
    raise Exception("autochanger empty : can't execute autochangerSequence1")
else:
    print "autochanger loaded with a filter : OK"

#autochanger latches are CLOSED.
if latches.synchCommandLine(5, "isClosed").getResult():
    print "autochanger latches CLOSED : OK"
else:
    raise Exception("autochanger not closed : can't execute autochangerSequence1")
    
#autochanger onlineClamps are LOCKED.
if onlineClamps.synchCommandLine(5, "isLocked").getResult():
    print "autochanger onlineClamps LOCKED : OK"
else:
    raise Exception("autochanger online clamps not LOCKED : can't execute autochangerSequence1")

######################################################################
# Move Trucks to ONLINE position if trucks are not already at ONLINE
######################################################################

position = int((masterCtl.synchCommandLine(5, "readPosition")).getResult())
print "INITIAL POSITION Position =", position
if autochangerTrucks.synchCommandLine(5, "isAtOnline").getResult():
    print "autochanger is at ONLINE"
else:
    print "Going to INITIAL position ONLINE"
    autochangerTrucks.synchCommandLine(10000,"moveAndClampFilterOnline")
    position = int((masterCtl.synchCommandLine(5, "readPosition")).getResult())
    print "Position=", position
    sleep(waitTime)
    print "END OF GOING TO INITIAL POSITION"

#####################################################################
# loop to move the trucks from ONLINE to 900000, and back
#####################################################################

for i in range(iter):
    print "==> ITERATION number", i
    print "Unlocking and opening ONLINE clamps ..."
    onlineClamps.synchCommandLine(int(timeoutForLockingClamps), "unlockAndOpenClamps")
    print "Sleeping", waitTime, "....."
    sleep(waitTime)
    print "moving To Absolute TargetPosition 900000 ..."
    autochangerTrucks.synchCommandLine(10000,"moveToAbsoluteTargetPosition 900000")
    position = int((masterCtl.synchCommandLine(5, "readPosition")).getResult())
    print "Position =", position
    
    print "Executing command moveAndClampFilterOnline ..."    
    autochangerTrucks.synchCommandLine(10000,"moveAndClampFilterOnline")
    position = int((masterCtl.synchCommandLine(5, "readPosition")).getResult())
    print "Position =", position
    lockStatus = onlineClamps.synchCommandLine(5, getLockStatus()).getResult()
    print "onlineClamps lockStatus = ", lockStatus
    print "Sleeping", waitTime, "s....."
    sleep(waitTime)
    print "==> end ITERATION number", i

print "END LOOP"

##################################END##################################






