/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.AlertService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderCarrier;
import org.lsst.ccs.subsystems.fcs.LoaderClamp;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.RedondantSensors;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.common.AlertRaiser;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.common.FilterHolder;
import org.lsst.ccs.subsystems.fcs.common.PlutoGatewayInterface;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;

public class Loader
implements HardwareController,
FilterHolder,
AlertRaiser,
HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem s;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private LoaderCarrier carrier;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private LoaderClamp clamp;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private BridgeToHardware loaderTcpProxy;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MainModule main;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private FilterHolder autochanger;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private RedondantSensors loaderFilterPresenceSensors;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private RedondantSensors loaderOnCameraSensors;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private PlutoGatewayInterface loaderPlutoGateway;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private EPOSController hooksController;
    @LookupField(strategy=LookupField.Strategy.BYNAME)
    private EPOSController carrierController;
    private final Lock lock = new ReentrantLock();
    private final Condition stateUpdated = this.lock.newCondition();
    private volatile boolean updatingState = false;

    @Override
    public AlertService getAlertService() {
        return this.alertService;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Subsystem getSubsystem() {
        return this.s;
    }

    public LoaderCarrier getCarrier() {
        return this.carrier;
    }

    public LoaderClamp getClamp() {
        return this.clamp;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if hardware (controllers and plutoGateway) is correctly initializedand homing of the controllers is done.")
    public boolean isInitialized() {
        boolean devicesInitialized = this.loaderPlutoGateway.isInitialized() && this.hooksController.isInitialized() && this.carrierController.isInitialized();
        return devicesInitialized && this.clamp.isHomingDone() && this.carrier.isInitialized();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if there is no filter in the loader. This command doesn't read again the sensors.")
    public boolean isEmpty() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.name + ": has been interrupted while waiting for end of update."), (Throwable)ex);
                }
            }
            boolean bl = !this.loaderFilterPresenceSensors.isOn();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the loader is connected on the camera. This command doesn't read again the sensors.")
    public boolean isConnectedOnCamera() {
        this.lock.lock();
        try {
            while (this.updatingState) {
                try {
                    this.stateUpdated.await();
                }
                catch (InterruptedException ex) {
                    FCSCst.FCSLOG.error((Object)(this.name + ": has been interrupted while waiting for end of update."), (Throwable)ex);
                }
            }
            boolean bl = this.loaderOnCameraSensors.isOn();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if the autochanger is holding the filter. This command doesn't read again the sensors.")
    public boolean isAutochangerHoldingFilter() {
        return this.autochanger.isHoldingFilter();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Return true if a filter is present and it is held by the loader clamp.")
    public boolean isHoldingFilter() {
        this.updateStateWithSensors();
        this.clamp.updatePosition();
        return this.clamp.isClamped() && !this.isEmpty();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Attention ! this commands does the homing of the controllers and might move hardware. Initialize loader hardware.", alias="homing")
    public void locateHardware() {
        boolean devicesInitialized;
        this.carrier.initializeHardware();
        boolean bl = devicesInitialized = this.loaderPlutoGateway.isInitialized() && this.hooksController.isInitialized() && this.carrierController.isInitialized();
        if (!devicesInitialized) {
            throw new FailedCommandException(this.name + " couldn't locate hardware because devices are not initialized.");
        }
        this.updateStateAndCheckSensors();
        this.checkClosedOnVoid();
        if (this.isEmpty()) {
            this.clamp.open();
        } else if (this.carrier.isAtHandoff() && this.autochanger.isHoldingFilter()) {
            this.clamp.open();
        } else if (!this.clamp.isClamped()) {
            this.clamp.clamp();
        }
        this.updateFCSStateToReady();
    }

    public void checkClosedOnVoid() {
        if (this.isEmpty() && this.clamp.isClosed()) {
            String msg = this.name + ": carrier is empty and clamp is CLOSED - can't start.";
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, msg, this.name);
            throw new FcsHardwareException(msg);
        }
    }

    public void checkHaltRequired() {
        if (this.main.isHaltRequired() || this.main.isStopRequired()) {
            throw new FailedCommandException(this.name + ": received HALT or STOP command.");
        }
    }

    public void postStart() {
        if (this.loaderPlutoGateway.isBooted()) {
            this.initializeGateway();
        } else {
            this.loaderPlutoGateway.raiseAlarmIfMissing();
        }
    }

    public void initializeGateway() {
        try {
            this.loaderPlutoGateway.initializeAndCheckHardware();
            this.updateStateWithSensors();
        }
        catch (FcsHardwareException ex) {
            this.raiseAlarm(FcsEnumerations.FcsAlert.HARDWARE_ERROR, " could not initialize loaderPlutoGateway", (Exception)((Object)ex));
        }
    }

    public void checkStarted() {
        FCSCst.FCSLOG.info((Object)(this.name + " BEGIN checkStarted"));
        this.initializeGateway();
        FCSCst.FCSLOG.info((Object)(this.name + " END checkStarted"));
    }

    public void checkConnectedOnCamera() {
        if (!this.isConnectedOnCamera()) {
            throw new RejectedCommandException(this.name + " Loader not connected - can't execute commands.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the carrier can move.")
    public void checkConditionsForCarrierMotion(int targetPosition) {
        FCSCst.FCSLOG.info((Object)(this.name + " checking pre-conditions for carrier motion"));
        this.updateStateAndCheckSensors();
        this.checkClosedOnVoid();
        this.carrier.updatePosition();
        if (this.isEmpty()) {
            FCSCst.FCSLOG.info((Object)(this.name + " no filter. Carrier can move."));
        } else {
            if (this.carrier.isAtHandoff() && this.isAutochangerHoldingFilter() && (this.clamp.isClamped() || this.clamp.isClosed())) {
                throw new RejectedCommandException(this.name + " carrier can't move because a filter is in the loader and it's held by loader AND autochanger.");
            }
            if (targetPosition <= this.carrier.getEngagedPosition() && this.carrier.getPosition() < this.carrier.getEngagedPosition() + 10) {
                this.clamp.checkClamped();
            } else if (targetPosition >= this.carrier.getEngagedPosition() && this.carrier.getPosition() > this.carrier.getEngagedPosition() - 10) {
                this.clamp.checkUnclamped();
            } else if (this.carrier.isAtHandoff() && this.clamp.isOpened()) {
                FCSCst.FCSLOG.info((Object)(this.name + " carrier can move empty to targetPosition=" + targetPosition));
            } else {
                throw new RejectedCommandException("Carrier has to stop first at ENGAGED position");
            }
        }
    }

    @Deprecated
    private void checkFilterSafetyAtHandoff() {
        if (!this.isAutochangerHoldingFilter() && this.clamp.isOpened()) {
            throw new RejectedCommandException(this.name + " carrier can't move because the filter in the loader is not held neither by loader neither by autochanger. Close loader clamp or autochanger latches. ");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the clamp can be opened.")
    public void checkConditionsForOpeningHooks() {
        FCSCst.FCSLOG.info((Object)(this.name + " checking pre-conditions for opening hooks"));
        this.updateStateAndCheckSensors();
        if (!this.isEmpty()) {
            if (!this.carrier.isAtHandoff()) {
                String msg = this.name + ": carrier is loaded with a filter but not at handoff position - can't open clamp.";
                FCSCst.FCSLOG.error((Object)msg);
                throw new RejectedCommandException(msg);
            }
            if (!this.isAutochangerHoldingFilter()) {
                String msg = this.name + ": A filter is in the loader but not held by autochanger - can't open clamp.";
                FCSCst.FCSLOG.error((Object)msg);
                throw new RejectedCommandException(msg);
            }
        }
    }

    public void checkConditionsForUnclampingHooks() {
        if (!this.carrier.isAtEngaged()) {
            String msg = this.name + ": carrier is loaded with a filter but not at ENGAGED position - can't unclamp.";
            FCSCst.FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
        if (this.isAutochangerHoldingFilter()) {
            throw new RejectedCommandException(this.name + " Autochanger is holding filter. Can't unclamp Loader Clamp.");
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Check if the clamp can be closed.")
    public void checkLoaderNotEmpty() {
        FCSCst.FCSLOG.info((Object)(this.name + " checking pre-conditions for closing hooks"));
        this.updateStateAndCheckSensors();
        this.clamp.updatePosition();
        if (this.isEmpty()) {
            String msg = this.name + ": no filter in loader - can't execute close nor clamp command." + this.clamp.getName();
            FCSCst.FCSLOG.error((Object)msg);
            throw new RejectedCommandException(msg);
        }
    }

    public void updateStateAndCheckSensors() {
        this.updateStateWithSensors();
        this.autochanger.updateStateWithSensors();
        this.checkConnectedOnCamera();
        this.clamp.checkInitialized();
        this.clamp.checkSensors(FcsEnumerations.FcsAlert.LO_SENSOR_ERROR, this.clamp.getName());
        this.carrier.checkSensors(FcsEnumerations.FcsAlert.LO_SENSOR_ERROR, this.carrier.getName());
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Update clamp state in reading sensors.")
    public void updateStateWithSensors() {
        this.loaderPlutoGateway.checkBooted();
        this.loaderPlutoGateway.checkInitialized();
        this.lock.lock();
        try {
            this.updatingState = true;
            this.loaderPlutoGateway.updateValues();
            this.clamp.updateState();
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
            this.publishData();
            this.clamp.publishData();
            this.carrier.publishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update FCS state and FCS readyness state and publishes on the status bus.")
    public void updateFCSStateToReady() {
        if (this.clamp.isHomingDone() && this.carrier.isInitialized()) {
            this.main.updateFCSStateToReady();
        }
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Move a filter from STORAGE to HANDOFF. This command executes sequence of actions :\n- check initial conditions (a filter, at STORAGE) \n- move carrier to ENGAGED with high speed\n- unclamp filter \n- move slowly filter to HANDOFF. ")
    public void moveFilterToHandoff() {
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.name + " is empty. Command moveFilterToHandoff is not relevant.");
        }
        if (!this.carrier.isAtStorage()) {
            throw new RejectedCommandException(this.name + " is not at STORAGE. Command moveFilterToHandoff is not relevant.");
        }
        this.carrier.raiseProfileVelocity();
        this.carrier.goToEngaged();
        this.clamp.unclamp();
        this.carrier.slowProfileVelocity();
        this.carrier.goToHandOff();
    }

    @Command(type=Command.CommandType.ACTION, level=1)
    public void moveFilterToStorage() {
        if (this.isEmpty()) {
            throw new RejectedCommandException(this.name + " is empty. Command moveFilterToStorage is not relevant.");
        }
        if (!this.carrier.isAtHandoff()) {
            throw new RejectedCommandException(this.name + " is not at HANDOFF. Command moveFilterToStorage is not relevant.");
        }
        if (!this.clamp.isClosed()) {
            throw new RejectedCommandException(this.name + " clamp is not CLOSED. Command moveFilterToStorage is not relevant.");
        }
        this.carrier.slowProfileVelocity();
        this.carrier.goToEngaged();
        this.clamp.clamp();
        this.carrier.raiseProfileVelocity();
        this.carrier.goToStorage();
    }

    public StatusDataPublishedByLoader createStatusDataPublishedByLoader() {
        StatusDataPublishedByLoader status = new StatusDataPublishedByLoader();
        status.setName(this.name);
        status.setFilterPresenceSensorValue(this.loaderFilterPresenceSensors.isOn());
        status.setFilterPresenceSensorsInError(this.loaderFilterPresenceSensors.isInError());
        status.setLoaderOnCameraSensorValue(this.loaderOnCameraSensors.isOn());
        status.setLoaderOnCameraSensorsInError(this.loaderOnCameraSensors.isInError());
        return status;
    }

    public void publishData() {
        StatusDataPublishedByLoader status = this.createStatusDataPublishedByLoader();
        KeyValueData kvd = new KeyValueData("loaderGeneral", (Serializable)status);
        this.s.publishSubsystemDataOnStatusBus(kvd);
    }

    @Override
    public boolean isAtHandoff() {
        return this.carrier.isAtHandoff();
    }

    @Override
    public boolean isAtStandby() {
        return false;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Print list of hardware with initialization information.")
    public String printHardwareState() {
        StringBuilder sb = new StringBuilder(this.carrier.printHardwareState());
        sb.append("\n");
        sb.append(this.clamp.printHardwareState());
        return sb.toString();
    }
}

