/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.utils;

import java.security.SecureRandom;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.utils.CWrapperUtils;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class FcsUtilsTest
extends CcsTestCaseTemplate {
    private final SecureRandom randomGenerator = new SecureRandom();
    private static final String nodeID1 = "24A";
    private static final String nodeID2 = "02F4A";
    private static final String nodeID3 = "3";

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testTwoBytesInHexaToBinary() {
        System.out.println("twoBytesInHexaToBinary");
        String twoBytesInHexa = "4";
        String expResult = "0000000000000100";
        String result = FcsUtils.twoBytesInHexaToBinary((String)twoBytesInHexa);
        Assert.assertEquals((Object)expResult, (Object)result);
        twoBytesInHexa = "AA";
        expResult = "0000000010101010";
        result = FcsUtils.twoBytesInHexaToBinary((String)twoBytesInHexa);
        Assert.assertEquals((Object)expResult, (Object)result);
        twoBytesInHexa = "F0F0";
        expResult = "1111000011110000";
        result = FcsUtils.twoBytesInHexaToBinary((String)twoBytesInHexa);
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testForce2zero() {
        System.out.println("force2zero");
        Assert.assertEquals((long)32767L, (long)FcsUtils.force2zero((int)65535, (int)15));
        Assert.assertEquals((long)0L, (long)FcsUtils.force2zero((int)0, (int)15));
        Assert.assertEquals((long)0L, (long)FcsUtils.force2zero((int)0, (int)15));
        Assert.assertEquals((long)255L, (long)FcsUtils.force2zero((int)255, (int)15));
        Assert.assertEquals((long)255L, (long)FcsUtils.force2zero((int)255, (int)15));
        Assert.assertEquals((long)32767L, (long)FcsUtils.force2zero((int)Short.MAX_VALUE, (int)15));
        Assert.assertEquals((long)12287L, (long)FcsUtils.force2zero((int)45055, (int)15));
        Assert.assertEquals((long)32512L, (long)FcsUtils.force2zero((int)65280, (int)15));
        Assert.assertEquals((long)65280L, (long)FcsUtils.force2zero((int)65281, (int)0));
        for (int bit = 0; bit < 15; ++bit) {
            Assert.assertEquals((long)0L, (long)FcsUtils.force2zero((int)0, (int)bit));
        }
        Assert.assertEquals((long)0L, (long)FcsUtils.force2zero((int)1, (int)0));
        Assert.assertEquals((String)"UNE.force2zero(1)=3", (long)1L, (long)FcsUtils.force2zero((int)1, (int)1));
        Assert.assertEquals((long)2L, (long)FcsUtils.force2zero((int)2, (int)0));
        Assert.assertEquals((String)"DEUX.force2zero(1)=0", (long)0L, (long)FcsUtils.force2zero((int)2, (int)1));
    }

    @Test
    public void testForce2one() {
        int bit;
        System.out.println("force2one");
        Assert.assertEquals((long)65535L, (long)FcsUtils.force2one((int)65535, (int)15));
        Assert.assertEquals((long)32768L, (long)FcsUtils.force2one((int)0, (int)15));
        Assert.assertEquals((long)33023L, (long)FcsUtils.force2one((int)255, (int)15));
        Assert.assertEquals((long)65535L, (long)FcsUtils.force2one((int)Short.MAX_VALUE, (int)15));
        Assert.assertEquals((long)45055L, (long)FcsUtils.force2one((int)45055, (int)15));
        Assert.assertEquals((long)65280L, (long)FcsUtils.force2one((int)65280, (int)15));
        Assert.assertEquals((long)1L, (long)FcsUtils.force2one((int)0, (int)0));
        Assert.assertEquals((long)65281L, (long)FcsUtils.force2one((int)65280, (int)0));
        for (bit = 0; bit < 15; ++bit) {
            Assert.assertEquals((long)65535L, (long)FcsUtils.force2one((int)65535, (int)bit));
        }
        for (bit = 0; bit < 15; ++bit) {
            Assert.assertEquals((String)"FcsUtils.force2one(ZERO,bit) = 2**bit", (long)(1 << bit), (long)FcsUtils.force2one((int)0, (int)bit));
        }
        Assert.assertEquals((long)1L, (long)FcsUtils.force2one((int)1, (int)0));
        Assert.assertEquals((String)"UNE.force2one(1)=3", (long)3L, (long)FcsUtils.force2one((int)1, (int)1));
        Assert.assertEquals((String)"UNE.force2one(2)=3", (long)5L, (long)FcsUtils.force2one((int)1, (int)2));
        Assert.assertEquals((long)3L, (long)FcsUtils.force2one((int)2, (int)0));
        Assert.assertEquals((String)"DEUX.force2one(1)=2", (long)2L, (long)FcsUtils.force2one((int)2, (int)1));
        Assert.assertEquals((String)"DEUX.force2one(2)=6", (long)6L, (long)FcsUtils.force2one((int)2, (int)2));
        System.out.println("test AFFF.force2one");
        for (bit = 0; bit < 15; ++bit) {
            if (bit == 12) {
                Assert.assertEquals((long)49151L, (long)FcsUtils.force2one((int)45055, (int)bit));
                continue;
            }
            if (bit == 14) {
                Assert.assertEquals((long)61439L, (long)FcsUtils.force2one((int)45055, (int)bit));
                continue;
            }
            Assert.assertEquals((long)45055L, (long)FcsUtils.force2one((int)45055, (int)bit));
        }
    }

    @Test
    public void testBuildWsdoCommand() {
        System.out.println("buildWsdoCommand");
        int nodeID = 48;
        int index = 4099;
        int subindex = 64;
        int size = 2;
        int data = 3968;
        String expResult = "wsdo,30,1003,40,2,f80";
        String result = CWrapperUtils.buildWsdoCommand((int)nodeID, (int)index, (int)subindex, (int)size, (long)data);
        Assert.assertEquals((String)("buildWsdoCommand(nodeID,index,subindex,size,data) must be=" + expResult), (Object)expResult, (Object)result);
        data = 300;
        expResult = "wsdo,30,1003,40,2,12c";
        result = CWrapperUtils.buildWsdoCommand((int)nodeID, (int)index, (int)subindex, (int)size, (long)data);
        Assert.assertEquals((String)("buildWsdoCommand(nodeID,index,subindex,size,data) must be=" + expResult), (Object)expResult, (Object)result);
    }

    @Test
    public void testCheckCanOpenCommand() {
        String msgInvalid = "- An IllegalArgumentException should have been raised.";
        String msgExcRaised = "- IllegalArgumentException is raised with message: ";
        String msgValid = " is a valid CANopen command.";
        System.out.println("#checkCanOpenCommand");
        String command = null;
        try {
            CWrapperUtils.checkCommand(command);
            Assert.fail((String)("null command " + msgInvalid));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("null command " + msgExcRaised + ex);
        }
        try {
            command = "";
            CWrapperUtils.checkCommand((String)command);
            Assert.fail((String)("empty command " + msgInvalid));
        }
        catch (IllegalArgumentException ex) {
            System.out.println("empty command " + msgExcRaised + ex);
        }
        try {
            command = "toto";
            CWrapperUtils.checkCommand((String)command);
            Assert.fail((String)(command + msgInvalid));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(command + msgExcRaised + ex);
        }
        try {
            command = "coucou,toto";
            CWrapperUtils.checkCommand((String)command);
            Assert.fail((String)(command + msgInvalid));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(command + msgExcRaised + ex);
        }
        try {
            command = "sync";
            CWrapperUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
        try {
            command = "scan";
            CWrapperUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
        try {
            command = "quit";
            CWrapperUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
        try {
            command = "info,24A";
            CWrapperUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
        try {
            command = "reset,02F4A";
            CWrapperUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
        try {
            command = "rsdo,3,1002,20";
            CWrapperUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
        try {
            command = "wsdo,3,1002,20,2,56478";
            CWrapperUtils.checkCommand((String)command);
            System.out.println(command + msgValid);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)(command + " is a valid CANopen command." + ex));
        }
    }

    @Test
    public void testBuildRsdoCommand() {
        System.out.println("buildRsdoCommand");
        int nodeID = 48;
        int index = 4099;
        int subindex = 1;
        String expResult = "rsdo,30,1003,1";
        String result = CWrapperUtils.buildRsdoCommand((int)nodeID, (int)index, (int)subindex);
        Assert.assertEquals((String)("buildRsdoCommand(nodeID,index,subindex) must be=" + expResult), (Object)expResult, (Object)result);
    }

    @Test
    public void testCheckSocketName() {
        System.out.println("checkSocketName");
        String msg = "is a valid socket name - should NOT have raised exception:";
        String name = "";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("empty name " + msg + ex));
        }
        name = "AC";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("AC" + msg + ex));
        }
        name = "socket1";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("empty name " + msg + ex));
        }
        name = "socket2";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("empty name " + msg + ex));
        }
        name = "socket5";
        try {
            FcsUtils.checkSocketName((String)name);
        }
        catch (Exception ex) {
            Assert.fail((String)("empty name " + msg + ex));
        }
        msg = " is an invalid socket name - IllegalArgumentException should be raised.";
        name = "COUCOU";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "1";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socket12";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socketb";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socketBidon";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socket0";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
        name = "socket6";
        try {
            FcsUtils.checkSocketName((String)name);
            Assert.fail((String)(name + msg));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(ex);
        }
    }

    @Test
    public void testCreateStatusDataPublishedByHardware() throws Exception {
        System.out.println("createStatusDataPublishedByHardware");
        Subsystem s = BootUtils.getSubsystemFromFile((String)"testFcsUtils");
        PieceOfHardware device = (PieceOfHardware)s.getComponentLookup().getComponentByName("device");
        StatusDataPublishedByHardware result = device.createStatusDataPublishedByHardware();
        result.setBooted(true);
        Assert.assertTrue((String)"device is booted", (boolean)result.isBooted());
        String expResult = "device/isBooted=true/isInitialized=false";
        Assert.assertEquals((String)"device status=", (Object)expResult, (Object)result.toString());
    }

    @Test
    public void testToReverseBinary() {
        int i;
        System.out.println("toReverseBinary");
        int decimal = 0;
        int[] expResult = new int[16];
        for (int i2 = 0; i2 < expResult.length; ++i2) {
            expResult[i2] = 0;
        }
        int[] result = FcsUtils.toReverseBinary((int)decimal);
        Assert.assertArrayEquals((String)"0 reste 0", (int[])expResult, (int[])result);
        decimal = 1;
        expResult = new int[16];
        expResult[0] = 1;
        for (i = 1; i < expResult.length; ++i) {
            expResult[i] = 0;
        }
        result = FcsUtils.toReverseBinary((int)decimal);
        Assert.assertArrayEquals((String)"1 devient 1000000000000000", (int[])expResult, (int[])result);
        decimal = 2;
        expResult = new int[16];
        expResult[0] = 0;
        expResult[1] = 1;
        for (i = 2; i < expResult.length; ++i) {
            expResult[i] = 0;
        }
        result = FcsUtils.toReverseBinary((int)decimal);
        Assert.assertArrayEquals((String)"2 devient 0100000000000000", (int[])expResult, (int[])result);
    }

    @Test
    public void testConvertToInteger8() {
        System.out.println("** convertToInteger8");
        long unsigned8 = 0L;
        int expResult = 0;
        byte result = FcsUtils.convertToInteger8((long)unsigned8);
        Assert.assertEquals((String)"UNSIGNED8=0 =>INTEGER8=0", (long)expResult, (long)result);
        unsigned8 = 255L;
        expResult = -1;
        result = FcsUtils.convertToInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 255L;
        expResult = -1;
        result = FcsUtils.convertToInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 127L;
        expResult = 127;
        result = FcsUtils.convertToInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 128L;
        expResult = -128;
        result = FcsUtils.convertToInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 129L;
        expResult = -127;
        result = FcsUtils.convertToInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 254L;
        expResult = -2;
        result = FcsUtils.convertToInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 253L;
        expResult = -3;
        result = FcsUtils.convertToInteger8((long)unsigned8);
        Assert.assertEquals((String)("UNSIGNED8=" + unsigned8 + " =>INTEGER8=" + expResult), (long)expResult, (long)result);
        unsigned8 = 65535L;
        try {
            FcsUtils.convertToInteger8((long)unsigned8);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("FcsUtils.convertToInteger8(0xFFFF) should fail. exception=" + ex);
        }
        unsigned8 = 256L;
        try {
            FcsUtils.convertToInteger8((long)unsigned8);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("FcsUtils.convertToInteger8(256) should fail. exception=" + ex);
        }
    }

    @Test
    public void testConvertToInteger16() {
        System.out.println("** convertToInteger16");
        long unsigned16 = 0L;
        int expResult = 0;
        short result = FcsUtils.convertToInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=0 =>INTEGER16=0", (long)expResult, (long)result);
        unsigned16 = 2356L;
        expResult = 2356;
        result = FcsUtils.convertToInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=2356 =>INTEGER16=2356", (long)expResult, (long)result);
        unsigned16 = 65342L;
        expResult = -194;
        result = FcsUtils.convertToInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=65342 =>INTEGER16=-194", (long)expResult, (long)result);
        unsigned16 = 32767L;
        expResult = Short.MAX_VALUE;
        result = FcsUtils.convertToInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=32767 =>INTEGER16=32767", (long)expResult, (long)result);
        unsigned16 = 32768L;
        expResult = Short.MIN_VALUE;
        result = FcsUtils.convertToInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=32768 =>INTEGER16=-32768", (long)expResult, (long)result);
        unsigned16 = 65535L;
        expResult = -1;
        result = FcsUtils.convertToInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=65535 =>INTEGER16=-1", (long)expResult, (long)result);
        unsigned16 = 65535L;
        expResult = -1;
        result = FcsUtils.convertToInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=0xFFFF =>INTEGER16=-1", (long)expResult, (long)result);
        unsigned16 = -400L;
        expResult = -400;
        result = FcsUtils.convertToInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=-400 =>INTEGER16=-400", (long)expResult, (long)result);
        unsigned16 = -20L;
        expResult = -20;
        result = FcsUtils.convertToInteger16((long)unsigned16);
        Assert.assertEquals((String)"UNSIGNED16=-400 =>INTEGER16=-400", (long)expResult, (long)result);
        unsigned16 = 0xFFFFFFL;
        try {
            FcsUtils.convertToInteger16((long)unsigned16);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("FcsUtils.convertToInteger16(0xFFFFFF) should fail. exception=" + ex);
        }
        unsigned16 = 65536L;
        try {
            FcsUtils.convertToInteger16((long)unsigned16);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("FcsUtils.convertToInteger16(65536) should fail. exception=" + ex);
        }
    }

    @Test
    public void testComputeNewCurrentValue() {
        System.out.println("**computeNewCurrentValue");
        int stepHeight = 100;
        int currentValue = 200;
        int finalValue = 400;
        int expResult = 300;
        int result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        currentValue = 300;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        currentValue = 400;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        currentValue = 350;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        currentValue = 450;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        currentValue = 10000;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        finalValue = -500;
        currentValue = -1000;
        expResult = -900;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        currentValue = -600;
        expResult = finalValue;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going up", (long)expResult, (long)result);
        stepHeight = -100;
        finalValue = 400;
        currentValue = 700;
        expResult = 600;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going down", (long)expResult, (long)result);
        currentValue = 200;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going down", (long)expResult, (long)result);
        currentValue = 450;
        expResult = 400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going down", (long)expResult, (long)result);
        finalValue = -500;
        currentValue = -700;
        expResult = -500;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going down", (long)expResult, (long)result);
        currentValue = -300;
        expResult = -400;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going down", (long)expResult, (long)result);
        currentValue = -500;
        expResult = -500;
        result = FcsUtils.computeNewCurrentValue((int)stepHeight, (int)currentValue, (int)finalValue);
        Assert.assertEquals((String)"going down", (long)expResult, (long)result);
    }
}

