/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.subsystems.fcs.Carousel;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.CarouselMain;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FilterManager;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenADC;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClampLockSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselStandalonePlutoGateway;

public class SftCarouselToto
extends CcsTestCaseTemplate {
    private static Subsystem carouselSubsystem = null;
    private static CarouselMain main;
    private static Carousel carousel;
    private static SimuCarouselController carouselController;
    private static SimuCarouselStandalonePlutoGateway plutoGateway;
    private static SimuCanOpenADC ai814;
    private static FilterManager filterManager;
    private static ComponentLookup lookup;
    private static int socket1StandbyPos;

    public SftCarouselToto() {
        socket1StandbyPos = carousel.getSocketByName("socket1").getStandbyPosition();
    }

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("********************************************************************************");
        System.out.println("                   TESTS OF SFT CAROUSEL IN STANDALONE MODE");
        System.out.println("********************************************************************************");
        CCS.initializeScriptingEnvironment();
        carouselSubsystem = BootUtils.getSubsystemFromFile((String)"testSftCarouselClamp", (String)"");
        carouselSubsystem.startAgent();
        carouselSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        lookup = carouselSubsystem.getComponentLookup();
        main = (CarouselMain)lookup.getComponentByName("main");
        carousel = (Carousel)lookup.getComponentByName("carousel");
        carousel.updateStateWithSensors();
        plutoGateway = (SimuCarouselStandalonePlutoGateway)lookup.getComponentByName("fakePlutoGateway");
        ai814 = (SimuCanOpenADC)lookup.getComponentByName("ai814");
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("*******************************************************************");
        System.out.println("********* end of TESTS OF CAROUSEL IN STANDALONE MODE *************");
        System.out.println("*******************************************************************");
        carouselSubsystem.shutdown();
        carouselSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
        CCS.shutdownScriptingEnvironment();
    }

    @Before
    public void setUp() throws FcsHardwareException, DriverException {
        System.out.println("#############################################");
        System.out.println("###            CarouselTest               ###");
        System.out.println("###Go back to initial conditions:");
        System.out.println("###   socket1 at STANDBY");
        System.out.println("###   carousel holding a filter at STANDBY");
        System.out.println("###   socket at STANDBY CLAMPEDONFILTER");
        System.out.println("#############################################");
        carouselSubsystem.getAlertService().clearAllAlerts();
        carouselController.setSsiPosition(socket1StandbyPos);
        carousel.updatePosition();
        Assert.assertEquals((String)"carousel position is socket1 STANDBY position", (long)socket1StandbyPos, (long)carousel.getPosition());
        Assert.assertEquals((String)"socket in STANDBY is socket1", (Object)"socket1", (Object)carousel.getSocketAtStandby().getName());
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"carousel is holding a filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        Assert.assertTrue((String)"Socket at STANDBY is LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testClamps() throws FcsHardwareException, DriverException {
        System.out.println("*** test of clamps state ***");
        for (int i = 1; i < 5; ++i) {
            String clampXminusName = "clampXminus" + i;
            System.out.println("Checking ClampState for " + clampXminusName);
            CarouselClamp clampXminus = (CarouselClamp)lookup.getComponentByName(clampXminusName);
            Assert.assertTrue((String)(clampXminusName + " contains a filter."), (boolean)clampXminus.isFilterEngaged());
            Assert.assertTrue((String)(clampXminusName + " is LOCKED."), (boolean)clampXminus.isLocked());
            String clampXplusName = "clampXplus" + i;
            System.out.println("Checking ClampState for " + clampXplusName);
            CarouselClamp clampXplus = (CarouselClamp)lookup.getComponentByName(clampXplusName);
            Assert.assertTrue((String)(clampXplusName + " contains a filter."), (boolean)clampXplus.isFilterEngaged());
            Assert.assertTrue((String)(clampXplusName + " is LOCKED."), (boolean)clampXplus.isLocked());
        }
        System.out.println("Test clamps state is in error state");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsUNLOCKED();
        try {
            carousel.updateStateWithSensors();
            Assert.fail((String)"Clamps state are in error. Should raise an Exception: ClampsOrLatchesDisagreeException");
        }
        catch (FcsHardwareException ex) {
            System.out.println("Clamps state are in error. Exception raised: " + (Object)((Object)ex));
        }
        System.out.println("Test unLockClamps when a filter is not clamped at standby");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsUNLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsUNLOCKED();
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"Clamps at STANDBY are not ClampedOnFilter.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
        try {
            carousel.unlockClamps();
            Assert.fail((String)"Clamps at STANDBY are not ClampedOnFilter. unlockClamps should raise an Exception.");
        }
        catch (FailedCommandException | RejectedCommandException ex) {
            System.out.println("Clamps at STANDBY are not ClampedOnFilter. Raised exception=" + ex);
        }
        System.out.println("Go back to initial conditions");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testClampSensors() throws DriverException {
        System.out.println("*** testClampSensors ***");
        try {
            carousel.unlockClamps();
            Assert.fail((String)"Filter is not held by fakeAutochanger. unlockClamps should raise an Exception.");
        }
        catch (FailedCommandException | RejectedCommandException ex) {
            System.out.println("Filter is not held by fakeAutochanger. Raised exception=" + ex);
        }
        plutoGateway.simulateAutochangerIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"carousel is still holding filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        Assert.assertTrue((String)"filter is also held by autochanger", (boolean)carousel.isAutochangerHoldingFilter());
        carousel.unlockClamps();
        Assert.assertEquals((String)"socket at STANDBY is ", (Object)FcsEnumerations.FilterClampState.UNCLAMPEDONFILTER, (Object)carousel.getSocketAtStandby().getClampsState());
        for (int i = 2; i < 5; ++i) {
            String socketName = "socket" + i;
            Assert.assertEquals((String)"sockets else than socket1 are CLAMPEDONFILTER", (Object)FcsEnumerations.FilterClampState.CLAMPEDONFILTER, (Object)carousel.getSocketByName(socketName).getClampsState());
        }
        System.out.println("Go back to initial conditions");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }

    @Test
    public void testIsHoldingFilter() throws FcsHardwareException, DriverException {
        System.out.println("*** test of isHoldingFilterAtStandby ***");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsUNLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsUNLOCKED();
        carousel.updateStateWithSensors();
        Assert.assertFalse((String)"carousel is NOT holding a filter at STANDBY", (boolean)carousel.isHoldingFilterAtStandby());
        System.out.println("Go back to initial conditions");
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXminus().getLockSensor()).simulateClampIsLOCKED();
        ((SimuCarouselClampLockSensor)carousel.getSocketAtStandby().getClampXplus().getLockSensor()).simulateClampIsLOCKED();
        carousel.updateStateWithSensors();
        Assert.assertTrue((String)"Clamps at STANDBY are LOCKED again.", (boolean)carousel.getSocketAtStandby().isClampedOnFilter());
    }
}

