/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.DigitalSensor;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.ForceSensor;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.LoaderCarrier;
import org.lsst.ccs.subsystems.fcs.LoaderClamp;
import org.lsst.ccs.subsystems.fcs.LoaderHook;
import org.lsst.ccs.subsystems.fcs.LoaderMain;
import org.lsst.ccs.subsystems.fcs.RedondantSensors;
import org.lsst.ccs.subsystems.fcs.common.BinarySensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderStandalonePlutoGateway;

public class SimuLoaderPlutoGatewayTest {
    private static final String PLUTOGATEWAY_NAME = "loaderPlutoGateway";
    private static Subsystem loaderSubsystem = null;
    private static LoaderMain main;
    private static Loader loader;
    private static LoaderCarrier carrier;
    private static LoaderClamp clamp;
    private static SimuLoaderStandalonePlutoGateway plutoGateway;
    private static RedondantSensors handoffSensors;
    private static DigitalSensor clampedStatusSensor;
    private static ForceSensor forceSensor0;
    private static ForceSensor forceSensor1;
    private static DigitalSensor autochangerHoldingFilterSensor;
    private static DigitalSensor loaderCloseSensor3;
    private static DigitalSensor loaderOpenSensor3;
    private static LoaderHook hook3;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("     TESTS OF SimuLoaderPlutoGateway   ");
        System.out.println("***************************************");
        loaderSubsystem = BootUtils.getSubsystemFromFile((String)"loader__simulation");
        loaderSubsystem.startAgent();
        boolean started = loaderSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"subsystem not started", (boolean)started);
        ComponentLookup lookup = loaderSubsystem.getComponentLookup();
        loader = (Loader)lookup.getComponentByName("loader");
        main = (LoaderMain)lookup.getComponentByName("main");
        carrier = (LoaderCarrier)lookup.getComponentByName("carrier");
        clamp = (LoaderClamp)lookup.getComponentByName("clamp");
        plutoGateway = (SimuLoaderStandalonePlutoGateway)lookup.getComponentByName(PLUTOGATEWAY_NAME);
        handoffSensors = (RedondantSensors)lookup.getComponentByName("loaderHandoffSensors");
        clampedStatusSensor = (DigitalSensor)lookup.getComponentByName("clampedStatusSensor");
        forceSensor0 = (ForceSensor)lookup.getComponentByName("forceSensor0");
        forceSensor1 = (ForceSensor)lookup.getComponentByName("forceSensor1");
        autochangerHoldingFilterSensor = (DigitalSensor)lookup.getComponentByName("autochangerHoldingFilterSensor");
        loaderCloseSensor3 = (DigitalSensor)lookup.getComponentByName("loaderCloseSensor3");
        loaderOpenSensor3 = (DigitalSensor)lookup.getComponentByName("loaderOpenSensor3");
        hook3 = (LoaderHook)lookup.getComponentByName("hook3");
    }

    @AfterClass
    public static void after() throws Exception {
        loaderSubsystem.shutdown();
        loaderSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testSimuBinarySensorOn() {
        System.out.println("### simuBinarySensorOn");
        plutoGateway.simuBinarySensorOn((BinarySensor)handoffSensors);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"handoffSensors are ON", (boolean)handoffSensors.isOn());
    }

    @Test
    public void testSimuBinarySensorOff() {
        System.out.println("### simuBinarySensorOff");
        plutoGateway.simuBinarySensorOff((BinarySensor)handoffSensors);
        loader.updateStateWithSensors();
        Assert.assertFalse((String)"handoffSensors are OFF", (boolean)handoffSensors.isOn());
    }

    @Test
    public void testSimuRedondantSensorsInError() {
        System.out.println("### simuRedondantSensorsInError");
        plutoGateway.simuRedondantSensorsInError(handoffSensors);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"handoffSensors are in error", (boolean)handoffSensors.isInError());
    }

    @Test
    public void testSimulateLoaderClampIsClosed() {
        System.out.println("### simulateLoaderClampIsClosed");
        plutoGateway.simulateLoaderClampIsClosed();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is now closed", (boolean)clamp.isClosed());
    }

    @Test
    public void testSimulateLoaderClampIsClamped() {
        System.out.println("### simulateLoaderClampIsClamped");
        plutoGateway.simulateLoaderClampIsClamped();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is now clamped", (boolean)clamp.isClamped());
    }

    @Test
    public void testSimulateLoaderClampIsOpened() {
        System.out.println("### simulateLoaderClampIsOpened");
        plutoGateway.simulateLoaderClampIsOpened();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is now opened", (boolean)clamp.isOpened());
    }

    @Test
    public void testSimulateLoaderClampIsInTravel() {
        System.out.println("### simulateLoaderClampIsInTravel");
        plutoGateway.simulateLoaderClampIsInTravel();
        loader.updateStateWithSensors();
        Assert.assertFalse((String)"clamp is not closed", (boolean)clamp.isClosed());
        Assert.assertFalse((String)"clamp is not opened", (boolean)clamp.isOpened());
        Assert.assertFalse((String)"clamp is not clamped", (boolean)clamp.isClamped());
    }

    @Test
    public void testSimulateClampIsInError() {
        System.out.println("### simulateClampIsInError");
        plutoGateway.simulateClampIsInError();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is in error", (boolean)clamp.isInError());
    }

    @Test
    public void testSimulateLoaderIsConnectedOnCamera() {
        System.out.println("### simulateLoaderIsConnectedOnCamera");
        plutoGateway.simulateLoaderIsConnectedOnCamera();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"loader is connected on camera", (boolean)loader.isConnectedOnCamera());
    }

    @Test
    public void testSimulateLoaderIsNotConnectedOnCamera() {
        System.out.println("### simulateLoaderIsNotConnectedOnCamera");
        plutoGateway.simulateLoaderIsNotConnectedOnCamera();
        loader.updateStateWithSensors();
        Assert.assertFalse((String)"loader is connected on camera", (boolean)loader.isConnectedOnCamera());
    }

    @Test
    public void testSimulateFilterIsOnLoader() {
        System.out.println("### simulateFilterIsOnLoader");
        plutoGateway.simulateFilterIsOnLoader();
        loader.updateStateWithSensors();
        Assert.assertFalse((String)"a filter is in loader", (boolean)loader.isEmpty());
    }

    @Test
    public void testSimulateFilterIsNotOnLoader() {
        System.out.println("simulateFilterIsNotOnLoader");
        plutoGateway.simulateFilterIsNotOnLoader();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"no filter is in loader", (boolean)loader.isEmpty());
    }

    @Test
    public void testSimulateLoaderCarrierIsAtStorage() {
        System.out.println("### simulateLoaderCarrierIsAtStorage");
        plutoGateway.simulateLoaderCarrierIsAtStorage();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"loader is at STORAGE", (boolean)carrier.isAtStorage());
        Assert.assertFalse((String)"loader is NOT at HANDOFF", (boolean)loader.isAtHandoff());
        Assert.assertFalse((String)"loader is NOT at ENGAGED", (boolean)carrier.isAtEngaged());
    }

    @Test
    public void testSimulateLoaderCarrierIsAtHandoff() {
        System.out.println("### simulateLoaderCarrierIsAtHandoff");
        plutoGateway.simulateLoaderCarrierIsAtHandoff();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"loader is at HANDOFF", (boolean)loader.isAtHandoff());
        Assert.assertFalse((String)"loader is NOT at STORAGE", (boolean)carrier.isAtStorage());
        Assert.assertFalse((String)"loader is NOT at ENGAGED", (boolean)carrier.isAtEngaged());
    }

    @Test
    public void testSimulateLoaderCarrierIsAtEngaged() {
        System.out.println("### simulateLoaderCarrierIsAtEngaged");
        plutoGateway.simulateLoaderCarrierIsAtEngaged();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"loader is at ENGAGED", (boolean)carrier.isAtEngaged());
        Assert.assertFalse((String)"loader is NOT at STORAGE", (boolean)carrier.isAtStorage());
        Assert.assertFalse((String)"loader is NOT at HANDOFF", (boolean)loader.isAtHandoff());
    }

    @Test
    public void testSimulateLoaderCarrierIsInTravel() {
        System.out.println("### simulateLoaderCarrierIsInTravel");
        plutoGateway.simulateLoaderCarrierIsInTravel();
        loader.updateStateWithSensors();
        Assert.assertFalse((String)"loader carrier is not at HANDOFF", (boolean)carrier.isAtHandoff());
        Assert.assertFalse((String)"loader carrier is not at STORAGE", (boolean)carrier.isAtStorage());
    }

    @Test
    public void testSimulateHandoffSensorsAreInError() {
        System.out.println("### simulateHandoffSensorsAreInError");
        plutoGateway.simulateHandoffSensorsAreInError();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"handoff sensors are in error", (boolean)handoffSensors.isInError());
    }

    @Test
    public void testSimulateStorageSensorsAreInError() {
        System.out.println("### simulateStorageSensorsAreInError");
        plutoGateway.simulateStorageSensorsAreInError();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"storage sensors are in error.", (boolean)carrier.isInError());
    }

    @Test
    public void testSimulateClampedStatusSensorIsOn() {
        System.out.println("### simulateClampedStatusSensorIsOn");
        plutoGateway.simulateClampedStatusSensorIsOn();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"force status sensor is on.", (boolean)clampedStatusSensor.isOn());
    }

    @Test
    public void testSimulateClampedStatusSensorIsOff() {
        System.out.println("### simulateClampedStatusSensorIsOff");
        plutoGateway.simulateClampedStatusSensorIsOff();
        loader.updateStateWithSensors();
        Assert.assertFalse((String)"force status sensor is off.", (boolean)clampedStatusSensor.isOn());
    }

    @Test
    public void testSimulateAutochangerIsHoldingFilter() {
        System.out.println("### simulateAutochangerIsHoldingFilter");
        plutoGateway.simulateAutochangerIsHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertTrue((String)"Autochanger is holding filter", (boolean)autochangerHoldingFilterSensor.isOn());
    }

    @Test
    public void testSimulateAutochangerIsNotHoldingFilter() {
        System.out.println("### simulateAutochangerIsNotHoldingFilter");
        plutoGateway.simulateAutochangerIsNotHoldingFilter();
        main.updateStateWithSensors();
        Assert.assertFalse((String)"Autochanger is not holding filter", (boolean)autochangerHoldingFilterSensor.isOn());
    }

    @Test
    public void testSimulateForceSensorsOn() {
        System.out.println("### testSimulateForceSensorsOn");
        plutoGateway.simulateForceSensorsOn();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"forceSensor0 is CLAMPED", (boolean)forceSensor0.isClamped());
        Assert.assertTrue((String)"forceSensor0.getForce() > 778", (forceSensor0.getForce() > 778.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"forceSensor1 is CLAMPED", (boolean)forceSensor1.isClamped());
        Assert.assertTrue((String)"forceSensor1.getForce() > 778", (forceSensor1.getForce() > 778.0 ? 1 : 0) != 0);
    }

    @Test
    public void testSimulateForceSensorsOff() {
        System.out.println("### testSimulateForceSensorsOff");
        plutoGateway.simulateForceSensorsOff();
        loader.updateStateWithSensors();
        Assert.assertFalse((String)"forceSensor0 is NOT CLAMPED", (boolean)forceSensor0.isClamped());
        Assert.assertTrue((String)"forceSensor0.getForce() < 30", (forceSensor0.getForce() < 30.0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"forceSensor1 is NOT CLAMPED", (boolean)forceSensor1.isClamped());
        Assert.assertTrue((String)"forceSensor1.getForce() < 30", (forceSensor1.getForce() < 30.0 ? 1 : 0) != 0);
    }

    @Test
    public void testSimulateClampIsUnknown() {
        System.out.println("simulateClampIsUnknown");
        plutoGateway.simulateClampIsUnknown();
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"Clamp lockStatus is UNKNOWN.", (clamp.getLockStatus() == FcsEnumerations.LockStatus.UNKNOWN ? 1 : 0) != 0);
    }

    @Test
    public void testSimulateHookIsClosed() {
        System.out.println("simulateHookIsClosed");
        plutoGateway.simulateHookIsClosed(loaderCloseSensor3, loaderOpenSensor3);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"hook 3 is closed", (hook3.getLockStatus() == FcsEnumerations.LockStatus.CLOSED ? 1 : 0) != 0);
    }

    @Test
    public void testSimulateHookIsOpened() {
        System.out.println("simulateHookIsOpened");
        plutoGateway.simulateHookIsOpened(loaderCloseSensor3, loaderOpenSensor3);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"hook 3 is open", (hook3.getLockStatus() == FcsEnumerations.LockStatus.OPENED ? 1 : 0) != 0);
    }

    @Test
    public void testSimulateHookIsInError() {
        System.out.println("simulateHookIsInError");
        plutoGateway.simulateHookIsInError(loaderCloseSensor3, loaderOpenSensor3);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"hook 3 is in error", (hook3.getLockStatus() == FcsEnumerations.LockStatus.ERROR ? 1 : 0) != 0);
        Assert.assertTrue((String)"clamp is in error", (clamp.getLockStatus() == FcsEnumerations.LockStatus.ERROR ? 1 : 0) != 0);
        Assert.assertTrue((String)"clamp is in error", (boolean)clamp.isInError());
    }

    @Test
    public void testSimulateHookIsInTravel() {
        System.out.println("simulateHookIsInTravel");
        plutoGateway.simulateHookIsInTravel(loaderCloseSensor3, loaderOpenSensor3);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"hook 3 is in Travel", (hook3.getLockStatus() == FcsEnumerations.LockStatus.INTRAVEL ? 1 : 0) != 0);
    }

    @Test
    public void testSimulateForceSensorClamped() {
        System.out.println("simulateForceSensorClamped");
        plutoGateway.simulateForceSensorClamped(forceSensor0, true);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"forceSensor is clamped", (boolean)forceSensor0.isClamped());
    }
}

