/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.subsystems.fcs.Loader;
import org.lsst.ccs.subsystems.fcs.LoaderClamp;
import org.lsst.ccs.subsystems.fcs.LoaderMain;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderStandalonePlutoGateway;

public class SimuLoaderClampControllerTest {
    private static ComponentLookup lookup;
    private static Subsystem loaderSubsystem;
    private static LoaderMain main;
    private static LoaderClamp clamp;
    private static Loader loader;
    private static SimuLoaderClampController clampController;
    private static SimuLoaderStandalonePlutoGateway gateway;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("******************************************************");
        System.out.println("TESTS OF LOADER CLAMP CONTROLLER IN STANDALONE MODE");
        System.out.println("******************************************************");
        loaderSubsystem = BootUtils.getSubsystemFromFile((String)"loader__simulation");
        loaderSubsystem.startAgent();
        loaderSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        lookup = loaderSubsystem.getComponentLookup();
        main = (LoaderMain)lookup.getComponentByName("main");
        clamp = (LoaderClamp)lookup.getComponentByName("clamp");
        clampController = (SimuLoaderClampController)lookup.getComponentByName("hooksController");
        loader = (Loader)lookup.getComponentByName("loader");
        gateway = (SimuLoaderStandalonePlutoGateway)lookup.getComponentByName("loaderPlutoGateway");
    }

    @AfterClass
    public static void after() throws Exception {
        loaderSubsystem.shutdown();
        loaderSubsystem.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 60L, TimeUnit.SECONDS);
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testWriteCurrent() {
        System.out.println("###writeCurrent");
        int aValue = 0;
        System.out.println("#aValue = " + aValue);
        clampController.writeCurrent(aValue);
        Assert.assertTrue((String)"target current is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("actual current is " + aValue), (SimuLoaderClampControllerTest.clampController.actualCurrent == aValue ? 1 : 0) != 0);
        aValue = 5000;
        System.out.println("#aValue = " + aValue);
        clampController.writeCurrent(aValue);
        Assert.assertTrue((String)"target current is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("actual current is " + aValue), (SimuLoaderClampControllerTest.clampController.actualCurrent == aValue ? 1 : 0) != 0);
        aValue = clamp.getCurrentToClamp();
        System.out.println("#aValue = " + aValue);
        clampController.writeCurrent(aValue);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"target current is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("actual current is " + aValue), (SimuLoaderClampControllerTest.clampController.actualCurrent == aValue ? 1 : 0) != 0);
        Assert.assertTrue((String)"clamp is CLAMPED", (boolean)clamp.isClamped());
        aValue = clamp.getCurrentToOpen();
        System.out.println("#aValue = " + aValue);
        clampController.writeCurrent(aValue);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"target current is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("actual current is " + aValue), (SimuLoaderClampControllerTest.clampController.actualCurrent == aValue ? 1 : 0) != 0);
        Assert.assertTrue((String)"clamp is OPENED", (boolean)clamp.isOpened());
    }

    @Test
    public void testWriteTargetPosition() {
        System.out.println("###writeTargetPosition");
        int positionToReached = 0;
        System.out.println("#positionToReached = " + positionToReached);
        clampController.writeTargetPosition(positionToReached);
        Assert.assertTrue((String)"target position is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("actual position is " + positionToReached), (SimuLoaderClampControllerTest.clampController.position == positionToReached ? 1 : 0) != 0);
        positionToReached = clamp.getTargetPositionToOpen();
        System.out.println("#positionToReached = " + positionToReached);
        clampController.writeTargetPosition(positionToReached);
        Assert.assertTrue((String)"target position is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("actual position is " + positionToReached), (SimuLoaderClampControllerTest.clampController.position == positionToReached ? 1 : 0) != 0);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is OPENED", (boolean)clamp.isOpened());
        positionToReached = clamp.getRelativePositionToClose();
        System.out.println("#positionToReached = " + positionToReached);
        clampController.writeTargetPosition(positionToReached);
        Assert.assertTrue((String)"target position is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("actual position is " + positionToReached), (SimuLoaderClampControllerTest.clampController.position == positionToReached ? 1 : 0) != 0);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is CLOSED", (boolean)clamp.isClosed());
        positionToReached = clamp.getTargetPositionToClamp();
        System.out.println("#positionToReached = " + positionToReached);
        clampController.writeTargetPosition(positionToReached);
        Assert.assertTrue((String)"target position is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("actual position is " + positionToReached), (SimuLoaderClampControllerTest.clampController.position == positionToReached ? 1 : 0) != 0);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is CLAMPED", (boolean)clamp.isClamped());
        positionToReached = clamp.getTargetPositionToClamp() + clamp.getRelativePositionToUnclamp();
        System.out.println("#positionToReached = " + positionToReached);
        clampController.writeTargetPosition(positionToReached);
        Assert.assertTrue((String)"target position is reached", (boolean)clampController.isTargetReached());
        Assert.assertTrue((String)("actual position is " + positionToReached), (SimuLoaderClampControllerTest.clampController.position == positionToReached ? 1 : 0) != 0);
        loader.updateStateWithSensors();
        Assert.assertTrue((String)"clamp is CLOSED", (boolean)clamp.isClosed());
    }

    static {
        loaderSubsystem = null;
    }
}

