/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenErrorsTable;

public class CanOpenErrorsTableTest
extends CcsTestCaseTemplate {
    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF READING CANopen errors tables");
        CanOpenErrorsTable.loadCanOpenErrorTables();
    }

    @AfterClass
    public static void tearDownClass() {
        System.out.println("********* end of CanOpenErrorsTable tests *************");
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetDeviceErrorNameByCode() throws Exception {
        System.out.println("getDeviceErrorNameByCode");
        CanOpenErrorsTable.loadCanOpenErrorTables();
        int aCode = 0;
        String expResult = "No Error";
        String result = CanOpenErrorsTable.getDeviceErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"Error 0000 is No Error", (Object)expResult, (Object)result);
        aCode = 65298;
        expResult = "Auxiliary Sensor Direction Error";
        result = CanOpenErrorsTable.getDeviceErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"Error FF12 is Auxiliary Sensor Direction Error", (Object)expResult, (Object)result);
        aCode = 1634578;
        expResult = "18f112=not found in /maxonMotorDeviceErrors.properties";
        result = CanOpenErrorsTable.getDeviceErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"Error 018F112 is 018F112=device error code not found in /maxonMotordeviceErrors.properties", (Object)expResult, (Object)result);
        aCode = 12832;
        expResult = "Undervoltage Error";
        result = CanOpenErrorsTable.getDeviceErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"Error 0x3220 is Undervoltage Error", (Object)expResult, (Object)result);
        aCode = 12832;
        expResult = "Undervoltage Error";
        result = CanOpenErrorsTable.getDeviceErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"Error 3220 is Undervoltage Error", (Object)expResult, (Object)result);
        aCode = 3220;
        expResult = "c94=not found in /maxonMotorDeviceErrors.properties";
        result = CanOpenErrorsTable.getDeviceErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"Error 3220 is Undervoltage Error", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetErrorRegisterNameByCode() {
        System.out.println("getErrorRegisterNameByCode");
        int aCode = 0;
        String expResult = "no errors";
        String result = CanOpenErrorsTable.getErrorRegisterNameByCode((int)aCode);
        Assert.assertEquals((String)"Error 00 is no errors", (Object)expResult, (Object)result);
        aCode = 128;
        expResult = "motion error";
        result = CanOpenErrorsTable.getErrorRegisterNameByCode((int)aCode);
        Assert.assertEquals((String)"Error 80 is motion error", (Object)expResult, (Object)result);
        aCode = 703710;
        expResult = "abcde=not found in /errorRegister.properties";
        result = CanOpenErrorsTable.getErrorRegisterNameByCode((int)aCode);
        Assert.assertEquals((String)"Error abcde is abcde=error register code not found in /errorRegister.properties", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetCommErrorNameByCode() {
        System.out.println("getCommErrorNameByCode");
        int aCode = 0;
        String expResult = "No Communication Error";
        String result = CanOpenErrorsTable.getCommErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"error 00000000 is No Communication Error", (Object)expResult, (Object)result);
        aCode = 251723705;
        expResult = "Error CAN ID";
        result = CanOpenErrorsTable.getCommErrorNameByCode((int)aCode);
        Assert.assertEquals((String)"error 0F00FFB9 is Error CAN ID", (Object)expResult, (Object)result);
        aCode = 0xF00FFBF;
        result = CanOpenErrorsTable.getCommErrorNameByCode((int)aCode);
        expResult = "Illegal Command Error";
        Assert.assertEquals((String)"error 0f00ffbf is 0F00FFBF and is Illegal Command Error", (Object)expResult, (Object)result);
        aCode = 43981;
        result = CanOpenErrorsTable.getCommErrorNameByCode((int)aCode);
        expResult = "abcd=not found in /commErrors.properties";
        Assert.assertEquals((String)"error TOTO is : TOTO=communication error code not found in /commError.properties", (Object)expResult, (Object)result);
    }
}

