/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.common.EmergencyMessage;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;

public class CanOpenEPOSTest
extends CcsTestCaseTemplate {
    private static Subsystem s;
    private static CanOpenEPOS controller;
    private static CanOpenProxy tcpProxy;
    private static final String name = "controller1";
    private static final Map<String, Integer> paramsForCurrent;
    private static final Map<String, Integer> paramsForProfilePosition;
    private static final Map<String, Integer> paramsForHoming;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("***************************************");
        System.out.println("TESTS OF CanOpenEPOS");
        System.out.println("***************************************");
        paramsForCurrent.put(EPOSEnumerations.Parameter.MotorType.toString(), 11);
        paramsForCurrent.put(EPOSEnumerations.Parameter.ContinuousCurrentLimit.toString(), 2360);
        paramsForCurrent.put(EPOSEnumerations.Parameter.OutputCurrentLimit.toString(), 4720);
        paramsForProfilePosition.put(EPOSEnumerations.Parameter.MotionProfileType.toString(), 0);
        paramsForHoming.put(EPOSEnumerations.Parameter.HomeOffset.toString(), 0);
        s = BootUtils.getSubsystemFromFile((String)"testCanOpenEPOS");
        s.startAgent();
        controller = (CanOpenEPOS)s.getComponentLookup().getComponentByName(name);
        CanOpenEPOSTest.controller.booted = true;
        tcpProxy = (CanOpenProxy)s.getComponentLookup().getComponentByName("main");
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        s.shutdown();
        System.out.println("********* end of CanOpenEPOS tests *************");
    }

    @Before
    public void setUp() {
        controller.resetError();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testIsEnabledToPublish() {
        System.out.println("isEnabledToPublish");
        CanOpenEPOS instance = controller;
        boolean expResult = false;
        boolean result = instance.isEnabledToPublish();
        Assert.assertEquals((String)"Controller is not enabled.", (Object)expResult, (Object)result);
    }

    @Test
    public void testCreateStatusDataPublishedByEPOSController() {
        System.out.println("getStatusData");
        String expResult = "controller1/isBooted=true/isInitialized=false/inError=false/Error Register=NO ERROR/Error History=";
        StatusDataPublishedByEPOSController status = controller.createStatusDataPublishedByEPOSController();
        Assert.assertTrue((String)status.toString(), (boolean)status.toString().startsWith(expResult));
        Assert.assertFalse((boolean)status.isEnabled());
        Assert.assertEquals((String)"Controller name is :controller", (Object)controller.getName(), (Object)status.getName());
    }

    @Test
    public void testCheckAndResetFault() throws InterruptedException {
        System.out.println("### checkFault");
        controller.checkFault();
        Assert.assertFalse((String)"simulated controller should not be in error", (boolean)CanOpenEPOSTest.controller.inError);
        Assert.assertFalse((String)"Subsystem should NOT be in ALARM State.", (boolean)s.isInState((Enum)AlertState.ALARM));
        EmergencyMessage emcy = new EmergencyMessage(controller.getNodeID(), controller.getName(), 16, "Error10", 848, "ERROR 350");
        controller.onEmergencyMessage(emcy);
        Assert.assertTrue((String)"simulated controller should be in error", (boolean)CanOpenEPOSTest.controller.inError);
        Assert.assertEquals((String)("controller errorRegister should be: " + emcy.getErrorRegisterName()), (Object)CanOpenEPOSTest.controller.errorRegister, (Object)emcy.getErrorRegisterName());
        controller.faultReset();
        Assert.assertFalse((String)"no more fault : controller should not be in error", (boolean)CanOpenEPOSTest.controller.inError);
        System.out.println("*** Simulate an emergency message coming from tcpProxy for controller");
        tcpProxy.onEmergencyMessage(controller.getNodeID(), 16912, 4);
        Assert.assertTrue((String)"Subsystem is in ALARM State.", (boolean)s.isInState((Enum)AlertState.ALARM));
        long beginTime = System.currentTimeMillis();
        long duration = 0L;
        long timeout = 500L;
        while (!CanOpenEPOSTest.controller.inError && duration < timeout) {
            System.out.println("waiting for controller.inError field to be update... duration = " + duration);
            duration = System.currentTimeMillis() - beginTime;
        }
        Assert.assertTrue((String)"controller should be in error", (boolean)CanOpenEPOSTest.controller.inError);
        controller.faultReset();
        Assert.assertFalse((String)"no more fault : controller should not be in error", (boolean)CanOpenEPOSTest.controller.inError);
        Assert.assertFalse((String)"Subsystem is NOT in ALARM State.", (boolean)s.isInState((Enum)AlertState.ALARM));
    }

    @Test
    public void testFaultReset() {
        System.out.println("### faultReset");
        controller.faultReset();
        Assert.assertFalse((String)"no fault : faultReset should not change anything", (boolean)CanOpenEPOSTest.controller.inError);
    }

    static {
        paramsForCurrent = new HashMap<String, Integer>();
        paramsForProfilePosition = new HashMap<String, Integer>();
        paramsForHoming = new HashMap<String, Integer>();
    }
}

