/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.Utils;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class PieceOfHardwareTest {
    private static int nodeID = 58;
    private static String serial = "756DDF";
    private static CanOpenDevice device;
    private static String deviceName;

    @BeforeClass
    public static void setUpClass() throws Exception {
        Subsystem s = BootUtils.getSubsystemFromFile((String)"testCanOpenDevice");
        device = (CanOpenDevice)s.getComponentLookup().getComponentByName(deviceName);
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        Utils.printJoliSetUp("PieceOfHardwareTest");
        device.setBooted(false);
        Assert.assertFalse((String)"device is not booted", (boolean)device.isBooted());
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetSerialNB() {
        System.out.println("getSerialNB");
        String expResult = serial;
        String result = device.getSerialNB();
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testGetNodeID() {
        System.out.println("getNodeID");
        int expResult = nodeID;
        int result = device.getNodeID();
        Assert.assertEquals((long)expResult, (long)result);
    }

    @Test
    public void testInitializeAndCheckHardware() {
        System.out.println("initializeAndCheckHardware");
        Assert.assertFalse((String)"Device is not booted so device should not be initialized.", (boolean)device.isInitialized());
        this.testCheckInitialized();
        device.setBooted(true);
        device.initializeAndCheckHardware();
        Assert.assertTrue((String)"Device is booted and should be now initialized.", (boolean)device.isInitialized());
    }

    @Test
    public void testCheckBooted() {
        System.out.println("checkBooted");
        try {
            device.checkBooted();
            Assert.fail((String)"Device is not booted :an Exception of type FcsHardwareException should have been raised.");
        }
        catch (FcsHardwareException ex) {
            System.out.println((Object)ex);
        }
    }

    private void testCheckInitialized() {
        System.out.println("checkInitialized");
        try {
            device.checkInitialized();
            Assert.fail((String)"Device is not initialized :an Exception of type FcsHardwareException should have been raised.");
        }
        catch (FcsHardwareException ex) {
            System.out.println((Object)ex);
        }
    }

    @Test
    public void testCreateStatusDataPublishedByHardware() {
        System.out.println("createStatusDataPublishedByHardware");
        StatusDataPublishedByHardware status = device.createStatusDataPublishedByHardware();
        Assert.assertEquals((String)"isBooted should be the same for device and status", (Object)device.isBooted(), (Object)status.isBooted());
        Assert.assertEquals((String)"isInitialized should be the same for device and status", (Object)device.isInitialized(), (Object)status.isInitialized());
    }

    static {
        deviceName = "device1";
    }
}

