/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.MobileItem;
import org.lsst.ccs.subsystems.fcs.errors.FailedCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

public class MobileItemToto
extends CcsTestCaseTemplate {
    private static Subsystem subs = null;
    private static MobileItemImpl item;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.out.println("*************************************************************");
        System.out.println("    TESTS OF CLASS MobileItem    ");
        System.out.println("*************************************************************");
        subs = BootUtils.getSubsystemFromFile((String)"testMobileItem", (String)"");
        subs.startAgent();
        subs.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        ComponentLookup lookup = subs.getComponentLookup();
        System.out.println("subsystem = " + subs.getName());
        item = (MobileItemImpl)((Object)lookup.getComponentByName("item"));
        Assert.assertTrue((String)"subsystem in in PhaseState.OPERATIONNAL", (boolean)subs.isInState((Enum)PhaseState.OPERATIONAL));
        Assert.assertEquals((String)"subs is my subsystem", (Object)subs, (Object)item.getSubsystem());
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        System.out.println("****************************************************");
        System.out.println("*** shutdown of mobil-item subsystem ***");
        System.out.println("****************************************************");
        subs.shutdown();
        subs.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
    }

    @Before
    public void setUp() {
        System.out.println("***************** setup *****************");
        MobileItemToto.item.count = 0;
        item.setReady(true);
        if (MobileItemToto.item.readSensorsHandle == null) {
            System.out.println("*** item.readSensorsHandle is null ***");
        } else if (MobileItemToto.item.readSensorsHandle.isCancelled()) {
            System.out.println("*** item.readSensorsHandle already cancelled ***");
        } else {
            item.cancelReadingSensors();
        }
        System.out.println("***************** end setup *****************");
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testIsMoving() {
        System.out.println("###isMoving");
        Assert.assertFalse((String)"item is not moving when no action", (boolean)item.isMoving());
    }

    @Test
    public void testGetHaltRequired() {
        System.out.println("###getHaltRequired");
        Assert.assertFalse((String)"no halt has been sent to subsystem", (boolean)item.getHaltRequired().get());
    }

    @Test
    public void testMyDevicesReady() {
        item.setReady(false);
        System.out.println("### myDevicesReady");
        Assert.assertFalse((String)"hardware is NOT ready", (boolean)item.myDevicesReady());
        item.setReady(true);
        Assert.assertTrue((String)"hardware is ready", (boolean)item.myDevicesReady());
    }

    @Test
    public void testIsActionCompleted() {
        System.out.println("isActionCompleted");
        Assert.assertFalse((String)"isActionCompleted false for OPEN action ", (boolean)item.isActionCompleted(FcsEnumerations.MobileItemAction.OPEN));
    }

    public void testAbortAction() {
        System.out.println("abortAction");
        FcsEnumerations.MobileItemAction action = null;
        long delay = 0L;
        MobileItemImpl instance = new MobileItemImpl();
        instance.abortAction(action, delay);
        Assert.fail((String)"The test case is a prototype.");
    }

    @Test
    public void testCheckReadyForAction() {
        System.out.println("###checkReadyForAction");
        System.out.println("#checkReadyForAction should raise an Exception because hardware not ready");
        item.setReady(false);
        try {
            item.checkReadyForAction();
        }
        catch (FcsHardwareException ex) {
            System.out.println(" raised a FcsHardwareException : " + (Object)((Object)ex));
        }
        System.out.println("#checkReadyForAction should not raise an Exception because hardware ready and no ALARM");
        item.setReady(true);
        Assert.assertFalse((String)"subsystem is not in ALARM", (boolean)subs.isInState((Enum)AlertState.ALARM));
        item.checkReadyForAction();
        Assert.assertTrue((String)"item is ready for action", (boolean)item.myDevicesReady());
        item.raiseAlarm(FcsEnumerations.FcsAlert.EMCY, "ALARM EMCY raised", item.getName());
        Assert.assertTrue((String)"subsystem is in ALARM", (boolean)subs.isInState((Enum)AlertState.ALARM));
        try {
            item.checkReadyForAction();
        }
        catch (FcsHardwareException ex) {
            System.out.println(" subs in ALARM state, raised a FcsHardwareException : " + (Object)((Object)ex));
        }
        item.clearAlarm(FcsEnumerations.FcsAlert.EMCY, item.getName());
        Assert.assertFalse((String)"subsystem is not in ALARM", (boolean)subs.isInState((Enum)AlertState.ALARM));
    }

    public void testExecuteActionWhichNeverComplete() {
        System.out.println("###executeActionWhichNeverComplete");
        System.out.println("#executeAction with action OPEN which is never completed");
        FcsEnumerations.MobileItemAction action = FcsEnumerations.MobileItemAction.OPEN;
        long timeoutForAction = 3000L;
        try {
            item.executeAction(action, timeoutForAction);
        }
        catch (FailedCommandException ex) {
            System.out.println(" executeAction raises a FailedCommandException, because isActionCompleted is always false for OPEN action: " + (Object)((Object)ex));
        }
        Assert.assertTrue((String)"readSensorsHandle should be cancelled", (boolean)MobileItemToto.item.readSensorsHandle.isCancelled());
    }

    @Test
    public void testExecuteActionWhichShouldNotComplete() {
        System.out.println("###executeActionWhichShouldNotComplete");
        FcsEnumerations.MobileItemAction action = FcsEnumerations.MobileItemAction.CLOSE;
        System.out.println("#executeAction CLOSE should complete");
        long timeoutForAction = 1000L;
        try {
            item.executeAction(action, timeoutForAction);
        }
        catch (FailedCommandException ex) {
            System.out.println(timeoutForAction + ":timeout two low. action should fail ex=" + (Object)((Object)ex));
            System.out.println("count = " + MobileItemToto.item.count);
        }
        timeoutForAction = 5000L;
        item.executeAction(action, timeoutForAction);
        Assert.assertEquals((String)"after executeAction for CLOSE, count should be = 5", (long)5L, (long)MobileItemToto.item.count);
        Assert.assertTrue((String)"action CLOSE is now completed", (boolean)item.isActionCompleted(action));
        Assert.assertTrue((String)"subsystem CommandState is READY", (boolean)subs.isInState((Enum)CommandState.READY));
    }

    public void testExecuteActionWhichShouldComplete() {
        System.out.println("###executeActionWhichShouldComplete");
        FcsEnumerations.MobileItemAction action = FcsEnumerations.MobileItemAction.CLOSE;
        System.out.println("#executeAction CLOSE should complete");
        long timeoutForAction = 5000L;
        item.executeAction(action, timeoutForAction);
        Assert.assertEquals((String)"after executeAction for CLOSE, count should be = 5", (long)5L, (long)MobileItemToto.item.count);
        Assert.assertTrue((String)"action CLOSE is now completed", (boolean)item.isActionCompleted(action));
        Assert.assertTrue((String)"subsystem CommandState is READY", (boolean)subs.isInState((Enum)CommandState.READY));
    }

    public void testAbort_0args() throws InterruptedException {
        System.out.println("abort");
        Assert.assertFalse((String)"no abort signal received", (boolean)item.getHaltRequired().get());
        item.abort();
        Assert.assertTrue((String)"an abort signal has been received", (boolean)item.getHaltRequired().get());
    }

    @Test
    public void testSignal() {
        System.out.println("signal");
        Signal signal = new Signal(SignalLevel.HALT);
        TreeWalkerDiag expResult = TreeWalkerDiag.HANDLING_CHILDREN;
        TreeWalkerDiag result = item.signal(signal);
        Assert.assertEquals((String)"always handling my children ", (Object)expResult, (Object)result);
        Assert.assertFalse((String)"item is not moving no HALT is required", (boolean)item.getHaltRequired().get());
    }

    public class MobileItemImpl
    extends MobileItem {
        boolean ready = false;
        volatile int count = 0;

        public void setReady(boolean ready) {
            this.ready = ready;
        }

        public boolean myDevicesReady() {
            return this.ready;
        }

        public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
            if (action == FcsEnumerations.MobileItemAction.OPEN) {
                return false;
            }
            System.out.println("isActionCompleted / count = " + this.count);
            return this.count == 5;
        }

        public void updateStateWithSensorsToCheckIfActionIsCompleted() {
            ++this.count;
            System.out.println("updated count = " + this.count);
        }

        public void startAction(FcsEnumerations.MobileItemAction action) {
            System.out.println("STARTING action " + action);
            System.out.println("count = " + this.count);
        }

        public void abortAction(FcsEnumerations.MobileItemAction action, long delay) {
        }

        public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) {
        }

        public void postAction(FcsEnumerations.MobileItemAction action) {
            System.out.println("postAction for action " + action);
        }

        public void publishData() {
        }
    }
}

