/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystems.fcs.CarouselClamp;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenADC;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenInterface;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClampController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClampFilterPresenceSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCarouselClampLockSensor;

public class SftCarouselClampToto {
    private static Subsystem subs = null;
    private static CarouselClamp clampXminus;
    private static SimuCarouselClampController clampController;
    private static ComponentLookup lookup;
    private static SimuCarouselClampFilterPresenceSensor filterPresenceSensor;
    private static SimuCarouselClampLockSensor lockSensor;
    private static SimuCanOpenInterface canInterface;
    private static CanOpenProxy tcpProxy;
    private static SimuCanOpenADC adc;

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("********************************************************************************");
        System.out.println("                   TESTS OF SINGLE-FILTER-TEST CAROUSEL CLAMP");
        System.out.println("********************************************************************************");
        subs = BootUtils.getSubsystemFromFile((String)"testSftCarouselClamp", (String)"");
        subs.startAgent();
        subs.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 60L, TimeUnit.SECONDS);
        lookup = subs.getComponentLookup();
        clampXminus = (CarouselClamp)lookup.getComponentByName("clampXminus");
        clampController = (SimuCarouselClampController)lookup.getComponentByName("clampXminusController");
        clampController.initializeAndCheckHardware();
        Assert.assertTrue((String)"carouselController is initialized", (boolean)clampController.isInitialized());
        filterPresenceSensor = (SimuCarouselClampFilterPresenceSensor)lookup.getComponentByName("filterPresenceXminus");
        lockSensor = (SimuCarouselClampLockSensor)lookup.getComponentByName("lockSensorXminus");
        canInterface = (SimuCanOpenInterface)lookup.getComponentByName("canInterface");
        tcpProxy = (CanOpenProxy)lookup.getComponentByName("tcpProxy");
        adc = (SimuCanOpenADC)lookup.getComponentByName("ai814");
        System.out.println("***  initialization ***");
        clampXminus.setController((EPOSController)clampController);
        System.out.println("getLockStatus");
        FcsEnumerations.LockStatus expResult = FcsEnumerations.LockStatus.UNKNOWN;
        FcsEnumerations.LockStatus result = clampXminus.getLockStatus();
        Assert.assertEquals((String)"At beginning LockStatus is UNKNOWN", (Object)expResult, (Object)result);
        System.out.println("=> adc = " + adc.toString());
        adc.initializeAndCheckHardware();
        System.out.println("=> canInterface pdoData=" + canInterface.sync().toString());
        System.out.println("=> tcpProxy pdoData=" + tcpProxy.sync().toString());
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("*******************************************************************");
        System.out.println("********* end of TESTS OF CAROUSEL CLAMP              *************");
        System.out.println("*******************************************************************");
        subs.shutdown();
        subs.waitFor(state -> state.isInState((Enum)PhaseState.OFF_LINE), 30L, TimeUnit.SECONDS);
    }

    @Before
    public void setUp() throws DriverException {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetCurrentToUnlock() {
        System.out.println("getCurrentToUnlock");
        int expResult = 1500;
        short result = clampXminus.getCurrentToUnlock();
        Assert.assertEquals((String)"currentToUnlock=1500", (long)expResult, (long)result);
    }

    @Test
    public void testGetLockSensorValueA() {
        System.out.println("getLockSensorValueA");
        int expResult = 5000;
        int result = clampXminus.getLockSensorValueA();
        Assert.assertEquals((String)"lockSensorValueA=5000", (long)expResult, (long)result);
    }

    @Test
    public void testGetLockSensorValueB() {
        System.out.println("getLockSensorValueB");
        int expResult = 28800;
        int result = clampXminus.getLockSensorValueB();
        Assert.assertEquals((String)"lockSensorValueB=28800", (long)expResult, (long)result);
    }

    @Test
    public void testGetLockSensorValueC() {
        System.out.println("getLockSensorValueC");
        int expResult = 32000;
        int result = clampXminus.getLockSensorValueC();
        Assert.assertEquals((String)"lockSensorValueB=32000", (long)expResult, (long)result);
    }

    @Test
    public void testGetFilterPresenceValueA() {
        System.out.println("getFilterPresenceValueA");
        int expResult = 1500;
        int result = clampXminus.getFilterPresenceValueA();
        Assert.assertEquals((String)"filterPresenceValueA=1500", (long)expResult, (long)result);
    }

    @Test
    public void testGetFilterPresenceValueB() {
        System.out.println("getFilterPresenceValueB");
        int expResult = 24400;
        int result = clampXminus.getFilterPresenceValueB();
        Assert.assertEquals((String)"filterPresenceValueB=24400", (long)expResult, (long)result);
    }

    @Test
    public void testGetFilterPresenceValueC() {
        System.out.println("getFilterPresenceValueC");
        int expResult = 32000;
        int result = clampXminus.getFilterPresenceValueC();
        Assert.assertEquals((String)"filterPresenceValueC=32000", (long)expResult, (long)result);
    }

    @Test
    public void testGetFilterPresenceSensor() {
        System.out.println("getFilterPresenceSensor");
        Assert.assertEquals((String)"filterPresenceSensor", (Object)filterPresenceSensor, (Object)clampXminus.getFilterPresenceSensor());
    }

    @Test
    public void testGetLockSensor() {
        System.out.println("getLockSensor");
        Assert.assertEquals((String)"lockSensor", (Object)lockSensor, (Object)clampXminus.getLockSensor());
    }

    @Test
    public void testMyDevicesReady() {
        System.out.println("myDevicesReady");
        Assert.assertTrue((String)"clamp simulated hardware is ready", (boolean)clampXminus.myDevicesReady());
    }

    @Test
    public void testIsLocked() {
        System.out.println("isLocked");
        lockSensor.simulateClampIsLOCKED();
        System.out.println("lockSensorValue=" + lockSensor.getValue());
        Assert.assertTrue((String)"lockSensor.getValue() < clamp.getLockSensorValueC()", (lockSensor.getValue() < clampXminus.getLockSensorValueC() ? 1 : 0) != 0);
        Assert.assertTrue((String)"lockSensor.getValue() < clamp.getLockSensorValueC()", (lockSensor.getValue() > clampXminus.getLockSensorValueB() ? 1 : 0) != 0);
        clampXminus.updateLockStatus();
        Assert.assertEquals((Object)FcsEnumerations.LockStatus.LOCKED, (Object)clampXminus.getLockStatus());
        Assert.assertTrue((String)"clamp is LOCKED", (boolean)clampXminus.isLocked());
        lockSensor.simulateClampIsUNLOCKED();
        clampXminus.updateLockStatus();
        Assert.assertEquals((Object)FcsEnumerations.LockStatus.UNLOCKED, (Object)clampXminus.getLockStatus());
        Assert.assertFalse((String)"clamp is UNLOCKED", (boolean)clampXminus.isLocked());
    }

    @Test
    public void testIsFilterEngaged() {
        System.out.println("isFilterEngaged");
        filterPresenceSensor.simulateFilterIsLockable();
        clampXminus.updateFilterPresenceStatus();
        Assert.assertEquals((Object)FcsEnumerations.FilterPresenceStatus.LOCKABLE, (Object)clampXminus.getFilterPresenceStatus());
        Assert.assertTrue((String)"filter is engaged", (boolean)clampXminus.isFilterEngaged());
        filterPresenceSensor.simulateNoFilter();
        clampXminus.updateFilterPresenceStatus();
        Assert.assertEquals((Object)FcsEnumerations.FilterPresenceStatus.NOFILTER, (Object)clampXminus.getFilterPresenceStatus());
        Assert.assertFalse((String)"filter is NOT engaged", (boolean)clampXminus.isFilterEngaged());
        filterPresenceSensor.simulateFilterIsNotLockable();
        clampXminus.updateFilterPresenceStatus();
        Assert.assertEquals((Object)FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE, (Object)clampXminus.getFilterPresenceStatus());
        Assert.assertFalse((String)"filter is NOT engaged", (boolean)clampXminus.isFilterEngaged());
    }

    @Test
    public void testUpdateState() throws DriverException {
        System.out.println("updateState");
        filterPresenceSensor.simulateNoFilter();
        Assert.assertTrue((String)"filterPresenceSensor.getValue() > clamp.getFilterPresenceValueC()", (filterPresenceSensor.getValue() > clampXminus.getFilterPresenceValueC() ? 1 : 0) != 0);
        System.out.println("filterPresenceSensor.getValue()=" + filterPresenceSensor.getValue());
        clampXminus.updateFilterPresenceStatus();
        System.out.println("filterPresenceSensor.getValue()=" + filterPresenceSensor.getValue());
        clampXminus.updateFilterPresenceStatus();
        System.out.println("filterPresenceSensor.getValue()=" + filterPresenceSensor.getValue());
        System.out.println("=> canInterface pdoData=" + canInterface.sync().toString());
        System.out.println("=> tcpProxy pdoData=" + tcpProxy.sync().toString());
        System.out.println("tcpProxy.updatePDOData()");
        tcpProxy.updatePDOData();
        System.out.println("=> canInterface pdoData=" + canInterface.sync().toString());
        System.out.println("=> tcpProxy pdoData=" + tcpProxy.sync().toString());
        clampXminus.updateFilterPresenceStatus();
        System.out.println("filterPresenceSensor.getValue() after tcpProxy.updatePDOData()=" + filterPresenceSensor.getValue());
        clampXminus.updateState();
        Assert.assertFalse((String)"clamp is no more updating", (boolean)SftCarouselClampToto.clampXminus.updatingState);
    }

    public void testRelease() {
        System.out.println("release");
        try {
            clampXminus.release();
        }
        catch (RejectedCommandException ex) {
            System.out.println("Clamp is not CLAMPEDONFILTER so command release should be rejected");
            System.out.println((Object)ex);
        }
        filterPresenceSensor.simulateNoFilter();
        lockSensor.simulateClampIsUNLOCKED();
        clampXminus.updateState();
        clampXminus.release();
        Assert.assertEquals((String)"clamp is now READYTOCLAMP", (Object)FcsEnumerations.FilterClampState.READYTOCLAMP, (Object)clampXminus.getClampState());
    }

    public void testUnlock() {
        System.out.println("unlock");
        clampXminus.unlock();
        Assert.assertFalse((String)"clamp is now UNLOCKED", (boolean)clampXminus.isLocked());
    }
}

