/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.subsystems.fcs.ForceSensor;

public class ForceSensorTest {
    static ForceSensor forceSensor;
    static int[] hexaValues;
    static int value;

    @BeforeClass
    public static void setUpClass() {
        forceSensor = new ForceSensor();
        ForceSensorTest.forceSensor.byteNumero = 0;
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        value = 16;
        forceSensor.updateValue(value);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetVoltage() {
        System.out.println("getAnalogValue");
        Assert.assertEquals((String)"voltage is 1600", (long)1600L, (long)forceSensor.getVoltage());
    }

    @Test
    public void testGetForce() {
        System.out.println("getForce");
        Assert.assertEquals((double)321.13, (double)forceSensor.getForce(), (double)0.0);
    }

    @Test
    public void testUpdateForce() {
        System.out.println("updateForce");
        Assert.assertEquals((double)1600.0, (double)forceSensor.getVoltage(), (double)0.0);
        value = 17;
        forceSensor.updateValue(value);
        Assert.assertEquals((double)1700.0, (double)forceSensor.getVoltage(), (double)0.0);
        value = 18;
        forceSensor.updateValue(value);
        Assert.assertEquals((double)1800.0, (double)forceSensor.getVoltage(), (double)0.0);
    }

    @Test
    public void testTransfertFunction() {
        System.out.println("transfertFunction");
        Assert.assertEquals((double)0.0, (double)forceSensor.transfertFunction(0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)forceSensor.transfertFunction(947), (double)0.0);
        Assert.assertEquals((double)25.21, (double)forceSensor.transfertFunction(1000), (double)1.0E-4);
        Assert.assertEquals((double)370.45, (double)forceSensor.transfertFunction(1700), (double)1.0E-4);
        Assert.assertEquals((double)419.77, (double)forceSensor.transfertFunction(1800), (double)1.0E-4);
        Assert.assertEquals((double)518.41, (double)forceSensor.transfertFunction(2000), (double)1.0E-4);
        Assert.assertEquals((double)789.67, (double)forceSensor.transfertFunction(2550), (double)1.0E-4);
        Assert.assertEquals((double)12108.61, (double)forceSensor.transfertFunction(25500), (double)1.0E-4);
    }

    @Test
    public void testIsClamped() {
        System.out.println("isClamped");
        Assert.assertFalse((String)"clamp is not CLAMPED", (boolean)forceSensor.isClamped());
        value = 26;
        forceSensor.updateValue(value);
        Assert.assertEquals((double)2600.0, (double)forceSensor.getVoltage(), (double)0.0);
        Assert.assertEquals((double)814.33, (double)forceSensor.getForce(), (double)1.0E-4);
        Assert.assertTrue((String)"clamp is CLAMPED", (boolean)forceSensor.isClamped());
        value = 255;
        forceSensor.updateValue(value);
        Assert.assertEquals((double)25500.0, (double)forceSensor.getVoltage(), (double)1.0E-4);
        Assert.assertEquals((double)12108.61, (double)forceSensor.getForce(), (double)1.0E-4);
        Assert.assertFalse((String)"clamp is NOT CLAMPED", (boolean)forceSensor.isClamped());
    }

    static {
        hexaValues = new int[1];
        value = 0;
    }
}

