/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.FilterManager;

public class FilterManagerTest
extends CcsTestCaseTemplate {
    private static Subsystem filterManagerSubsystem = null;
    private static FilterManager filterManager;
    private static Filter filterU;
    private static Filter filterG;
    private static Filter filterR;
    private static Filter filterI;
    private static Filter filterZ;
    private static Filter filterY;
    private static final String FILTER_U_NAME = "filterU";
    private static final String FILTER_G_NAME = "filterG";
    private static final String FILTER_R_NAME = "filterR";
    private static final String FILTER_I_NAME = "filterI";
    private static final String FILTER_Z_NAME = "filterZ";
    private static final String FILTER_Y_NAME = "filterY";

    @BeforeClass
    public static void before() throws Exception {
        System.out.println("***************************************");
        System.out.println("   TESTS OF FilterManager             ");
        System.out.println("***************************************");
        filterManagerSubsystem = BootUtils.getSubsystemFromFile((String)"filterManager__simulation", (String)"");
        filterManagerSubsystem.startAgent();
        ComponentLookup lookup = filterManagerSubsystem.getComponentLookup();
        filterManager = (FilterManager)lookup.getComponentByName("main");
        filterManager.init();
        filterU = (Filter)FilterManagerTest.filterManager.filtersMapByName.get(FILTER_U_NAME);
        filterG = (Filter)FilterManagerTest.filterManager.filtersMapByName.get(FILTER_G_NAME);
        filterR = (Filter)FilterManagerTest.filterManager.filtersMapByName.get(FILTER_R_NAME);
        filterI = (Filter)FilterManagerTest.filterManager.filtersMapByName.get(FILTER_I_NAME);
        filterZ = (Filter)FilterManagerTest.filterManager.filtersMapByName.get(FILTER_Z_NAME);
        filterY = (Filter)FilterManagerTest.filterManager.filtersMapByName.get(FILTER_Y_NAME);
        Assert.assertTrue((String)"At initialization filterY is OUT", (boolean)"OUT".equals(filterY.getSocketName()));
        Assert.assertTrue((String)"At initialization filterZ is on socket5", (boolean)"socket5".equals(filterZ.getSocketName()));
    }

    @AfterClass
    public static void after() throws Exception {
        System.out.println("****END of TESTS OF FilterManager******");
        System.out.println("***************************************");
        filterManagerSubsystem.shutdown();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDownClass() throws Exception {
    }

    @Test
    public void testSetFilterLocation() {
        System.out.println("testFilterLocation of class Filter");
        filterU.setFilterLocation(FcsEnumerations.FilterLocation.AUTOCHANGER);
        Assert.assertTrue((String)"filterU is now on Autochanger.", (boolean)filterU.isOnAutoChanger());
        filterU.setFilterLocation(FcsEnumerations.FilterLocation.CAROUSEL);
        Assert.assertFalse((String)"filterU is no more on Autochanger.", (boolean)filterU.isOnAutoChanger());
        filterU.setSocketName("socket1");
        System.out.println("testFilterLocation of class FilterManager");
        filterManager.setFilterLocation(filterG.getFilterID(), FcsEnumerations.FilterLocation.AUTOCHANGER);
        Assert.assertTrue((String)"filterG is now on Autochanger.", (boolean)filterG.isOnAutoChanger());
        filterManager.setFilterLocation(filterG.getFilterID(), FcsEnumerations.FilterLocation.CAROUSEL);
        Assert.assertFalse((String)"filterG is no more on Autochanger.", (boolean)filterG.isOnAutoChanger());
        filterG.setSocketName("socket2");
        int filterID = 28;
        try {
            filterManager.setFilterLocation(filterID, FcsEnumerations.FilterLocation.CAROUSEL);
            Assert.fail((String)(filterID + " is an invalid filterID. Should raise an IllegalArgumentException"));
        }
        catch (IllegalArgumentException ex) {
            System.out.println(filterID + " is an invalid filterID:" + ex);
        }
    }

    @Test
    public void testGetFilterOnAutochangerName() {
        System.out.println("getFilterOnAutochangerName");
        Assert.assertEquals((String)"filter on autochanger is null", null, (Object)filterManager.getFilterOnAutochangerName());
        filterU.setFilterLocation(FcsEnumerations.FilterLocation.AUTOCHANGER);
        Assert.assertTrue((String)"filterU is now on Autochanger.", (boolean)filterU.isOnAutoChanger());
        Assert.assertEquals((String)"socketName for filterU is now AC", (Object)"AC", (Object)filterU.getSocketName());
        Assert.assertEquals((String)"filter on autochanger is filterU", (Object)filterU.getName(), (Object)filterManager.getFilterOnAutochangerName());
        filterU.setFilterLocation(FcsEnumerations.FilterLocation.CAROUSEL);
        Assert.assertFalse((String)"filterU is no more on Autochanger.", (boolean)filterU.isOnAutoChanger());
        filterU.setSocketName("socket1");
    }

    @Test
    public void testRemoveFromCarousel() {
        System.out.println("removeFromCarousel");
        filterR.removeFromCarousel();
        Assert.assertTrue((String)"filterR is now on Autochanger", (boolean)filterR.isOnAutoChanger());
        Assert.assertEquals((String)"socketName for filterR is now AC", (Object)"AC", (Object)filterR.getSocketName());
        System.out.println("putFilterOnSocket");
        String socketName = "socket5";
        filterR.putFilterOnSocket(socketName);
        Assert.assertEquals((String)"socketName for filterR is socket5", (Object)socketName, (Object)filterR.getSocketName());
        Assert.assertTrue((String)"filterR is on Carousel", (boolean)filterR.isOnCarousel());
    }

    @Test
    public void testFilterToString() {
        System.out.println("toString");
        String expResult = "filterU:filterID:1,Weight:38.0,FilterLocation:CAROUSEL,socket:socket1";
        String result = filterU.toString();
        Assert.assertEquals((String)("filterU String representation is:" + expResult), (Object)expResult, (Object)result);
    }

    @Test
    public void testGetFiltersMap() {
        System.out.println("getFiltersMap");
        try {
            String result = filterManager.getFiltersMapByName().toString();
            System.out.println("Filter List Map=" + result);
        }
        catch (Exception ex) {
            Assert.fail((String)("getFiltersMap should not raise an Exception:" + ex));
        }
    }

    @Test
    public void testGetFilterByName() {
        System.out.println("getFilterByName");
        String filterName = FILTER_U_NAME;
        Filter expResult = filterU;
        Filter result = filterManager.getFilterByName(filterName);
        Assert.assertEquals((String)"getFilterByName(filterU) is filterU", (Object)expResult, (Object)result);
    }

    @Test
    public void testGetFilterNameByID() {
        System.out.println("getFilterNameByID");
        int filterID = 2;
        Assert.assertEquals((String)"filter 2 is filterG", (Object)FILTER_G_NAME, (Object)filterManager.getFilterNameByID(filterID));
    }

    @Test
    public void testGetFilterNamesSortedByFilterID() {
        System.out.println("getFilterNamesSortedByFilterID");
        List result = filterManager.getFilterNamesSortedByFilterID();
        Assert.assertTrue((String)"getFilterNamesSortedByFilterID contains filterU", (boolean)result.contains(FILTER_U_NAME));
        Assert.assertTrue((String)"getFilterNamesSortedByFilterID contains filterG", (boolean)result.contains(FILTER_G_NAME));
        Assert.assertTrue((String)"getFilterNamesSortedByFilterID contains filterR", (boolean)result.contains(FILTER_R_NAME));
        Assert.assertTrue((String)"getFilterNamesSortedByFilterID contains filterI", (boolean)result.contains(FILTER_I_NAME));
        Assert.assertTrue((String)"getFilterNamesSortedByFilterID contains filterZ", (boolean)result.contains(FILTER_Z_NAME));
        Assert.assertTrue((String)"getFilterNamesSortedByFilterID contains filterY", (boolean)result.contains(FILTER_Y_NAME));
        ArrayList<String> expResult = new ArrayList<String>();
        expResult.add(FILTER_U_NAME);
        expResult.add(FILTER_G_NAME);
        expResult.add(FILTER_R_NAME);
        expResult.add(FILTER_I_NAME);
        expResult.add(FILTER_Z_NAME);
        expResult.add(FILTER_Y_NAME);
        Assert.assertTrue((String)"getFilterNamesSortedByFilterID contains filterY", (boolean)result.containsAll(expResult));
    }

    @Test
    public void testCheckFilterName() {
        System.out.println("checkFilterName");
        String filterName = "";
        try {
            filterManager.checkFilterName(filterName);
            Assert.fail((String)"null filter name. Should raise IllegalArgument Exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            filterManager.checkFilterName(FILTER_R_NAME);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)"filterR is a valid filter name. Should NOT raise IllegalArgument Exception.");
        }
    }

    @Test
    public void testToString() {
        System.out.println("toString");
        try {
            String result = filterManager.toString();
            System.out.println("filterManager.toString()=" + result);
        }
        catch (Exception ex) {
            Assert.fail((String)("toString should not raise an Exception:" + ex));
        }
    }
}

